/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CollectionTableRef;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.PartitionSet;
import org.apache.impala.analysis.SingleTableStmt;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TDropStatsParams;
import org.apache.impala.thrift.TTableName;

public class DropStatsStmt
extends StatementBase
implements SingleTableStmt {
    protected final TableName tableName_;
    protected TableRef tableRef_;
    private final PartitionSet partitionSet_;

    public DropStatsStmt(TableName tableName) {
        this.tableName_ = (TableName)Preconditions.checkNotNull((Object)tableName);
        this.partitionSet_ = null;
    }

    public DropStatsStmt(TableName tableName, PartitionSet partitionSet) {
        this.tableName_ = (TableName)Preconditions.checkNotNull((Object)tableName);
        this.partitionSet_ = partitionSet;
    }

    @Override
    public TableName getTableName() {
        return this.tableName_;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder("DROP ");
        if (this.partitionSet_ == null) {
            sb.append(" STATS ");
            if (this.tableName_.getDb() != null) {
                sb.append(this.tableName_.getDb() + ".");
            }
            sb.append(this.tableName_.toSql());
        } else {
            sb.append(" INCREMENTAL STATS ");
            if (this.tableName_.getDb() != null) {
                sb.append(this.tableName_.getDb() + ".");
            }
            sb.append(this.tableName_.toSql());
            sb.append(this.partitionSet_.toSql(options));
        }
        return sb.toString();
    }

    public TDropStatsParams toThrift() {
        TDropStatsParams params = new TDropStatsParams();
        params.setTable_name(new TTableName(this.getDb(), this.getTbl()));
        if (this.partitionSet_ != null) {
            params.setPartition_set(this.partitionSet_.toThrift());
        }
        return params;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.tableRef_ = new TableRef(this.tableName_.toPath(), null, Privilege.ALTER);
        this.tableRef_ = analyzer.resolveTableRef(this.tableRef_);
        Preconditions.checkNotNull((Object)this.tableRef_);
        if (this.tableRef_ instanceof InlineViewRef) {
            throw new AnalysisException(String.format("DROP STATS not allowed on a view: %s", this.tableName_));
        }
        if (this.tableRef_ instanceof CollectionTableRef) {
            throw new AnalysisException(String.format("DROP STATS not allowed on a nested collection: %s", this.tableName_));
        }
        this.tableRef_.analyze(analyzer);
        FeTable table_ = analyzer.getTable(this.tableName_, Privilege.ALTER);
        if (!(table_ instanceof FeFsTable) && this.partitionSet_ != null) {
            throw new AnalysisException("DROP INCREMENTAL STATS ... PARTITION not supported for non-filesystem-based table " + this.tableName_);
        }
        if (table_ instanceof FeIcebergTable && this.partitionSet_ != null) {
            throw new AnalysisException("DROP INCREMENTAL STATS ... PARTITION not supported for Iceberg table " + this.tableName_);
        }
        Analyzer.ensureTableNotTransactional(this.tableRef_.getTable(), "DROP STATS");
        if (this.partitionSet_ != null) {
            this.partitionSet_.setTableName(this.tableRef_.getTable().getTableName());
            this.partitionSet_.setPrivilegeRequirement(Privilege.ALTER);
            this.partitionSet_.setPartitionShouldExist();
            this.partitionSet_.analyze(analyzer);
        }
    }

    public String getDb() {
        Preconditions.checkNotNull((Object)this.tableRef_);
        return this.tableRef_.getTable().getDb().getName();
    }

    public String getTbl() {
        return this.tableName_.getTbl();
    }
}

