/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import java.util.ArrayList;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.FunctionArgs;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TDropFunctionParams;

public class DropFunctionStmt
extends StatementBase {
    private final FunctionName fnName_;
    private final FunctionArgs fnArgs_;
    private final boolean ifExists_;
    private Function desc_;

    public DropFunctionStmt(FunctionName fnName, FunctionArgs fnArgs, boolean ifExists) {
        this.fnName_ = fnName;
        this.fnArgs_ = fnArgs;
        this.ifExists_ = ifExists;
    }

    public boolean getIfExists() {
        return this.ifExists_;
    }

    private boolean hasSignature() {
        return this.fnArgs_ != null;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder("DROP FUNCTION");
        if (this.ifExists_) {
            sb.append(" IF EXISTS ");
        }
        sb.append(this.desc_.signatureString());
        sb.append(")");
        return sb.toString();
    }

    public TDropFunctionParams toThrift() {
        TDropFunctionParams params = new TDropFunctionParams();
        params.setFn_name(this.desc_.getFunctionName().toThrift());
        params.setArg_types(Type.toThrift(this.desc_.getArgs()));
        params.setIf_exists(this.getIfExists());
        if (this.hasSignature()) {
            params.setSignature(this.desc_.signatureString());
        }
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.fnName_.analyze(analyzer, false);
        if (this.hasSignature()) {
            this.fnArgs_.analyze(analyzer);
            this.desc_ = new Function(this.fnName_, this.fnArgs_.getArgTypes(), (Type)Type.INVALID, this.fnArgs_.hasVarArgs());
        } else {
            this.desc_ = new Function(this.fnName_, new ArrayList<Type>(), (Type)Type.INVALID, false);
        }
        this.registerFnPriv(analyzer, this.ifExists_ ? Privilege.ANY : Privilege.DROP);
        FeDb db = analyzer.getDb(this.desc_.dbName(), false);
        if (db == null) {
            if (this.ifExists_) {
                return;
            }
            throw new AnalysisException("Database does not exist: " + this.desc_.dbName());
        }
        if (!this.hasSignature() && db.getFunctions(this.desc_.functionName()).isEmpty()) {
            if (this.ifExists_) {
                return;
            }
            throw new AnalysisException("Function does not exist: " + this.desc_.functionName());
        }
        if (this.hasSignature() && analyzer.getCatalog().getFunction(this.desc_, Function.CompareMode.IS_IDENTICAL) == null) {
            if (this.ifExists_) {
                return;
            }
            throw new AnalysisException("Function does not exist: " + this.desc_.signatureString());
        }
        if (this.ifExists_) {
            this.registerFnPriv(analyzer, Privilege.DROP);
        }
    }

    private void registerFnPriv(Analyzer analyzer, Privilege priv) {
        analyzer.registerPrivReq(builder -> builder.onFunction(this.desc_.dbName(), this.desc_.signatureString()).allOf(priv).build());
    }
}

