/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.planner.DataSink;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.thrift.TBaseHelper;

public abstract class DmlStatementBase
extends StatementBase {
    protected FeTable table_;
    protected int maxTableSinks_ = 0;
    protected ByteBuffer kuduTxnToken_ = null;

    protected DmlStatementBase() {
    }

    protected DmlStatementBase(DmlStatementBase other) {
        super(other);
        this.table_ = other.table_;
        this.maxTableSinks_ = other.maxTableSinks_;
        this.kuduTxnToken_ = TBaseHelper.copyBinary((ByteBuffer)other.kuduTxnToken_);
    }

    @Override
    public void reset() {
        super.reset();
        this.table_ = null;
        this.kuduTxnToken_ = null;
    }

    public FeTable getTargetTable() {
        return this.table_;
    }

    protected void setTargetTable(FeTable tbl) {
        this.table_ = tbl;
    }

    public void setMaxTableSinks(int maxTableSinks) {
        this.maxTableSinks_ = maxTableSinks;
    }

    public boolean hasShuffleHint() {
        return false;
    }

    public boolean hasNoShuffleHint() {
        return false;
    }

    public boolean hasClusteredHint() {
        return false;
    }

    public boolean hasNoClusteredHint() {
        return false;
    }

    public abstract DataSink createDataSink();

    public abstract void substituteResultExprs(ExprSubstitutionMap var1, Analyzer var2);

    public abstract List<Expr> getPartitionKeyExprs();

    public abstract List<Expr> getSortExprs();

    public abstract TSortingOrder getSortingOrder();

    public ByteBuffer getKuduTransactionToken() {
        return this.kuduTxnToken_;
    }

    public void setKuduTransactionToken(byte[] kuduTxnToken) {
        Preconditions.checkState((boolean)(this.table_ instanceof FeKuduTable));
        Preconditions.checkNotNull((Object)kuduTxnToken);
        this.kuduTxnToken_ = ByteBuffer.wrap((byte[])kuduTxnToken.clone());
    }

    public static void checkSubQuery(SlotRef lhsSlotRef, Expr rhsExpr) throws AnalysisException {
        if (rhsExpr.contains(Subquery.class)) {
            throw new AnalysisException(String.format("Subqueries are not supported as update expressions for column '%s'", lhsSlotRef.toSql()));
        }
    }

    public static void checkCorrectTargetTable(SlotRef lhsSlotRef, Expr rhsExpr, TableRef tableRef) throws AnalysisException {
        if (!lhsSlotRef.isBoundByTupleIds(tableRef.getId().asList())) {
            throw new AnalysisException(String.format("Left-hand side column '%s' in assignment expression '%s=%s' does not belong to target table '%s'", lhsSlotRef.toSql(), lhsSlotRef.toSql(), rhsExpr.toSql(), tableRef.getDesc().getTable().getFullName()));
        }
    }

    public static void checkLhsIsColumnRef(SlotRef lhsSlotRef, Expr rhsExpr) throws AnalysisException {
        Column c = lhsSlotRef.getResolvedPath().destColumn();
        if (c == null) {
            throw new AnalysisException(String.format("Left-hand side in assignment expression '%s=%s' must be a column reference", lhsSlotRef.toSql(), rhsExpr.toSql()));
        }
    }

    public static Expr checkTypeCompatibility(Analyzer analyzer, Column c, Expr rhsExpr, TableRef tableRef) throws AnalysisException {
        return StatementBase.checkTypeCompatibility(tableRef.getDesc().getTable().getFullName(), c, rhsExpr, analyzer, null);
    }

    public static void checkLhsOnlyAppearsOnce(Map<Integer, Expr> colToExprs, Column c, SlotRef lhsSlotRef, Expr rhsExpr) throws AnalysisException {
        if (colToExprs.containsKey(c.getPosition())) {
            throw new AnalysisException(String.format("Left-hand side in assignment appears multiple times '%s=%s'", lhsSlotRef.toSql(), rhsExpr.toSql()));
        }
    }

    public static SlotRef createSlotRef(Analyzer analyzer, String tableName, String colName) throws AnalysisException {
        List<String> path = Path.createRawPath(tableName, colName);
        SlotRef ref = new SlotRef(path);
        ref.analyze(analyzer);
        return ref;
    }
}

