/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.IcebergTimeTravelTable;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.IdGenerator;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.thrift.TColumnType;
import org.apache.impala.thrift.TDescriptorTable;
import org.apache.impala.thrift.TDescriptorTableSerialized;

public class DescriptorTable {
    private final Map<TupleId, TupleDescriptor> tupleDescs_ = new HashMap<TupleId, TupleDescriptor>();
    private final Map<SlotId, SlotDescriptor> slotDescs_ = new HashMap<SlotId, SlotDescriptor>();
    private final IdGenerator<TupleId> tupleIdGenerator_ = TupleId.createGenerator();
    private final IdGenerator<SlotId> slotIdGenerator_ = SlotId.createGenerator();
    private FeTable targetTable_;
    private final Map<FeTable, Integer> additionalTargetTableIds_ = new HashMap<FeTable, Integer>();
    private final Map<FeTable, Set<Long>> referencedPartitionsPerTable_ = new HashMap<FeTable, Set<Long>>();
    public static final int TABLE_SINK_ID = 0;
    private int nextTableId_ = 1;

    public TupleDescriptor createTupleDescriptor(String debugName) {
        TupleDescriptor d = new TupleDescriptor(this.tupleIdGenerator_.getNextId(), debugName);
        this.tupleDescs_.put(d.getId(), d);
        return d;
    }

    public TupleDescriptor copyTupleDescriptor(TupleId srcId, String debugName) {
        TupleDescriptor d = new TupleDescriptor(this.tupleIdGenerator_.getNextId(), debugName);
        this.tupleDescs_.put(d.getId(), d);
        TupleDescriptor src = this.tupleDescs_.get(srcId);
        if (src.getPath() != null) {
            d.setPath(src.getPath());
        }
        for (SlotDescriptor slot : src.getSlots()) {
            this.copySlotDescriptor(d, slot);
        }
        d.computeMemLayout();
        Preconditions.checkState((d.getByteSize() == src.getByteSize() ? 1 : 0) != 0);
        return d;
    }

    public SlotDescriptor addSlotDescriptor(TupleDescriptor d) {
        SlotDescriptor result = new SlotDescriptor(this.slotIdGenerator_.getNextId(), d);
        d.addSlot(result);
        this.slotDescs_.put(result.getId(), result);
        return result;
    }

    public SlotDescriptor copySlotDescriptor(TupleDescriptor dest, SlotDescriptor src) {
        SlotDescriptor result = new SlotDescriptor(this.slotIdGenerator_.getNextId(), dest, src);
        dest.addSlot(result);
        this.slotDescs_.put(result.getId(), result);
        return result;
    }

    public TupleDescriptor getTupleDesc(TupleId id) {
        return this.tupleDescs_.get(id);
    }

    public SlotDescriptor getSlotDesc(SlotId id) {
        return this.slotDescs_.get(id);
    }

    public Collection<SlotDescriptor> getSlotDescs() {
        return this.slotDescs_.values();
    }

    public SlotId getMaxSlotId() {
        return this.slotIdGenerator_.getMaxId();
    }

    public void setTargetTable(FeTable table) {
        this.targetTable_ = table;
    }

    public int addTargetTable(FeTable table) {
        int id = this.nextTableId_++;
        this.additionalTargetTableIds_.put(table, id);
        return id;
    }

    private Set<Long> getReferencedPartitions(FeTable table) {
        Set<Long> refPartitions = this.referencedPartitionsPerTable_.get(table);
        if (refPartitions == null) {
            refPartitions = new HashSet<Long>();
            this.referencedPartitionsPerTable_.put(table, refPartitions);
        }
        return refPartitions;
    }

    public void addReferencedPartition(FeTable table, long partitionId) {
        this.getReferencedPartitions(table).add(partitionId);
    }

    public Set<TupleDescriptor> markSlotsMaterialized(List<SlotId> ids) {
        HashSet affectedTuples = Sets.newHashSet();
        for (SlotId id : ids) {
            SlotDescriptor slotDesc = this.getSlotDesc(id);
            if (slotDesc.isMaterialized()) continue;
            slotDesc.setIsMaterialized(true);
            this.materializeParentStructSlots(slotDesc);
            if (slotDesc.getParent().getParentSlotDesc() != null) continue;
            affectedTuples.add(slotDesc.getParent());
        }
        return affectedTuples;
    }

    private void materializeParentStructSlots(SlotDescriptor desc) {
        for (SlotDescriptor slotDesc : desc.getEnclosingStructSlotDescs()) {
            slotDesc.setIsMaterialized(true);
        }
    }

    public void computeMemLayout() {
        for (TupleDescriptor d : this.tupleDescs_.values()) {
            d.computeMemLayout();
        }
    }

    public TDescriptorTable toThrift() {
        TDescriptorTable result = new TDescriptorTable();
        ThriftSerializationCtx serialCtx = new ThriftSerializationCtx();
        HashMap<FeTable, Integer> tableIdMap = new HashMap<FeTable, Integer>();
        HashMap<TableName, FeTable> referencedTables = new HashMap<TableName, FeTable>();
        if (this.targetTable_ != null) {
            tableIdMap.put(this.targetTable_, 0);
            referencedTables.put(this.targetTable_.getTableName(), this.targetTable_);
        }
        for (Map.Entry<FeTable, Integer> tableIdEntry : this.additionalTargetTableIds_.entrySet()) {
            FeTable targetTable = tableIdEntry.getKey();
            tableIdMap.put(targetTable, tableIdEntry.getValue());
            referencedTables.put(targetTable.getTableName(), targetTable);
        }
        for (TupleDescriptor tupleDesc : this.tupleDescs_.values()) {
            if (!tupleDesc.isMaterialized()) continue;
            FeTable table = tupleDesc.getTable();
            Integer tableId = (Integer)tableIdMap.get(table);
            if (table != null && !(table instanceof FeView)) {
                TableName tblName = table.getTableName();
                FeTable checkTable = (FeTable)referencedTables.get(tblName);
                Preconditions.checkState((checkTable == null || this.isSameTableRef(table, checkTable) ? 1 : 0) != 0);
                if (tableId == null) {
                    tableId = this.nextTableId_++;
                    tableIdMap.put(table, tableId);
                    referencedTables.put(tblName, table);
                }
            }
            result.addToTupleDescriptors(tupleDesc.toThrift(tableId, serialCtx));
            for (SlotDescriptor slotD : tupleDesc.getMaterializedSlots()) {
                result.addToSlotDescriptors(slotD.toThrift(serialCtx));
            }
        }
        for (FeTable tbl : tableIdMap.keySet()) {
            Set<Long> referencedPartitions = null;
            if (tbl != this.targetTable_ && !this.additionalTargetTableIds_.containsKey(tbl)) {
                referencedPartitions = this.getReferencedPartitions(tbl);
            }
            result.addToTableDescriptors(tbl.toThriftDescriptor((Integer)tableIdMap.get(tbl), referencedPartitions));
        }
        return result;
    }

    private boolean isSameTableRef(FeTable first, FeTable second) {
        if (first instanceof IcebergTimeTravelTable) {
            first = ((IcebergTimeTravelTable)first).getBase();
        }
        if (second instanceof IcebergTimeTravelTable) {
            second = ((IcebergTimeTravelTable)second).getBase();
        }
        return first == second;
    }

    public TDescriptorTableSerialized toSerializedThrift() throws ImpalaException {
        TDescriptorTableSerialized result = new TDescriptorTableSerialized();
        TDescriptorTable desc_tbl = this.toThrift();
        result.setThrift_desc_tbl(JniUtil.serializeToThrift(desc_tbl));
        return result;
    }

    public String debugString() {
        StringBuilder out = new StringBuilder();
        out.append("tuples:\n");
        for (TupleDescriptor desc : this.tupleDescs_.values()) {
            out.append(desc.debugString() + "\n");
        }
        return out.toString();
    }

    public static TDescriptorTable buildTestDescriptorTable(List<List<TColumnType>> slotTypes) {
        DescriptorTable descTbl = new DescriptorTable();
        for (List<TColumnType> ttupleSlots : slotTypes) {
            ArrayList fields = Lists.newArrayListWithCapacity((int)ttupleSlots.size());
            for (TColumnType ttype : ttupleSlots) {
                fields.add(new StructField("testField", Type.fromThrift(ttype)));
            }
            StructType tupleType = new StructType(fields);
            DescriptorTable.createTupleDesc(tupleType, descTbl);
        }
        descTbl.computeMemLayout();
        return descTbl.toThrift();
    }

    private static TupleDescriptor createTupleDesc(StructType tupleType, DescriptorTable descTbl) {
        TupleDescriptor tupleDesc = descTbl.createTupleDescriptor("testDescTbl");
        for (StructField field : tupleType.getFields()) {
            Type type = field.getType();
            SlotDescriptor slotDesc = descTbl.addSlotDescriptor(tupleDesc);
            slotDesc.setIsMaterialized(true);
            slotDesc.setType(type);
            if (!type.isCollectionType()) continue;
            Preconditions.checkState((boolean)type.isArrayType());
            ArrayType arrayType = (ArrayType)type;
            Type itemType = arrayType.getItemType();
            StructType itemStruct = null;
            if (itemType.isStructType()) {
                itemStruct = (StructType)itemType;
            } else {
                ArrayList itemFields = Lists.newArrayListWithCapacity((int)1);
                itemFields.add(new StructField("item", itemType));
                itemStruct = new StructType(itemFields);
            }
            TupleDescriptor itemTuple = DescriptorTable.createTupleDesc(itemStruct, descTbl);
            slotDesc.setItemTupleDesc(itemTuple);
        }
        return tupleDesc;
    }
}

