/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SingleTableStmt;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TimeTravelSpec;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.thrift.TDescribeHistoryParams;
import org.apache.impala.util.ExprUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescribeHistoryStmt
extends StatementBase
implements SingleTableStmt {
    private static final Logger LOG = LoggerFactory.getLogger(TimeTravelSpec.class);
    protected final TableName tableName_;
    protected Expr from_;
    protected Expr betweenStartTime_;
    protected Expr betweenEndTime_;
    private final Kind kind_;
    protected FeTable table_;
    long fromMillis_;
    long betweenStartTimeMillis_;
    long betweenEndTimeMillis_;

    public DescribeHistoryStmt(TableName tableName) {
        this.tableName_ = (TableName)Preconditions.checkNotNull((Object)tableName);
        this.kind_ = Kind.NO_PREDICATE;
    }

    public DescribeHistoryStmt(TableName tableName, Expr from) {
        this.tableName_ = (TableName)Preconditions.checkNotNull((Object)tableName);
        this.from_ = (Expr)Preconditions.checkNotNull((Object)from);
        this.kind_ = Kind.FROM;
    }

    public DescribeHistoryStmt(TableName tableName, Expr between1, Expr between2) {
        this.tableName_ = (TableName)Preconditions.checkNotNull((Object)tableName);
        this.betweenStartTime_ = (Expr)Preconditions.checkNotNull((Object)between1);
        this.betweenEndTime_ = (Expr)Preconditions.checkNotNull((Object)between2);
        this.kind_ = Kind.BETWEEN;
    }

    @Override
    public TableName getTableName() {
        return this.tableName_;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.table_ = analyzer.getTable(this.tableName_, Privilege.VIEW_METADATA);
        Preconditions.checkNotNull((Object)this.table_);
        if (!(this.table_ instanceof FeIcebergTable)) {
            throw new AnalysisException(String.format("DESCRIBE HISTORY must specify an Iceberg table: %s", this.table_.getFullName()));
        }
        switch (this.kind_) {
            case FROM: {
                this.fromMillis_ = this.analyzeExpr(analyzer, this.from_);
                break;
            }
            case BETWEEN: {
                this.betweenStartTimeMillis_ = this.analyzeExpr(analyzer, this.betweenStartTime_);
                this.betweenEndTimeMillis_ = this.analyzeExpr(analyzer, this.betweenEndTime_);
                break;
            }
        }
    }

    private long analyzeExpr(Analyzer analyzer, Expr expr) throws AnalysisException {
        try {
            expr.analyze(analyzer);
        }
        catch (AnalysisException e) {
            throw new AnalysisException("Unsupported expression: '" + expr.toSql() + "'");
        }
        if (expr.getType().isStringType()) {
            expr = new CastExpr(Type.TIMESTAMP, expr);
        }
        if (!expr.getType().isTimestamp()) {
            throw new AnalysisException(this.kind_.toString() + " <expression> must be a timestamp type but is '" + expr.getType() + "': " + expr.toSql());
        }
        LOG.debug(this.kind_.toString() + " <expression>: " + String.valueOf(expr));
        long micros = 0L;
        try {
            micros = ExprUtil.localTimestampToUnixTimeMicros(analyzer, expr);
        }
        catch (InternalException ie) {
            throw new AnalysisException("Invalid TIMESTAMP expression: " + ie.getMessage(), ie);
        }
        return micros / 1000L;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        switch (this.kind_) {
            case FROM: {
                return "DESCRIBE HISTORY " + this.tableName_.toString() + " FROM " + this.from_.toSql();
            }
            case BETWEEN: {
                return "DESCRIBE HISTORY " + this.tableName_.toString() + " BETWEEN " + this.betweenStartTime_.toSql() + " AND " + this.betweenEndTime_.toSql();
            }
        }
        return "DESCRIBE HISTORY " + this.tableName_.toString();
    }

    public TDescribeHistoryParams toThrift() {
        TDescribeHistoryParams describeHistoryParams = new TDescribeHistoryParams();
        TableName tableName = new TableName(this.table_.getDb().getName(), this.table_.getName());
        describeHistoryParams.setTable_name(tableName.toThrift());
        switch (this.kind_) {
            case FROM: {
                describeHistoryParams.setFrom_time(this.fromMillis_);
                break;
            }
            case BETWEEN: {
                describeHistoryParams.setBetween_start_time(this.betweenStartTimeMillis_);
                describeHistoryParams.setBetween_end_time(this.betweenEndTimeMillis_);
                break;
            }
        }
        return describeHistoryParams;
    }

    public static enum Kind {
        FROM,
        BETWEEN,
        NO_PREDICATE;

    }
}

