/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FromClause;
import org.apache.impala.analysis.IcebergDeleteImpl;
import org.apache.impala.analysis.KuduDeleteImpl;
import org.apache.impala.analysis.ModifyStmt;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.DataSink;

public class DeleteStmt
extends ModifyStmt {
    public DeleteStmt(List<String> targetTablePath, FromClause tableRefs, Expr wherePredicate) {
        super(targetTablePath, tableRefs, new ArrayList<Pair<SlotRef, Expr>>(), wherePredicate);
    }

    public DeleteStmt(DeleteStmt other) {
        super(other.targetTablePath_, other.fromClause_.clone(), new ArrayList<Pair<SlotRef, Expr>>(), other.wherePredicate_.clone());
    }

    @Override
    protected void createModifyImpl() {
        if (this.table_ instanceof FeKuduTable) {
            this.modifyImpl_ = new KuduDeleteImpl(this);
        } else if (this.table_ instanceof FeIcebergTable) {
            this.modifyImpl_ = new IcebergDeleteImpl(this);
        }
    }

    @Override
    public DataSink createDataSink() {
        return this.modifyImpl_.createDataSink();
    }

    @Override
    public void substituteResultExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        this.modifyImpl_.substituteResultExprs(smap, analyzer);
    }

    @Override
    public DeleteStmt clone() {
        return new DeleteStmt(this);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        if (!options.showRewritten() && this.sqlString_ != null) {
            return this.sqlString_;
        }
        StringBuilder b = new StringBuilder();
        b.append("DELETE");
        if (this.fromClause_.size() > 1 || this.targetTableRef_.hasExplicitAlias()) {
            b.append(" ");
            if (this.targetTableRef_.hasExplicitAlias()) {
                b.append(this.targetTableRef_.getExplicitAlias());
            } else {
                b.append(this.targetTableRef_.toSql(options));
            }
        }
        b.append(this.fromClause_.toSql(options));
        if (this.wherePredicate_ != null) {
            b.append(" WHERE ");
            b.append(this.wherePredicate_.toSql(options));
        }
        return b.toString();
    }
}

