/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TDateLiteral;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;
import org.apache.impala.thrift.TParseDateStringResult;

public class DateLiteral
extends LiteralExpr {
    private final int daysSinceEpoch_;
    private final String strDate_;

    public DateLiteral(int daysSinceEpoch, String strDate) {
        this.daysSinceEpoch_ = daysSinceEpoch;
        this.strDate_ = strDate;
        this.type_ = Type.DATE;
    }

    public DateLiteral(String strDate) throws AnalysisException {
        TParseDateStringResult result;
        this.type_ = Type.DATE;
        try {
            result = FeSupport.parseDateString(strDate);
        }
        catch (InternalException e) {
            throw new AnalysisException("Error parsing date literal: " + e.getMessage(), e);
        }
        if (!result.valid || !result.isSetDays_since_epoch()) {
            throw new AnalysisException("Invalid date literal: '" + strDate + "'");
        }
        this.daysSinceEpoch_ = result.getDays_since_epoch();
        this.strDate_ = result.isSetCanonical_date_string() ? result.getCanonical_date_string() : strDate;
    }

    protected DateLiteral(DateLiteral other) {
        super(other);
        this.daysSinceEpoch_ = other.daysSinceEpoch_;
        this.strDate_ = other.strDate_;
    }

    @Override
    protected boolean localEquals(Expr that) {
        return super.localEquals(that) && this.daysSinceEpoch_ == ((DateLiteral)that).daysSinceEpoch_;
    }

    @Override
    public int hashCode() {
        return this.daysSinceEpoch_;
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        return "DATE '" + this.getStringValue() + "'";
    }

    @Override
    public String getStringValue() {
        return this.strDate_;
    }

    public int getValue() {
        return this.daysSinceEpoch_;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.DATE_LITERAL;
        msg.date_literal = new TDateLiteral();
        msg.date_literal.setDays_since_epoch(this.daysSinceEpoch_);
        msg.date_literal.setDate_string(this.strDate_);
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType, TypeCompatibility compatibility) throws AnalysisException {
        if (targetType.equals(this.type_)) {
            return this;
        }
        return new CastExpr(targetType, (Expr)this, compatibility);
    }

    @Override
    public int compareTo(LiteralExpr o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        DateLiteral other = (DateLiteral)o;
        return this.daysSinceEpoch_ - other.daysSinceEpoch_;
    }

    @Override
    public Expr clone() {
        return new DateLiteral(this);
    }
}

