/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CreateFunctionStmtBase;
import org.apache.impala.analysis.FunctionArgs;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.TypeDef;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.hive.executor.JavaUdfDataType;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.apache.impala.thrift.TSymbolType;

public class CreateUdfStmt
extends CreateFunctionStmtBase {
    public CreateUdfStmt(FunctionName fnName, FunctionArgs args, TypeDef retTypeDef, HdfsUri location, boolean ifNotExists, Map<CreateFunctionStmtBase.OptArg, String> optArgs) {
        super(fnName, args, retTypeDef, location, ifNotExists, optArgs);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        String closeFn;
        super.analyze(analyzer);
        Preconditions.checkNotNull((Object)this.fn_);
        Preconditions.checkState((boolean)(this.fn_ instanceof ScalarFunction));
        ScalarFunction udf = (ScalarFunction)this.fn_;
        if (this.hasSignature()) {
            int i;
            if (udf.getBinaryType() == TFunctionBinaryType.JAVA) {
                if (!JavaUdfDataType.isSupported(udf.getReturnType())) {
                    throw new AnalysisException("Type " + udf.getReturnType().toSql() + " is not supported for Java UDFs.");
                }
                for (i = 0; i < udf.getNumArgs(); ++i) {
                    if (JavaUdfDataType.isSupported(udf.getArgs()[i])) continue;
                    throw new AnalysisException("Type " + udf.getArgs()[i].toSql() + " is not supported for Java UDFs.");
                }
            }
            if (udf.getReturnType().getPrimitiveType() == PrimitiveType.CHAR) {
                throw new AnalysisException("UDFs that use CHAR are not yet supported.");
            }
            if (udf.getReturnType().getPrimitiveType() == PrimitiveType.VARCHAR) {
                throw new AnalysisException("UDFs that use VARCHAR are not yet supported.");
            }
            for (i = 0; i < udf.getNumArgs(); ++i) {
                if (udf.getArgs()[i].getPrimitiveType() == PrimitiveType.CHAR) {
                    throw new AnalysisException("UDFs that use CHAR are not yet supported.");
                }
                if (udf.getArgs()[i].getPrimitiveType() != PrimitiveType.VARCHAR) continue;
                throw new AnalysisException("UDFs that use VARCHAR are not yet supported.");
            }
        }
        udf.setSymbolName(udf.lookupSymbol(this.checkAndGetOptArg(CreateFunctionStmtBase.OptArg.SYMBOL), TSymbolType.UDF_EVALUATE, null, udf.hasVarArgs(), udf.getArgs()));
        String prepareFn = (String)this.optArgs_.get((Object)CreateFunctionStmtBase.OptArg.PREPARE_FN);
        if (prepareFn != null) {
            udf.setPrepareFnSymbol(udf.lookupSymbol(prepareFn, TSymbolType.UDF_PREPARE));
        }
        if ((closeFn = (String)this.optArgs_.get((Object)CreateFunctionStmtBase.OptArg.CLOSE_FN)) != null) {
            udf.setCloseFnSymbol(udf.lookupSymbol(closeFn, TSymbolType.UDF_CLOSE));
        }
        this.checkOptArgNotSet(CreateFunctionStmtBase.OptArg.UPDATE_FN);
        this.checkOptArgNotSet(CreateFunctionStmtBase.OptArg.INIT_FN);
        this.checkOptArgNotSet(CreateFunctionStmtBase.OptArg.SERIALIZE_FN);
        this.checkOptArgNotSet(CreateFunctionStmtBase.OptArg.MERGE_FN);
        this.checkOptArgNotSet(CreateFunctionStmtBase.OptArg.FINALIZE_FN);
        this.sqlString_ = udf.toSql(this.ifNotExists_);
        if (udf.getBinaryType() != TFunctionBinaryType.JAVA || this.ifNotExists_) {
            return;
        }
        Preconditions.checkNotNull((Object)this.db_);
        for (Function fn : this.db_.getFunctions(udf.functionName())) {
            if (this.hasSignature() && (!this.hasSignature() || !fn.isPersistent())) continue;
            throw new AnalysisException(String.format("Function already exists: " + fn.signatureString(), new Object[0]));
        }
    }

    @Override
    protected Function createFunction(FunctionName fnName, List<Type> argTypes, Type retType, boolean hasVarArgs) {
        return new ScalarFunction(fnName, argTypes, retType, hasVarArgs);
    }
}

