/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.KuduPartitionParam;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableDef;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.IcebergTable;
import org.apache.impala.catalog.KuduTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TAccessEvent;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TCreateTableLikeParams;
import org.apache.impala.thrift.THdfsFileFormat;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.thrift.TTableName;

public class CreateTableLikeStmt
extends StatementBase {
    private final TableName tableName_;
    private final List<String> sortColumns_;
    private final TSortingOrder sortingOrder_;
    private final TableName srcTableName_;
    private final boolean isExternal_;
    private final String comment_;
    private final THdfsFileFormat fileFormat_;
    private final HdfsUri location_;
    private final boolean ifNotExists_;
    private String dbName_;
    private String srcDbName_;
    private String owner_;
    private String serverName_;

    public CreateTableLikeStmt(TableName tableName, Pair<List<String>, TSortingOrder> sortProperties, TableName srcTableName, boolean isExternal, String comment, THdfsFileFormat fileFormat, HdfsUri location, boolean ifNotExists) {
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkNotNull((Object)srcTableName);
        this.tableName_ = tableName;
        this.sortColumns_ = (List)sortProperties.first;
        this.sortingOrder_ = (TSortingOrder)((Object)sortProperties.second);
        this.srcTableName_ = srcTableName;
        this.isExternal_ = isExternal;
        this.comment_ = comment;
        this.fileFormat_ = fileFormat;
        this.location_ = location;
        this.ifNotExists_ = ifNotExists;
    }

    public String getTbl() {
        return this.tableName_.getTbl();
    }

    public String getSrcTbl() {
        return this.srcTableName_.getTbl();
    }

    public boolean isExternal() {
        return this.isExternal_;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists_;
    }

    public THdfsFileFormat getFileFormat() {
        return this.fileFormat_;
    }

    public HdfsUri getLocation() {
        return this.location_;
    }

    public TSortingOrder getSortingOrder() {
        return this.sortingOrder_;
    }

    public String getDb() {
        Preconditions.checkNotNull((Object)this.dbName_);
        return this.dbName_;
    }

    public String getSrcDb() {
        Preconditions.checkNotNull((Object)this.srcDbName_);
        return this.srcDbName_;
    }

    public String getOwner() {
        Preconditions.checkNotNull((Object)this.owner_);
        return this.owner_;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder("CREATE ");
        if (this.isExternal_) {
            sb.append("EXTERNAL ");
        }
        sb.append("TABLE ");
        if (this.ifNotExists_) {
            sb.append("IF NOT EXISTS ");
        }
        if (this.tableName_.getDb() != null) {
            sb.append(this.tableName_.getDb() + ".");
        }
        sb.append(this.tableName_.getTbl() + " ");
        if (this.sortColumns_ != null && !this.sortColumns_.isEmpty()) {
            sb.append(String.format("SORT BY %s (%s) ", this.sortingOrder_.toString(), Joiner.on((String)",").join(this.sortColumns_)));
        }
        sb.append("LIKE ");
        if (this.srcTableName_.getDb() != null) {
            sb.append(this.srcTableName_.getDb() + ".");
        }
        sb.append(this.srcTableName_.getTbl());
        if (this.comment_ != null) {
            sb.append(" COMMENT '" + this.comment_ + "'");
        }
        if (this.fileFormat_ != null) {
            sb.append(" STORED AS " + (Object)((Object)this.fileFormat_));
        }
        if (this.location_ != null) {
            sb.append(" LOCATION '" + this.location_ + "'");
        }
        return sb.toString();
    }

    public TCreateTableLikeParams toThrift() {
        TCreateTableLikeParams params = new TCreateTableLikeParams();
        params.setTable_name(new TTableName(this.getDb(), this.getTbl()));
        params.setSrc_table_name(new TTableName(this.getSrcDb(), this.getSrcTbl()));
        params.setOwner(this.getOwner());
        params.setIs_external(this.isExternal());
        params.setComment(this.comment_);
        if (this.fileFormat_ != null) {
            params.setFile_format(this.fileFormat_);
        }
        params.setLocation(this.location_ == null ? null : this.location_.toString());
        params.setIf_not_exists(this.getIfNotExists());
        params.setSort_columns(this.sortColumns_);
        params.setServer_name(this.serverName_);
        params.setSorting_order(this.sortingOrder_);
        return params;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
        tblRefs.add(new TableRef(this.srcTableName_.toPath(), null));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((this.tableName_ != null && !this.tableName_.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this.srcTableName_ != null && !this.srcTableName_.isEmpty() ? 1 : 0) != 0);
        FeTable srcTable = analyzer.getTable(this.srcTableName_, Privilege.VIEW_METADATA);
        Analyzer.ensureTableNotBucketed(srcTable);
        this.validateCreateKuduTableParams(srcTable);
        if (this.fileFormat_ == THdfsFileFormat.ICEBERG && !IcebergTable.isIcebergTable(srcTable.getMetaStoreTable())) {
            throw new AnalysisException(srcTable.getFullName() + " cannot be cloned into an Iceberg table because it is not an Iceberg table.");
        }
        if (this.fileFormat_ == THdfsFileFormat.JDBC) {
            throw new AnalysisException("CREATE TABLE LIKE is not supported for JDBC tables.");
        }
        this.srcDbName_ = srcTable.getDb().getName();
        analyzer.getFqTableName(this.tableName_).analyze();
        this.dbName_ = analyzer.getTargetDbName(this.tableName_);
        this.owner_ = analyzer.getUserShortName();
        this.serverName_ = analyzer.getServerName();
        if (analyzer.dbContainsTable(this.dbName_, this.tableName_.getTbl(), Privilege.CREATE) && !this.ifNotExists_) {
            throw new AnalysisException("Table already exists: " + String.format("%s.%s", this.dbName_, this.getTbl()));
        }
        analyzer.addAccessEvent(new TAccessEvent(this.dbName_ + "." + this.tableName_.getTbl(), TCatalogObjectType.TABLE, Privilege.CREATE.toString()));
        if (this.location_ != null) {
            this.location_.analyze(analyzer, Privilege.ALL, FsAction.READ_WRITE);
        }
        if (this.sortColumns_ != null) {
            TableDef.analyzeSortColumns(this.sortColumns_, srcTable, this.sortingOrder_);
        }
    }

    private void validateCreateKuduTableParams(FeTable srcTable) throws AnalysisException {
        if (this.fileFormat_ == THdfsFileFormat.KUDU && !KuduTable.isKuduTable(srcTable.getMetaStoreTable()) || this.fileFormat_ != null && this.fileFormat_ != THdfsFileFormat.KUDU && KuduTable.isKuduTable(srcTable.getMetaStoreTable())) {
            throw new AnalysisException(String.format("%s cannot be cloned into a %s table: CREATE TABLE LIKE is not supported between Kudu tables and non-Kudu tables.", srcTable.getFullName(), this.fileFormat_.toString()));
        }
        if (this.sortColumns_ != null && KuduTable.isKuduTable(srcTable.getMetaStoreTable())) {
            throw new AnalysisException(srcTable.getFullName() + " cannot be cloned because SORT BY is not supported for Kudu tables.");
        }
        if (srcTable instanceof KuduTable) {
            KuduTable kuduTable = (KuduTable)srcTable;
            for (KuduPartitionParam kuduPartitionParam : kuduTable.getPartitionBy()) {
                if (kuduPartitionParam.getType() != KuduPartitionParam.Type.RANGE) continue;
                throw new AnalysisException("CREATE TABLE LIKE is not supported for Kudu tables having range partitions.");
            }
        }
    }
}

