/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.CreateTableStmt;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.DataSourceTable;
import org.apache.impala.catalog.FeDataSource;
import org.apache.impala.common.AnalysisException;

public class CreateTableDataSrcStmt
extends CreateTableStmt {
    public CreateTableDataSrcStmt(CreateTableStmt createTableStmt, String dataSourceName, String initString) {
        super(createTableStmt);
        Preconditions.checkNotNull((Object)dataSourceName);
        this.getTblProperties().put("__IMPALA_DATA_SOURCE_NAME", dataSourceName.toLowerCase());
        this.getTblProperties().put("__IMPALA_DATA_SOURCE_INIT_STRING", Strings.nullToEmpty((String)initString));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        String dataSourceName = this.getTblProperties().get("__IMPALA_DATA_SOURCE_NAME");
        FeDataSource dataSource = analyzer.getCatalog().getDataSource(dataSourceName);
        if (dataSource == null) {
            throw new AnalysisException("Data source does not exist: " + dataSourceName);
        }
        for (ColumnDef col : this.getColumnDefs()) {
            if (DataSourceTable.isSupportedColumnType(col.getType())) continue;
            throw new AnalysisException("Tables produced by an external data source do not support the column type: " + col.getType());
        }
        String location = dataSource.getLocation();
        this.getTblProperties().put("__IMPALA_DATA_SOURCE_LOCATION", location != null ? location : "");
        this.getTblProperties().put("__IMPALA_DATA_SOURCE_CLASS", dataSource.getClassName());
        this.getTblProperties().put("__IMPALA_DATA_SOURCE_API_VERSION", dataSource.getApiVersion());
        if (!Strings.isNullOrEmpty((String)location)) {
            new HdfsUri(location).analyze(analyzer, Privilege.ALL, FsAction.READ);
        }
    }
}

