/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.FunctionArgs;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TypeDef;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TCreateFunctionParams;
import org.apache.impala.thrift.TFunctionBinaryType;

public abstract class CreateFunctionStmtBase
extends StatementBase {
    protected final FunctionName fnName_;
    protected final FunctionArgs args_;
    protected final TypeDef retTypeDef_;
    protected final HdfsUri location_;
    protected final Map<OptArg, String> optArgs_;
    protected final boolean ifNotExists_;
    protected Function fn_;
    protected FeDb db_;
    protected String sqlString_;

    protected CreateFunctionStmtBase(FunctionName fnName, FunctionArgs args, TypeDef retTypeDef, HdfsUri location, boolean ifNotExists, Map<OptArg, String> optArgs) {
        Preconditions.checkState((!(args == null ^ retTypeDef == null) ? 1 : 0) != 0);
        this.fnName_ = fnName;
        this.args_ = args;
        this.retTypeDef_ = retTypeDef;
        this.location_ = location;
        this.ifNotExists_ = ifNotExists;
        this.optArgs_ = optArgs;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists_;
    }

    public boolean hasSignature() {
        return this.args_ != null;
    }

    public TCreateFunctionParams toThrift() {
        TCreateFunctionParams params = new TCreateFunctionParams(this.fn_.toThrift());
        params.setIf_not_exists(this.getIfNotExists());
        params.setFn(this.fn_.toThrift());
        return params;
    }

    public String checkAndGetOptArg(OptArg key) throws AnalysisException {
        if (!this.optArgs_.containsKey((Object)key)) {
            throw new AnalysisException("Argument '" + (Object)((Object)key) + "' must be set.");
        }
        return this.optArgs_.get((Object)key);
    }

    protected void checkOptArgNotSet(OptArg key) throws AnalysisException {
        if (this.optArgs_.containsKey((Object)key)) {
            throw new AnalysisException("Optional argument '" + (Object)((Object)key) + "' should not be set.");
        }
    }

    private TFunctionBinaryType getBinaryType() throws AnalysisException {
        TFunctionBinaryType binaryType = null;
        String binaryPath = this.fn_.getLocation().getLocation();
        int suffixIndex = binaryPath.lastIndexOf(".");
        if (suffixIndex != -1) {
            String suffix = binaryPath.substring(suffixIndex + 1);
            if (suffix.equalsIgnoreCase("jar")) {
                binaryType = TFunctionBinaryType.JAVA;
            } else if (suffix.equalsIgnoreCase("so")) {
                binaryType = TFunctionBinaryType.NATIVE;
            } else if (suffix.equalsIgnoreCase("ll")) {
                binaryType = TFunctionBinaryType.IR;
            }
        }
        if (binaryType == null) {
            throw new AnalysisException("Unknown binary type: '" + binaryPath + "'. Binary must end in .jar, .so or .ll");
        }
        return binaryType;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.fnName_.analyze(analyzer, false);
        if (this.hasSignature()) {
            this.args_.analyze(analyzer);
            this.retTypeDef_.analyze(analyzer);
            this.fn_ = this.createFunction(this.fnName_, this.args_.getArgTypes(), this.retTypeDef_.getType(), this.args_.hasVarArgs());
        } else {
            this.fn_ = this.createFunction(this.fnName_, null, null, false);
        }
        analyzer.registerPrivReq(builder -> builder.onFunction(this.fn_.dbName(), this.fn_.signatureString()).allOf(Privilege.CREATE).build());
        this.db_ = analyzer.getDb(this.fn_.dbName(), true);
        Function existingFn = this.db_.getFunction(this.fn_, Function.CompareMode.IS_INDISTINGUISHABLE);
        if (existingFn != null && !this.ifNotExists_) {
            throw new AnalysisException("Function already exists: " + existingFn.signatureString());
        }
        this.location_.analyze(analyzer, Privilege.ALL, FsAction.READ);
        this.fn_.setLocation(this.location_);
        this.fn_.setBinaryType(this.getBinaryType());
        if (this.hasSignature()) {
            ArrayList refdTypes = Lists.newArrayList((Object[])new Type[]{this.fn_.getReturnType()});
            refdTypes.addAll(Lists.newArrayList((Object[])this.fn_.getArgs()));
            for (Type t : refdTypes) {
                if (t.isSupported() && !t.isComplexType()) continue;
                throw new AnalysisException(String.format("Type '%s' is not supported in UDFs/UDAs.", t.toSql()));
            }
        } else if (this.fn_.getBinaryType() != TFunctionBinaryType.JAVA) {
            throw new AnalysisException(String.format("Native functions require a return type and/or argument types: %s", this.fn_.getFunctionName()));
        }
        if (this.getBinaryType() == TFunctionBinaryType.JAVA && this.hasSignature()) {
            this.fn_.setIsPersistent(false);
        } else {
            this.fn_.setIsPersistent(true);
        }
    }

    public FunctionName getFunctionName() {
        return this.fnName_;
    }

    public HdfsUri getLocation() {
        return this.location_;
    }

    protected abstract Function createFunction(FunctionName var1, List<Type> var2, Type var3, boolean var4);

    public static enum OptArg {
        COMMENT,
        SYMBOL,
        PREPARE_FN,
        CLOSE_FN,
        UPDATE_FN,
        INIT_FN,
        SERIALIZE_FN,
        MERGE_FN,
        FINALIZE_FN;

    }
}

