/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.thrift.TCreateDbParams;
import org.apache.impala.util.CatalogBlacklistUtils;

public class CreateDbStmt
extends StatementBase {
    private final String dbName_;
    private final HdfsUri location_;
    private final HdfsUri managedLocation_;
    private final String comment_;
    private final boolean ifNotExists_;
    private String owner_;
    private String serverName_;

    public CreateDbStmt(String dbName) {
        this(dbName, null, null, null, false);
    }

    public CreateDbStmt(String dbName, String comment, HdfsUri location, HdfsUri managedlocation, boolean ifNotExists) {
        this.dbName_ = dbName;
        this.comment_ = comment;
        this.location_ = location;
        this.managedLocation_ = managedlocation;
        this.ifNotExists_ = ifNotExists;
    }

    public String getComment() {
        return this.comment_;
    }

    @Override
    public String getParsedDb() {
        return this.dbName_;
    }

    public String getDb() {
        return this.dbName_;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists_;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder("CREATE DATABASE ");
        if (this.ifNotExists_) {
            sb.append("IF NOT EXISTS");
        }
        sb.append(this.dbName_);
        if (this.comment_ != null) {
            sb.append(" COMMENT '" + this.comment_ + "'");
        }
        if (this.location_ != null) {
            sb.append(" LOCATION '" + this.location_ + "'");
        }
        if (this.managedLocation_ != null) {
            sb.append(" MANAGEDLOCATION '" + this.managedLocation_ + "'");
        }
        return sb.toString();
    }

    public TCreateDbParams toThrift() {
        TCreateDbParams params = new TCreateDbParams();
        params.setDb(this.getDb());
        params.setComment(this.getComment());
        params.setLocation(this.location_ == null ? null : this.location_.toString());
        params.setManaged_location(this.managedLocation_ == null ? null : this.managedLocation_.toString());
        params.setIf_not_exists(this.getIfNotExists());
        params.setOwner(this.getOwner());
        params.setServer_name(this.serverName_);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (!MetastoreShim.validateName(this.dbName_)) {
            throw new AnalysisException("Invalid database name: " + this.dbName_);
        }
        CatalogBlacklistUtils.verifyDbName(this.dbName_);
        FeDb db = analyzer.getDb(this.getDb(), Privilege.CREATE, false);
        if (db != null && !this.ifNotExists_) {
            throw new AnalysisException("Database already exists: " + this.getDb());
        }
        if (this.location_ != null) {
            this.location_.analyze(analyzer, Privilege.ALL, FsAction.READ_WRITE);
        }
        if (this.managedLocation_ != null) {
            this.managedLocation_.analyze(analyzer, Privilege.ALL, FsAction.READ_WRITE);
        }
        this.owner_ = analyzer.getUserShortName();
        this.serverName_ = analyzer.getServerName();
    }

    public String getOwner() {
        return (String)Preconditions.checkNotNull((Object)this.owner_);
    }
}

