/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.extdatasource.ApiVersion;
import org.apache.impala.thrift.TCreateDataSourceParams;
import org.apache.impala.thrift.TDataSource;

public class CreateDataSrcStmt
extends StatementBase {
    private final String dataSrcName_;
    private final String className_;
    private final String apiVersionString_;
    private final HdfsUri location_;
    private final boolean ifNotExists_;
    private ApiVersion apiVersion_;

    public CreateDataSrcStmt(String dataSrcName, HdfsUri location, String className, String apiVersionString, boolean ifNotExists) {
        Preconditions.checkNotNull((Object)dataSrcName);
        Preconditions.checkNotNull((Object)className);
        Preconditions.checkNotNull((Object)apiVersionString);
        this.dataSrcName_ = dataSrcName.toLowerCase();
        this.location_ = location;
        this.className_ = className;
        this.apiVersionString_ = apiVersionString;
        this.ifNotExists_ = ifNotExists;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.dataSrcName_.equalsIgnoreCase("impalajdbcdatasource")) {
            throw new AnalysisException("Built-in data source name: " + this.dataSrcName_);
        }
        if (!MetastoreShim.validateName(this.dataSrcName_)) {
            throw new AnalysisException("Invalid data source name: " + this.dataSrcName_);
        }
        if (!this.ifNotExists_ && analyzer.getCatalog().getDataSource(this.dataSrcName_) != null) {
            throw new AnalysisException("Data source already exists: " + this.dataSrcName_);
        }
        this.apiVersion_ = ApiVersion.parseApiVersion(this.apiVersionString_);
        if (this.apiVersion_ == null) {
            throw new AnalysisException("Invalid API version: '" + this.apiVersionString_ + "'. Valid API versions: " + Joiner.on((String)", ").join((Object[])ApiVersion.values()));
        }
        if (this.location_ != null) {
            this.location_.analyze(analyzer, Privilege.ALL, FsAction.READ);
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE DATA SOURCE ");
        if (this.ifNotExists_) {
            sb.append("IF NOT EXISTS ");
        }
        sb.append(this.dataSrcName_);
        sb.append(" LOCATION '");
        sb.append(this.location_ != null ? this.location_.getLocation() : "");
        sb.append("' CLASS '");
        sb.append(this.className_);
        sb.append("' API_VERSION '");
        sb.append(this.apiVersion_.name());
        sb.append("'");
        return sb.toString();
    }

    public TCreateDataSourceParams toThrift() {
        return new TCreateDataSourceParams(new TDataSource(this.dataSrcName_, this.location_ != null ? this.location_.toString() : "", this.className_, this.apiVersion_.name())).setIf_not_exists(this.ifNotExists_);
    }
}

