/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.common.Pair;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TTestCaseData;
import org.apache.impala.util.CompressionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyTestCaseStmt
extends StatementBase {
    private static final String TEST_OUTPUT_FILE_PREFIX = "impala-testcase-data-";
    private static final Logger LOG = LoggerFactory.getLogger(CopyTestCaseStmt.class);
    private final QueryStmt queryStmt_;
    private final HdfsUri hdfsPath_;

    private CopyTestCaseStmt(QueryStmt stmt, HdfsUri path) {
        this.queryStmt_ = stmt;
        this.hdfsPath_ = path;
    }

    public static CopyTestCaseStmt to(QueryStmt stmt, HdfsUri path) {
        return new CopyTestCaseStmt(stmt, path);
    }

    public static CopyTestCaseStmt from(HdfsUri path) {
        return new CopyTestCaseStmt(null, path);
    }

    public boolean isTestCaseExport() {
        return this.queryStmt_ != null;
    }

    public QueryStmt getQueryStmt() {
        return this.queryStmt_;
    }

    public String getHdfsPath() {
        return this.hdfsPath_.getLocation();
    }

    @Override
    public void collectTableRefs(List<TableRef> referencedTables) {
        if (!this.isTestCaseExport()) {
            return;
        }
        this.queryStmt_.collectTableRefs(referencedTables);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        if (this.isTestCaseExport()) {
            this.hdfsPath_.analyze(analyzer, Privilege.ALL, FsAction.READ_WRITE, true, true);
            try {
                if (!FileSystemUtil.isDir(this.hdfsPath_.getPath())) {
                    throw new AnalysisException(String.format("Path is not a valid directory to write the testcase output file: %s", this.hdfsPath_));
                }
            }
            catch (IOException e) {
                throw new AnalysisException(String.format("Error checking the status of path: %s", this.hdfsPath_), e);
            }
            this.queryStmt_.analyze(analyzer);
            Pair<Set<FeDb>, Set<FeTable>> referencedObjects = this.getReferencedCatalogObjects();
            for (FeDb db : (Set)referencedObjects.first) {
                analyzer.registerPrivReq(builder -> builder.onDb(db).allOf(Privilege.VIEW_METADATA).build());
            }
            for (FeTable table : (Set)referencedObjects.second) {
                analyzer.registerPrivReq(builder -> builder.onTable(table).allOf(Privilege.VIEW_METADATA).build());
            }
        } else {
            this.hdfsPath_.analyze(analyzer, Privilege.ALL, FsAction.READ, true, true);
        }
    }

    private Pair<Set<FeDb>, Set<FeTable>> getReferencedCatalogObjects() {
        Preconditions.checkState((boolean)this.queryStmt_.isAnalyzed());
        Set referencedTblsAndViews = Sets.newIdentityHashSet();
        Set referencedDbs = Sets.newIdentityHashSet();
        for (TableRef ref : this.queryStmt_.collectTableRefs()) {
            referencedDbs.add(ref.getTable().getDb());
            referencedTblsAndViews.add(ref.getTable());
        }
        for (FeView view : this.queryStmt_.collectInlineViews()) {
            if (view == null || view.isLocalView()) continue;
            referencedDbs.add(view.getDb());
            referencedTblsAndViews.add(view);
        }
        return new Pair<Set<FeDb>, Set<FeTable>>(referencedDbs, referencedTblsAndViews);
    }

    @VisibleForTesting
    public TTestCaseData getTestCaseData() throws ImpalaException {
        Preconditions.checkState((boolean)this.queryStmt_.isAnalyzed());
        TTestCaseData result = new TTestCaseData(this.queryStmt_.getOrigSqlString(), this.hdfsPath_.getLocation(), BackendConfig.INSTANCE.getImpalaBuildVersion());
        Pair<Set<FeDb>, Set<FeTable>> referencedObjects = this.getReferencedCatalogObjects();
        ArrayList referencedDbs = new ArrayList((Collection)referencedObjects.first);
        ArrayList referencedTbls = new ArrayList((Collection)referencedObjects.second);
        Collections.sort(referencedDbs, FeDb.NAME_COMPARATOR);
        Collections.sort(referencedTbls, FeTable.NAME_COMPARATOR);
        for (FeDb db : referencedDbs) {
            result.addToDbs(db.toThrift());
        }
        for (FeTable table : referencedTbls) {
            result.addToTables_and_views(FeCatalogUtils.feTableToThrift(table));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeTestCaseData() throws ImpalaException {
        TTestCaseData data = this.getTestCaseData();
        Path filePath = new Path(this.hdfsPath_.getPath(), TEST_OUTPUT_FILE_PREFIX + UUID.randomUUID().toString());
        try {
            FileSystem fs = FileSystemUtil.getDefaultFileSystem();
            try (FSDataOutputStream os = fs.create(filePath);){
                os.write(CompressionUtil.deflateCompress(JniUtil.serializeToThrift(data)));
            }
        }
        catch (IOException e) {
            throw new ImpalaRuntimeException(String.format("Error writing test case output to file: %s", filePath), e);
        }
        LOG.info("Created testcase file {} which contains {} db(s), {} table(s)/view(s) for query: {}", new Object[]{filePath, data.getDbsSize(), data.getTables_and_viewsSize(), data.getQuery_stmt()});
        return filePath.toString();
    }
}

