/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TExprNode;

public class CompoundVerticalBarExpr
extends Expr {
    private Expr encapsulatedExpr_;

    public CompoundVerticalBarExpr(Expr e1, Expr e2) {
        Preconditions.checkNotNull((Object)e1);
        Preconditions.checkNotNull((Object)e2);
        this.children_.add(e1);
        this.children_.add(e2);
    }

    public CompoundVerticalBarExpr(CompoundVerticalBarExpr other) {
        super(other);
        this.encapsulatedExpr_ = other.encapsulatedExpr_;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        if (this.encapsulatedExpr_ != null) {
            this.encapsulatedExpr_.toThrift(msg);
        }
    }

    @Override
    protected float computeEvalCost() {
        if (this.encapsulatedExpr_ != null) {
            return this.encapsulatedExpr_.computeEvalCost();
        }
        return -1.0f;
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        if (this.encapsulatedExpr_ != null) {
            return this.encapsulatedExpr_.toSqlImpl(options);
        }
        return ((Expr)this.children_.get(0)).toSql(options) + " || " + ((Expr)this.children_.get(1)).toSql(options);
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        Expr e1 = (Expr)this.getChild(0);
        Expr e2 = (Expr)this.getChild(1);
        if ((e1.getType().isBoolean() || e1.getType().isNull()) && (e2.getType().isBoolean() || e2.getType().isNull())) {
            this.type_ = Type.BOOLEAN;
            this.encapsulatedExpr_ = new CompoundPredicate(CompoundPredicate.Operator.OR, e1, e2);
            this.encapsulatedExpr_.analyze(analyzer);
        } else if (e1.getType().isStringType() && e2.getType().isStringType()) {
            this.type_ = Type.STRING;
            this.encapsulatedExpr_ = new FunctionCallExpr("concat", (List<Expr>)Lists.newArrayList((Object[])new Expr[]{e1, e2}));
            this.encapsulatedExpr_.analyze(analyzer);
        } else {
            throw new AnalysisException(String.format("Operands of CompoundVerticalBarExpr '%s' should both return 'BOOLEAN' type or they should both return 'STRING' or 'VARCHAR' or 'CHAR' types, but they return types '%s' and '%s'.", this.toSql(), e1.getType().toSql(), e2.getType().toSql()));
        }
    }

    @Override
    public Expr clone() {
        return new CompoundVerticalBarExpr(this);
    }

    public Expr getEncapsulatedExpr() {
        return this.encapsulatedExpr_;
    }
}

