/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.Predicate;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;

public class CompoundPredicate
extends Predicate {
    private final Operator op_;
    private final double betweenSelectivity_;

    public static void initBuiltins(Db db) {
        db.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.AND.name(), "", Lists.newArrayList((Object[])new Type[]{Type.BOOLEAN, Type.BOOLEAN}), Type.BOOLEAN));
        db.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.OR.name(), "", Lists.newArrayList((Object[])new Type[]{Type.BOOLEAN, Type.BOOLEAN}), Type.BOOLEAN));
        db.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.NOT.name(), "impala::CompoundPredicate::Not", Lists.newArrayList((Object[])new Type[]{Type.BOOLEAN}), Type.BOOLEAN));
    }

    public static CompoundPredicate createFromBetweenPredicate(Operator op, BinaryPredicate lower, BinaryPredicate upper, double betweenSelectivity) {
        Preconditions.checkArgument((betweenSelectivity >= 0.0 ? 1 : 0) != 0);
        return new CompoundPredicate(op, lower, upper, betweenSelectivity);
    }

    private CompoundPredicate(Operator op, Expr e1, Expr e2, double betweenSelectivity) {
        this.op_ = op;
        Preconditions.checkNotNull((Object)e1);
        this.children_.add(e1);
        Preconditions.checkArgument((op == Operator.NOT && e2 == null || op != Operator.NOT && e2 != null ? 1 : 0) != 0);
        if (e2 != null) {
            this.children_.add(e2);
            if (op == Operator.AND && Expr.IS_ALWAYS_TRUE_PREDICATE.apply((Object)e1) && Expr.IS_ALWAYS_TRUE_PREDICATE.apply((Object)e2) || op == Operator.OR && (Expr.IS_ALWAYS_TRUE_PREDICATE.apply((Object)e1) || Expr.IS_ALWAYS_TRUE_PREDICATE.apply((Object)e2))) {
                this.setHasAlwaysTrueHint(true);
            }
        }
        this.betweenSelectivity_ = betweenSelectivity;
    }

    public CompoundPredicate(Operator op, Expr e1, Expr e2) {
        this(op, e1, e2, -1.0);
    }

    protected CompoundPredicate(CompoundPredicate other) {
        super(other);
        this.op_ = other.op_;
        this.betweenSelectivity_ = other.betweenSelectivity_;
    }

    public Operator getOp() {
        return this.op_;
    }

    @Override
    protected boolean localEquals(Expr that) {
        return super.localEquals(that) && ((CompoundPredicate)that).op_ == this.op_;
    }

    @Override
    protected int localHash() {
        return Objects.hash(new Object[]{super.localHash(), this.op_});
    }

    @Override
    public String debugString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("op", (Object)this.op_).addValue((Object)super.debugString());
        if (this.betweenSelectivity_ != -1.0) {
            helper.add("betweenSelectivity", this.betweenSelectivity_);
        }
        return helper.toString();
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        if (this.children_.size() == 1) {
            Preconditions.checkState((this.op_ == Operator.NOT ? 1 : 0) != 0);
            return "NOT " + ((Expr)this.getChild(0)).toSql(options);
        }
        return ((Expr)this.getChild(0)).toSql(options) + " " + this.op_.toString() + " " + ((Expr)this.getChild(1)).toSql(options);
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.COMPOUND_PRED;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
        for (Expr e : this.children_) {
            if (e.getType().isBoolean() || e.getType().isNull()) continue;
            throw new AnalysisException(String.format("Operand '%s' part of predicate '%s' should return type 'BOOLEAN' but returns type '%s'.", e.toSql(), this.toSql(), e.getType().toSql()));
        }
        this.fn_ = this.getBuiltinFunction(analyzer, this.op_.toString(), this.collectChildReturnTypes(), Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        Preconditions.checkState((this.fn_ != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.fn_.getReturnType().isBoolean());
        this.castForFunctionCall(false, analyzer.getRegularCompatibilityLevel());
        this.computeSelectivity(analyzer);
    }

    protected void computeSelectivity(Analyzer analyzer) {
        if (this.hasValidSelectivityHint()) {
            if (this.getOp() == Operator.AND) {
                analyzer.addWarning("Selectivity hints are ignored for 'AND' compound predicates, either in the SQL query or internally generated.");
            } else {
                return;
            }
        }
        this.computeSelectivity();
    }

    @Deprecated
    protected void computeSelectivity() {
        if (this.betweenSelectivity_ != -1.0) {
            this.selectivity_ = this.betweenSelectivity_;
            return;
        }
        if (!((Expr)this.getChild(0)).hasSelectivity() || this.children_.size() == 2 && !((Expr)this.getChild(1)).hasSelectivity()) {
            this.selectivity_ = -1.0;
            return;
        }
        switch (this.op_) {
            case AND: {
                this.selectivity_ = ((Expr)this.getChild((int)0)).selectivity_ * ((Expr)this.getChild((int)1)).selectivity_;
                break;
            }
            case OR: {
                this.selectivity_ = ((Expr)this.getChild((int)0)).selectivity_ + ((Expr)this.getChild((int)1)).selectivity_ - ((Expr)this.getChild((int)0)).selectivity_ * ((Expr)this.getChild((int)1)).selectivity_;
                break;
            }
            case NOT: {
                this.selectivity_ = 1.0 - ((Expr)this.getChild((int)0)).selectivity_;
            }
        }
        this.selectivity_ = Math.max(0.0, Math.min(1.0, this.selectivity_));
    }

    @Override
    protected float computeEvalCost() {
        return this.hasChildCosts() ? this.getChildCosts() + 1.0f : -1.0f;
    }

    @Override
    public Expr negate() {
        if (this.op_ == Operator.NOT) {
            return (Expr)this.getChild(0);
        }
        Expr negatedLeft = ((Expr)this.getChild(0)).negate();
        Expr negatedRight = ((Expr)this.getChild(1)).negate();
        Operator newOp = this.op_ == Operator.OR ? Operator.AND : Operator.OR;
        return new CompoundPredicate(newOp, negatedLeft, negatedRight);
    }

    public static Expr createConjunctivePredicate(List<Expr> conjuncts) {
        return CompoundPredicate.createCompoundTree(conjuncts, Operator.AND);
    }

    public static Expr createDisjunctivePredicate(List<Expr> disjuncts) {
        return CompoundPredicate.createCompoundTree(disjuncts, Operator.OR);
    }

    private static Expr createCompoundTree(List<Expr> exprs, Operator op) {
        Preconditions.checkState((op == Operator.AND || op == Operator.OR ? 1 : 0) != 0);
        Expr result = null;
        for (Expr expr : exprs) {
            if (result == null) {
                result = expr;
                continue;
            }
            result = new CompoundPredicate(op, result, expr);
        }
        return result;
    }

    @Override
    public Expr clone() {
        return new CompoundPredicate(this);
    }

    public static Expr createConjunction(Expr lhs, Expr rhs) {
        if (rhs == null) {
            return lhs;
        }
        return new CompoundPredicate(Operator.AND, rhs, lhs);
    }

    public boolean derivedFromBetween() {
        return this.betweenSelectivity_ != -1.0;
    }

    public static enum Operator {
        AND("AND"),
        OR("OR"),
        NOT("NOT");

        private final String description;

        private Operator(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

