/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CommentOnStmt;
import org.apache.impala.analysis.SingleTableStmt;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TCommentOnParams;

public abstract class CommentOnTableOrViewStmt
extends CommentOnStmt
implements SingleTableStmt {
    protected TableName tableName_;

    public CommentOnTableOrViewStmt(TableName tableName, String comment) {
        super(comment);
        Preconditions.checkArgument((tableName != null && !tableName.isEmpty() ? 1 : 0) != 0);
        this.tableName_ = tableName;
    }

    @Override
    public TableName getTableName() {
        return this.tableName_;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        this.tableName_ = analyzer.getFqTableName(this.tableName_);
        TableRef tableRef = new TableRef(this.tableName_.toPath(), null, Privilege.ALTER);
        tableRef = analyzer.resolveTableRef(tableRef);
        Preconditions.checkNotNull((Object)tableRef);
        tableRef.analyze(analyzer);
        this.validateType(tableRef);
    }

    protected abstract void validateType(TableRef var1) throws AnalysisException;

    @Override
    public TCommentOnParams toThrift() {
        TCommentOnParams params = super.toThrift();
        params.setTable_name(this.tableName_.toThrift());
        return params;
    }
}

