/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CommentOnStmt;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TCommentOnParams;

public class CommentOnDbStmt
extends CommentOnStmt {
    private final String dbName_;

    public CommentOnDbStmt(String dbName, String comment) {
        super(comment);
        Preconditions.checkNotNull((Object)dbName);
        this.dbName_ = dbName;
    }

    @Override
    public String getParsedDb() {
        return this.dbName_;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        analyzer.getDb(this.dbName_, Privilege.ALTER);
    }

    @Override
    public TCommentOnParams toThrift() {
        TCommentOnParams params = super.toThrift();
        params.setDb(this.dbName_);
        return params;
    }
}

