/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.impala.analysis.AnalyticExpr;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.DescriptorTable;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.OrderByElement;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.FeDataSourceTable;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.VirtualTable;
import org.apache.impala.common.Id;
import org.apache.impala.common.IdGenerator;
import org.apache.impala.thrift.TEdgeType;
import org.apache.impala.thrift.TLineageGraph;
import org.apache.impala.thrift.TMultiEdge;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.thrift.TVertex;
import org.apache.impala.thrift.TVertexMetadata;
import org.apache.impala.util.TUniqueIdUtil;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnLineageGraph {
    public static final String ICEBERG = "iceberg";
    public static final String HIVE = "hive";
    public static final String KUDU = "kudu";
    public static final String HBASE = "hbase";
    public static final String VIEW = "view";
    public static final String VIRTUAL = "virtual";
    public static final String EXTERNAL_DATASOURCE = "external-datasource";
    private static final Logger LOG = LoggerFactory.getLogger(ColumnLineageGraph.class);
    private String queryStr_;
    private TUniqueId queryId_;
    private String user_;
    private final List<Expr> resultDependencyPredicates_ = new ArrayList<Expr>();
    private final List<MultiEdge> edges_ = new ArrayList<MultiEdge>();
    private long timestamp_;
    private final Map<String, Vertex> vertices_ = new HashMap<String, Vertex>();
    private final Map<VertexId, Vertex> idToVertexMap_ = new HashMap<VertexId, Vertex>();
    private final List<ColumnLabel> targetColumnLabels_ = new ArrayList<ColumnLabel>();
    private DescriptorTable descTbl_;
    private final IdGenerator<VertexId> vertexIdGenerator = VertexId.createGenerator();

    public ColumnLineageGraph() {
    }

    private ColumnLineageGraph(String stmt, TUniqueId queryId, String user, long timestamp) {
        this.queryStr_ = stmt;
        this.queryId_ = queryId;
        this.user_ = user;
        this.timestamp_ = timestamp;
    }

    private void setVertices(Set<Vertex> vertices) {
        for (Vertex vertex : vertices) {
            this.vertices_.put(vertex.getLabel(), vertex);
            this.idToVertexMap_.put(vertex.getVertexId(), vertex);
        }
    }

    private MultiEdge createMultiEdge(Set<ColumnLabel> targets, Map<String, SlotDescriptor> sources, MultiEdge.EdgeType type, Analyzer analyzer) {
        FeTable feTable;
        HashSet<Vertex> targetVertices = new HashSet<Vertex>();
        for (ColumnLabel target : ImmutableSortedSet.copyOf(targets)) {
            Vertex.Metadata metadata = null;
            if (target.tableName_ != null) {
                feTable = analyzer.getStmtTableCache().tables.get(target.tableName_);
                metadata = feTable != null && feTable.getMetaStoreTable() != null ? new Vertex.Metadata(target.tableName_.toString(), ColumnLineageGraph.getTableType(feTable), feTable.getMetaStoreTable().getCreateTime()) : new Vertex.Metadata(target.tableName_.toString(), target.tableType_, -1L);
            }
            targetVertices.add(this.createVertex(target.columnLabel_, metadata));
        }
        HashSet<Vertex> sourceVertices = new HashSet<Vertex>();
        for (Map.Entry source : ImmutableSortedMap.copyOf(sources).entrySet()) {
            feTable = ((SlotDescriptor)source.getValue()).getParent().getTable();
            Preconditions.checkState((feTable != null ? 1 : 0) != 0);
            Vertex.Metadata metadata = feTable != null && feTable.getMetaStoreTable() != null ? new Vertex.Metadata(feTable.getTableName().toString(), ColumnLineageGraph.getTableType(feTable), feTable.getMetaStoreTable().getCreateTime()) : null;
            sourceVertices.add(this.createVertex((String)source.getKey(), metadata));
        }
        MultiEdge edge = new MultiEdge(sourceVertices, targetVertices, type);
        this.edges_.add(edge);
        return edge;
    }

    public static String getTableType(FeTable tbl) {
        if (tbl instanceof FeIcebergTable) {
            return ICEBERG;
        }
        if (tbl instanceof FeFsTable) {
            return HIVE;
        }
        if (tbl instanceof FeKuduTable) {
            return KUDU;
        }
        if (tbl instanceof FeHBaseTable) {
            return HBASE;
        }
        if (tbl instanceof FeView) {
            return VIEW;
        }
        if (tbl instanceof VirtualTable) {
            return VIRTUAL;
        }
        if (tbl instanceof FeDataSourceTable) {
            return EXTERNAL_DATASOURCE;
        }
        LOG.error(String.format("Table '%s' has unknown type: '%s'", tbl.getFullName(), tbl.getClass().getName()));
        return "unknown";
    }

    private Vertex createVertex(String label, Vertex.Metadata metadata) {
        Vertex newVertex = this.vertices_.get(label);
        if (newVertex != null) {
            return newVertex;
        }
        newVertex = new Vertex(this.vertexIdGenerator.getNextId(), label, metadata);
        this.vertices_.put(newVertex.getLabel(), newVertex);
        this.idToVertexMap_.put(newVertex.getVertexId(), newVertex);
        return newVertex;
    }

    public void computeLineageGraph(List<Expr> resultExprs, Analyzer rootAnalyzer) {
        this.init(rootAnalyzer);
        if (resultExprs != null && !resultExprs.isEmpty()) {
            this.computeProjectionDependencies(resultExprs, rootAnalyzer);
            this.computeResultPredicateDependencies(rootAnalyzer);
        }
    }

    private void init(Analyzer analyzer) {
        Preconditions.checkNotNull((Object)analyzer);
        Preconditions.checkState((boolean)analyzer.isRootAnalyzer());
        TQueryCtx queryCtx = analyzer.getQueryCtx();
        this.queryStr_ = queryCtx.client_request.isSetRedacted_stmt() ? queryCtx.client_request.redacted_stmt : queryCtx.client_request.stmt;
        Preconditions.checkNotNull((Object)this.queryStr_);
        this.timestamp_ = queryCtx.start_unix_millis / 1000L;
        this.descTbl_ = analyzer.getDescTbl();
        this.user_ = analyzer.getUser().getName();
        this.queryId_ = queryCtx.query_id;
    }

    private void computeProjectionDependencies(List<Expr> resultExprs, Analyzer analyzer) {
        Preconditions.checkNotNull(resultExprs);
        Preconditions.checkState((!resultExprs.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((resultExprs.size() == this.targetColumnLabels_.size() ? 1 : 0) != 0);
        for (int i = 0; i < resultExprs.size(); ++i) {
            Expr expr = resultExprs.get(i);
            HashMap<String, SlotDescriptor> sourceBaseCols = new HashMap<String, SlotDescriptor>();
            ArrayList<Expr> dependentExprs = new ArrayList<Expr>();
            this.getSourceBaseCols(expr, sourceBaseCols, dependentExprs, false);
            HashSet targets = Sets.newHashSet((Object[])new ColumnLabel[]{this.targetColumnLabels_.get(i)});
            this.createMultiEdge(targets, sourceBaseCols, MultiEdge.EdgeType.PROJECTION, analyzer);
            if (dependentExprs.isEmpty()) continue;
            HashMap<String, SlotDescriptor> predicateBaseCols = new HashMap<String, SlotDescriptor>();
            for (Expr dependentExpr : dependentExprs) {
                this.getSourceBaseCols(dependentExpr, predicateBaseCols, null, true);
            }
            this.createMultiEdge(targets, predicateBaseCols, MultiEdge.EdgeType.PREDICATE, analyzer);
        }
    }

    private void computeResultPredicateDependencies(Analyzer analyzer) {
        List<Expr> conjuncts = analyzer.getConjuncts();
        for (Expr expr : conjuncts) {
            if (expr.isAuxExpr()) continue;
            this.resultDependencyPredicates_.add(expr);
        }
        HashMap<String, SlotDescriptor> predicateBaseCols = new HashMap<String, SlotDescriptor>();
        for (Expr expr : this.resultDependencyPredicates_) {
            this.getSourceBaseCols(expr, predicateBaseCols, null, true);
        }
        if (predicateBaseCols.isEmpty()) {
            return;
        }
        HashSet hashSet = Sets.newHashSet(this.targetColumnLabels_);
        this.createMultiEdge(hashSet, predicateBaseCols, MultiEdge.EdgeType.PREDICATE, analyzer);
    }

    private void getSourceBaseCols(Expr expr, Map<String, SlotDescriptor> sourceBaseCols, List<Expr> directPredDeps, boolean traversePredDeps) {
        List<Expr> exprsToTraverse = this.getProjectionDeps(expr);
        List<Expr> predicateDepExprs = this.getPredicateDeps(expr);
        if (directPredDeps != null) {
            directPredDeps.addAll(predicateDepExprs);
        }
        if (traversePredDeps) {
            exprsToTraverse.addAll(predicateDepExprs);
        }
        ArrayList<SlotId> slotIds = new ArrayList<SlotId>();
        for (Expr e : exprsToTraverse) {
            e.getIds(null, slotIds);
        }
        for (SlotId slotId : slotIds) {
            SlotDescriptor slotDesc = this.descTbl_.getSlotDesc(slotId);
            List<Expr> sourceExprs = slotDesc.getSourceExprs();
            if (sourceExprs.isEmpty() && slotDesc.isScanSlot() && slotDesc.getPath().isRootedAtTuple()) {
                Preconditions.checkState((boolean)slotDesc.getParent().isMaterialized());
                List<String> path = slotDesc.getPath().getCanonicalPath();
                sourceBaseCols.put(Joiner.on((String)".").join(path), slotDesc);
                continue;
            }
            for (Expr sourceExpr : sourceExprs) {
                this.getSourceBaseCols(sourceExpr, sourceBaseCols, directPredDeps, traversePredDeps);
            }
        }
    }

    private List<Expr> getProjectionDeps(Expr e) {
        Preconditions.checkNotNull((Object)e);
        ArrayList<Expr> outputExprs = new ArrayList<Expr>();
        if (e instanceof AnalyticExpr) {
            AnalyticExpr analytic = (AnalyticExpr)e;
            outputExprs.addAll(analytic.getChildren().subList(0, analytic.getFnCall().getParams().size()));
        } else {
            outputExprs.add(e);
        }
        return outputExprs;
    }

    private List<Expr> getPredicateDeps(Expr e) {
        Preconditions.checkNotNull((Object)e);
        ArrayList<Expr> outputExprs = new ArrayList<Expr>();
        if (e instanceof AnalyticExpr) {
            AnalyticExpr analyticExpr = (AnalyticExpr)e;
            outputExprs.addAll(analyticExpr.getPartitionExprs());
            for (OrderByElement orderByElem : analyticExpr.getOrderByElements()) {
                outputExprs.add(orderByElem.getExpr());
            }
        }
        return outputExprs;
    }

    public void addDependencyPredicates(Collection<Expr> exprs) {
        this.resultDependencyPredicates_.addAll(exprs);
    }

    public String toJson() {
        if (Strings.isNullOrEmpty((String)this.queryStr_)) {
            return "";
        }
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("queryText", this.queryStr_);
        obj.put("queryId", TUniqueIdUtil.PrintId(this.queryId_));
        obj.put("hash", this.getQueryHash(this.queryStr_));
        obj.put("user", this.user_);
        obj.put("timestamp", this.timestamp_);
        JSONArray edges = new JSONArray();
        for (MultiEdge edge : this.edges_) {
            edges.add(edge.toJson());
        }
        obj.put("edges", edges);
        TreeSet sortedVertices = Sets.newTreeSet(this.vertices_.values());
        JSONArray vertices = new JSONArray();
        for (Vertex vertex : sortedVertices) {
            vertices.add(vertex.toJson());
        }
        obj.put("vertices", vertices);
        return JSONValue.toJSONString(obj);
    }

    public TLineageGraph toThrift() {
        TLineageGraph graph = new TLineageGraph();
        if (Strings.isNullOrEmpty((String)this.queryStr_)) {
            return graph;
        }
        graph.setQuery_text(this.queryStr_);
        graph.setQuery_id(this.queryId_);
        graph.setHash(this.getQueryHash(this.queryStr_));
        graph.setUser(this.user_);
        graph.setStarted(this.timestamp_);
        ArrayList<TMultiEdge> edges = new ArrayList<TMultiEdge>();
        for (MultiEdge edge : this.edges_) {
            edges.add(edge.toThrift());
        }
        graph.setEdges(edges);
        TreeSet sortedVertices = Sets.newTreeSet(this.vertices_.values());
        ArrayList<TVertex> vertices = new ArrayList<TVertex>();
        for (Vertex vertex : sortedVertices) {
            vertices.add(vertex.toThrift());
        }
        graph.setVertices(vertices);
        return graph;
    }

    public static ColumnLineageGraph fromThrift(TLineageGraph obj) {
        ColumnLineageGraph lineage = new ColumnLineageGraph(obj.query_text, obj.query_id, obj.user, obj.started);
        HashMap vertexMap = new HashMap();
        TreeSet vertices = Sets.newTreeSet();
        for (TVertex vertex : obj.vertices) {
            Vertex v = Vertex.fromThrift(vertex);
            vertices.add(v);
        }
        lineage.setVertices(vertices);
        for (TMultiEdge edge : obj.edges) {
            MultiEdge e = MultiEdge.fromThrift(edge);
            lineage.edges_.add(e);
        }
        return lineage;
    }

    private String getQueryHash(String queryStr) {
        Hasher hasher = Hashing.murmur3_128().newHasher();
        hasher.putUnencodedChars((CharSequence)queryStr);
        return hasher.hash().toString();
    }

    public static ColumnLineageGraph createFromJSON(String json) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        JSONParser parser = new JSONParser();
        Object obj = null;
        try {
            obj = parser.parse(json);
        }
        catch (ParseException e) {
            LOG.error("Error parsing serialized column lineage graph: " + e.getMessage());
            return null;
        }
        if (!(obj instanceof JSONObject)) {
            return null;
        }
        JSONObject jsonObj = (JSONObject)obj;
        String stmt = (String)jsonObj.get((Object)"queryText");
        TUniqueId queryId = TUniqueIdUtil.ParseId((String)jsonObj.get((Object)"queryId"));
        String user = (String)jsonObj.get((Object)"user");
        long timestamp = (Long)jsonObj.get((Object)"timestamp");
        ColumnLineageGraph graph = new ColumnLineageGraph(stmt, queryId, user, timestamp);
        JSONArray serializedVertices = (JSONArray)jsonObj.get((Object)"vertices");
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        for (int i = 0; i < serializedVertices.size(); ++i) {
            Vertex v = Vertex.fromJsonObj((JSONObject)serializedVertices.get(i));
            vertices.add(v);
        }
        graph.setVertices(vertices);
        JSONArray serializedEdges = (JSONArray)jsonObj.get((Object)"edges");
        for (int i = 0; i < serializedEdges.size(); ++i) {
            MultiEdge e = graph.createMultiEdgeFromJSONObj((JSONObject)serializedEdges.get(i));
            graph.edges_.add(e);
        }
        return graph;
    }

    private MultiEdge createMultiEdgeFromJSONObj(JSONObject jsonEdge) {
        Preconditions.checkNotNull((Object)jsonEdge);
        JSONArray sources = (JSONArray)jsonEdge.get((Object)"sources");
        Set<Vertex> sourceVertices = this.getVerticesFromJSONArray(sources);
        JSONArray targets = (JSONArray)jsonEdge.get((Object)"targets");
        Set<Vertex> targetVertices = this.getVerticesFromJSONArray(targets);
        MultiEdge.EdgeType type = MultiEdge.EdgeType.valueOf((String)jsonEdge.get((Object)"edgeType"));
        return new MultiEdge(sourceVertices, targetVertices, type);
    }

    private Set<Vertex> getVerticesFromJSONArray(JSONArray vertexIdArray) {
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        for (int i = 0; i < vertexIdArray.size(); ++i) {
            int sourceId = ((Long)vertexIdArray.get(i)).intValue();
            Vertex sourceVertex = this.idToVertexMap_.get(new VertexId(sourceId));
            Preconditions.checkNotNull((Object)sourceVertex);
            vertices.add(sourceVertex);
        }
        return vertices;
    }

    public boolean equalsForTests(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ColumnLineageGraph g = (ColumnLineageGraph)obj;
        return ColumnLineageGraph.mapEqualsForTests(this.vertices_, g.vertices_) && ColumnLineageGraph.listEqualsForTests(this.edges_, g.edges_);
    }

    private static boolean mapEqualsForTests(Map<String, Vertex> map1, Map<String, Vertex> map2) {
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<String, Vertex> e : map1.entrySet()) {
            String key = e.getKey();
            Vertex value = e.getValue();
            if (!(value == null ? map2.get(key) != null || !map2.containsKey(key) : !value.equalsForTests(map2.get(key)))) continue;
            return false;
        }
        return true;
    }

    private static boolean setEqualsForTests(Set<Vertex> set1, Set<Vertex> set2) {
        if (set1.size() != set2.size()) {
            return false;
        }
        for (Vertex v1 : set1) {
            boolean found = false;
            Iterator<Vertex> i = set2.iterator();
            while (i.hasNext()) {
                Vertex v2 = i.next();
                if (!v1.equalsForTests(v2)) continue;
                i.remove();
                found = true;
            }
            if (found) continue;
            return false;
        }
        return set2.isEmpty();
    }

    private static boolean listEqualsForTests(List<MultiEdge> list1, List<MultiEdge> list2) {
        ListIterator<MultiEdge> i1 = list1.listIterator();
        ListIterator<MultiEdge> i2 = list2.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            MultiEdge e1 = i1.next();
            MultiEdge e2 = i2.next();
            if (e1 != null ? e1.equalsForTests(e2) : e2 == null) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public String debugString() {
        StringBuilder builder = new StringBuilder();
        for (MultiEdge edge : this.edges_) {
            builder.append(edge.toString() + "\n");
        }
        builder.append(this.toJson());
        return builder.toString();
    }

    public void addTargetColumnLabels(Collection<ColumnLabel> columnLabels) {
        Preconditions.checkNotNull(columnLabels);
        this.targetColumnLabels_.addAll(columnLabels);
    }

    public void addTargetColumnLabels(FeTable dstTable) {
        Preconditions.checkNotNull((Object)dstTable);
        for (String columnName : dstTable.getColumnNames()) {
            this.targetColumnLabels_.add(new ColumnLabel(columnName, dstTable.getTableName(), ColumnLineageGraph.getTableType(dstTable)));
        }
    }

    public static class ColumnLabel
    implements Comparable<ColumnLabel> {
        private final String columnLabel_;
        private final TableName tableName_;
        private final String tableType_;

        public ColumnLabel(String columnName, TableName tableName, String tableType) {
            this.columnLabel_ = columnName;
            this.tableName_ = tableName;
            this.tableType_ = tableType;
        }

        public ColumnLabel(String columnName) {
            this(columnName, null, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnLabel that = (ColumnLabel)o;
            return Objects.equals(this.columnLabel_, that.columnLabel_);
        }

        public int hashCode() {
            return Objects.hash(this.columnLabel_);
        }

        @Override
        public int compareTo(ColumnLabel o) {
            return this.columnLabel_.compareTo(o.columnLabel_);
        }
    }

    private static final class MultiEdge {
        private final Set<Vertex> sources_;
        private final Set<Vertex> targets_;
        private final EdgeType edgeType_;

        public MultiEdge(Set<Vertex> sources, Set<Vertex> targets, EdgeType type) {
            this.sources_ = sources;
            this.targets_ = targets;
            this.edgeType_ = type;
        }

        private ImmutableSortedSet<Vertex> getOrderedSources() {
            return ImmutableSortedSet.copyOf(this.sources_);
        }

        private ImmutableSortedSet<Vertex> getOrderedTargets() {
            return ImmutableSortedSet.copyOf(this.targets_);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            Joiner joiner = Joiner.on((String)",");
            builder.append("Sources: [");
            builder.append(joiner.join(this.getOrderedSources()) + "]\n");
            builder.append("Targets: [");
            builder.append(joiner.join(this.getOrderedTargets()) + "]\n");
            builder.append("Type: " + (Object)((Object)this.edgeType_));
            return builder.toString();
        }

        public Map<String, Object> toJson() {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
            JSONArray sourceIds = new JSONArray();
            for (Vertex vertex : this.getOrderedSources()) {
                sourceIds.add((Object)vertex.getVertexId());
            }
            obj.put("sources", sourceIds);
            JSONArray targetIds = new JSONArray();
            for (Vertex vertex : this.getOrderedTargets()) {
                targetIds.add((Object)vertex.getVertexId());
            }
            obj.put("targets", targetIds);
            obj.put("edgeType", this.edgeType_.toString());
            return obj;
        }

        public TMultiEdge toThrift() {
            ArrayList<TVertex> sources = new ArrayList<TVertex>();
            for (Vertex vertex : this.getOrderedSources()) {
                sources.add(vertex.toThrift());
            }
            ArrayList<TVertex> targets = new ArrayList<TVertex>();
            for (Vertex vertex : this.getOrderedTargets()) {
                targets.add(vertex.toThrift());
            }
            if (this.edgeType_ == EdgeType.PROJECTION) {
                return new TMultiEdge(sources, targets, TEdgeType.PROJECTION);
            }
            return new TMultiEdge(sources, targets, TEdgeType.PREDICATE);
        }

        public static MultiEdge fromThrift(TMultiEdge obj) {
            HashSet<Vertex> sources = new HashSet<Vertex>();
            for (TVertex vertex : obj.sources) {
                sources.add(Vertex.fromThrift(vertex));
            }
            HashSet<Vertex> targets = new HashSet<Vertex>();
            for (TVertex vertex : obj.targets) {
                targets.add(Vertex.fromThrift(vertex));
            }
            if (obj.edgetype == TEdgeType.PROJECTION) {
                return new MultiEdge(sources, targets, EdgeType.PROJECTION);
            }
            return new MultiEdge(sources, targets, EdgeType.PREDICATE);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiEdge multiEdge = (MultiEdge)o;
            return Objects.equals(this.sources_, multiEdge.sources_) && Objects.equals(this.targets_, multiEdge.targets_) && this.edgeType_ == multiEdge.edgeType_;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.sources_, this.targets_, this.edgeType_});
        }

        private boolean equalsForTests(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            MultiEdge edge = (MultiEdge)obj;
            return ColumnLineageGraph.setEqualsForTests(edge.sources_, this.sources_) && ColumnLineageGraph.setEqualsForTests(edge.targets_, this.targets_) && edge.edgeType_ == this.edgeType_;
        }

        public static enum EdgeType {
            PROJECTION,
            PREDICATE;

        }
    }

    private static final class VertexId
    extends Id<VertexId> {
        protected VertexId(int id) {
            super(id);
        }

        public static IdGenerator<VertexId> createGenerator() {
            return new IdGenerator<VertexId>(){

                @Override
                public VertexId getNextId() {
                    return new VertexId(this.nextId_++);
                }

                @Override
                public VertexId getMaxId() {
                    return new VertexId(this.nextId_ - 1);
                }
            };
        }
    }

    public static final class Vertex
    implements Comparable<Vertex> {
        private final VertexId id_;
        private final String type_ = "COLUMN";
        private final String label_;
        private final Metadata metadata_;

        public Vertex(VertexId id, String label, Metadata metadata) {
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkNotNull((Object)label);
            this.id_ = id;
            this.label_ = label;
            this.metadata_ = metadata;
        }

        public VertexId getVertexId() {
            return this.id_;
        }

        public String getLabel() {
            return this.label_;
        }

        public String getType() {
            return "COLUMN";
        }

        public Metadata getMetadata() {
            return this.metadata_;
        }

        public String toString() {
            return "(" + this.id_ + ":" + "COLUMN" + ":" + this.label_ + ")";
        }

        public Map<String, Object> toJson() {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
            obj.put("id", this.id_.asInt());
            obj.put("vertexType", "COLUMN");
            obj.put("vertexId", this.label_);
            if (this.metadata_ != null) {
                JSONObject jsonMetadata = new JSONObject();
                jsonMetadata.put((Object)"tableName", (Object)this.metadata_.tableName_);
                jsonMetadata.put((Object)"tableType", (Object)this.metadata_.tableType_);
                jsonMetadata.put((Object)"tableCreateTime", (Object)this.metadata_.tableCreateTime_);
                obj.put("metadata", jsonMetadata);
            }
            return obj;
        }

        public static Vertex fromJsonObj(JSONObject obj) {
            int id = ((Long)obj.get((Object)"id")).intValue();
            String label = (String)obj.get((Object)"vertexId");
            JSONObject jsonMetadata = (JSONObject)obj.get((Object)"metadata");
            if (jsonMetadata == null) {
                return new Vertex(new VertexId(id), label, null);
            }
            String tableName = (String)jsonMetadata.get((Object)"tableName");
            String tableType = (String)jsonMetadata.get((Object)"tableType");
            long tableCreateTime = (Long)jsonMetadata.get((Object)"tableCreateTime");
            return new Vertex(new VertexId(id), label, new Metadata(tableName, tableType, tableCreateTime));
        }

        public TVertex toThrift() {
            TVertex vertex = new TVertex(this.id_.asInt(), this.label_);
            if (this.metadata_ != null) {
                TVertexMetadata metadata = new TVertexMetadata(this.metadata_.tableName_, this.metadata_.tableType_, this.metadata_.tableCreateTime_);
                vertex.setMetadata(metadata);
            }
            return vertex;
        }

        public static Vertex fromThrift(TVertex vertex) {
            int id = Long.valueOf(vertex.id).intValue();
            TVertexMetadata thriftMetadata = vertex.getMetadata();
            Metadata metadata = null;
            if (thriftMetadata != null) {
                metadata = new Metadata(thriftMetadata.getTable_name(), thriftMetadata.getTable_type(), thriftMetadata.getTable_create_time());
            }
            return new Vertex(new VertexId(id), vertex.label, metadata);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Vertex vertex = (Vertex)o;
            return Objects.equals(this.id_, vertex.id_) && Objects.equals("COLUMN", vertex.type_) && Objects.equals(this.label_, vertex.label_) && Objects.equals(this.metadata_, vertex.metadata_);
        }

        public int hashCode() {
            return Objects.hash(this.id_, "COLUMN", this.label_, this.metadata_);
        }

        private boolean equalsForTests(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Vertex vertex = (Vertex)o;
            return Objects.equals(this.id_, vertex.id_) && (this.metadata_ == vertex.metadata_ || this.metadata_ != null && this.metadata_.equalsForTests(vertex.metadata_));
        }

        @Override
        public int compareTo(Vertex cmp) {
            return this.id_.compareTo(cmp.id_);
        }

        public static class Metadata {
            private final String tableName_;
            private final String tableType_;
            private final long tableCreateTime_;

            public Metadata(String tableName, String tableType, long tableCreateTime) {
                this.tableName_ = tableName;
                this.tableType_ = tableType;
                this.tableCreateTime_ = tableCreateTime;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Metadata metadata = (Metadata)o;
                return this.tableCreateTime_ == metadata.tableCreateTime_ && Objects.equals(this.tableName_, metadata.tableName_) && Objects.equals(this.tableType_, metadata.tableType_);
            }

            public int hashCode() {
                return Objects.hash(this.tableName_, this.tableType_, this.tableCreateTime_);
            }

            private boolean equalsForTests(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Metadata metadata = (Metadata)o;
                return Objects.equals(this.tableName_, metadata.tableName_) && Objects.equals(this.tableType_, metadata.tableType_);
            }
        }
    }
}

