/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Objects;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TypeDef;
import org.apache.impala.catalog.BuiltinsDb;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.thrift.TCastExpr;
import org.apache.impala.thrift.TExpr;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;

public class CastExpr
extends Expr {
    private final TypeDef targetTypeDef_;
    private final boolean isImplicit_;
    private boolean noOp_ = false;
    protected static final String CAST_FUNCTION_PREFIX = "castto";
    private static final String CAST_TO_CHAR_FN = "impala::CastFunctions::CastToChar";
    private static final String CAST_TO_VARCHAR_FN = "impala::CastFunctions::CastToVarchar";
    private final String castFormat_;
    private final TypeCompatibility compatibility_;

    public CastExpr(Type targetType, Expr e, String format, TypeCompatibility compatibility) {
        CastExpr castExpr;
        Preconditions.checkState((boolean)targetType.isValid());
        Preconditions.checkNotNull((Object)e);
        this.type_ = targetType;
        this.targetTypeDef_ = null;
        this.isImplicit_ = true;
        this.castFormat_ = format;
        this.compatibility_ = compatibility;
        if (e instanceof CastExpr && (castExpr = (CastExpr)e).isImplicit()) {
            e = (Expr)castExpr.getChild(0);
        }
        this.children_.add(e);
        try {
            this.analyze();
            this.computeNumDistinctValues();
            this.evalCost_ = this.computeEvalCost();
        }
        catch (AnalysisException ex) {
            Preconditions.checkState((boolean)false, (Object)"Implicit casts should never throw analysis exception.");
        }
        this.analysisDone();
    }

    public CastExpr(Type targetType, Expr e) {
        this(targetType, e, null, TypeCompatibility.DEFAULT);
    }

    public CastExpr(Type targetType, Expr e, TypeCompatibility compatibility) {
        this(targetType, e, null, compatibility);
    }

    public CastExpr(TypeDef targetTypeDef, Expr e) {
        this(targetTypeDef, e, null);
    }

    public CastExpr(TypeDef targetTypeDef, Expr e, String format) {
        Preconditions.checkNotNull((Object)targetTypeDef);
        Preconditions.checkNotNull((Object)e);
        this.isImplicit_ = false;
        this.targetTypeDef_ = targetTypeDef;
        this.children_.add(e);
        this.castFormat_ = format;
        this.compatibility_ = TypeCompatibility.DEFAULT;
    }

    protected CastExpr(CastExpr other) {
        super(other);
        this.targetTypeDef_ = other.targetTypeDef_;
        this.isImplicit_ = other.isImplicit_;
        this.noOp_ = other.noOp_;
        this.castFormat_ = other.castFormat_;
        this.compatibility_ = other.compatibility_;
    }

    private static String getFnName(Type targetType) {
        return CAST_FUNCTION_PREFIX + targetType.getPrimitiveType().toString();
    }

    public static void initBuiltins(Db db) {
        for (Type type : Type.getSupportedTypes()) {
            if (type.isNull()) continue;
            for (Type type2 : Type.getSupportedTypes()) {
                if (type2.isNull() || type.isStringType() && type2.isBoolean() || type.isDate() && !type2.isTimestamp() && !type2.isStringType() || type2.isDate() && !type.isTimestamp() && !type.isStringType() || (type.isBoolean() || type.isDateOrTimeType()) && type2.isDecimal()) continue;
                if (type.getPrimitiveType() == PrimitiveType.STRING && type2.getPrimitiveType() == PrimitiveType.CHAR) {
                    db.addBuiltin(ScalarFunction.createBuiltin(CastExpr.getFnName(ScalarType.CHAR), Lists.newArrayList((Object[])new Type[]{ScalarType.STRING}), false, ScalarType.CHAR, CAST_TO_CHAR_FN, null, null, true));
                    continue;
                }
                if (type.getPrimitiveType() == PrimitiveType.CHAR && type2.getPrimitiveType() == PrimitiveType.CHAR) {
                    db.addBuiltin(ScalarFunction.createBuiltin(CastExpr.getFnName(ScalarType.CHAR), Lists.newArrayList((Object[])new Type[]{ScalarType.createCharType(-1)}), false, ScalarType.CHAR, CAST_TO_CHAR_FN, null, null, true));
                    continue;
                }
                if (type.getPrimitiveType() == PrimitiveType.VARCHAR && type2.getPrimitiveType() == PrimitiveType.VARCHAR) {
                    db.addBuiltin(ScalarFunction.createBuiltin(CastExpr.getFnName(ScalarType.VARCHAR), Lists.newArrayList((Object[])new Type[]{ScalarType.VARCHAR}), false, ScalarType.VARCHAR, CAST_TO_VARCHAR_FN, null, null, true));
                    continue;
                }
                if (type.getPrimitiveType() == PrimitiveType.VARCHAR && type2.getPrimitiveType() == PrimitiveType.CHAR) {
                    db.addBuiltin(ScalarFunction.createBuiltin(CastExpr.getFnName(ScalarType.CHAR), Lists.newArrayList((Object[])new Type[]{ScalarType.VARCHAR}), false, ScalarType.CHAR, CAST_TO_CHAR_FN, null, null, true));
                    continue;
                }
                if (type.getPrimitiveType() == PrimitiveType.CHAR && type2.getPrimitiveType() == PrimitiveType.VARCHAR) {
                    db.addBuiltin(ScalarFunction.createBuiltin(CastExpr.getFnName(ScalarType.VARCHAR), Lists.newArrayList((Object[])new Type[]{ScalarType.CHAR}), false, ScalarType.VARCHAR, CAST_TO_VARCHAR_FN, null, null, true));
                    continue;
                }
                if (type.getPrimitiveType() == PrimitiveType.STRING && type2.getPrimitiveType() == PrimitiveType.VARCHAR) {
                    db.addBuiltin(ScalarFunction.createBuiltin(CastExpr.getFnName(ScalarType.VARCHAR), Lists.newArrayList((Object[])new Type[]{ScalarType.STRING}), false, ScalarType.VARCHAR, CAST_TO_VARCHAR_FN, null, null, true));
                    continue;
                }
                if (type.isBinary() && !type2.isString() || type2.isBinary() && !type.isString() || type.equals(type2) && !type.isDecimal()) continue;
                String beClass = type2.isDecimal() || type.isDecimal() ? "DecimalOperators" : "CastFunctions";
                String beSymbol = "impala::" + beClass + "::CastTo" + Function.getUdfType(type2);
                db.addBuiltin(ScalarFunction.createBuiltin(CastExpr.getFnName(type2), Lists.newArrayList((Object[])new Type[]{type}), false, type2, beSymbol, null, null, true));
            }
        }
    }

    public String getCastFormatWithEscapedSingleQuotes() {
        Preconditions.checkNotNull((Object)this.castFormat_);
        Preconditions.checkState((!this.castFormat_.isEmpty() ? 1 : 0) != 0);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.castFormat_.length(); ++i) {
            char currentChar = this.castFormat_.charAt(i);
            if (currentChar == '\'') {
                int backslashCount = 0;
                for (int j = i - 1; j >= 0 && this.castFormat_.charAt(j) == '\\'; --j) {
                    ++backslashCount;
                }
                if (backslashCount % 2 == 0) {
                    result.append('\\');
                }
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        if (this.isImplicit_) {
            if (options.showImplictCasts()) {
                return "CAST(" + ((Expr)this.getChild(0)).toSql(options) + " AS " + this.type_.toSql() + ")";
            }
            return ((Expr)this.getChild(0)).toSql(options);
        }
        String formatClause = "";
        if (this.castFormat_ != null && !this.castFormat_.isEmpty()) {
            formatClause = " FORMAT '" + this.getCastFormatWithEscapedSingleQuotes() + "'";
        }
        return "CAST(" + ((Expr)this.getChild(0)).toSql(options) + " AS " + this.targetTypeDef_.toString() + formatClause + ")";
    }

    @Override
    protected void treeToThriftHelper(TExpr container, ThriftSerializationCtx serialCtx) {
        if (this.noOp_) {
            ((Expr)this.getChild(0)).treeToThriftHelper(container, serialCtx);
            return;
        }
        super.treeToThriftHelper(container, serialCtx);
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.FUNCTION_CALL;
        if (null != this.castFormat_ && (this.type_.isDateOrTimeType() && ((Expr)this.getChild(0)).getType().isStringType() || this.type_.isStringType() && ((Expr)this.getChild(0)).getType().isDateOrTimeType())) {
            msg.cast_expr = new TCastExpr(this.castFormat_);
        }
    }

    @Override
    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("isImplicit", this.isImplicit_).add("target", (Object)this.type_).add("format", (Object)this.castFormat_).addValue((Object)super.debugString()).toString();
    }

    public boolean isImplicit() {
        return this.isImplicit_;
    }

    public TypeCompatibility getCompatibility() {
        return this.compatibility_;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((!this.isImplicit_ ? 1 : 0) != 0);
        this.targetTypeDef_.analyze(analyzer);
        this.type_ = this.targetTypeDef_.getType();
        this.analyze();
    }

    @Override
    protected float computeEvalCost() {
        float castCost = 10.0f;
        Type inType = ((Expr)this.children_.get(0)).getType();
        if ((this.type_.isVarchar() || this.type_.getPrimitiveType() == PrimitiveType.STRING) && (inType.isVarchar() || inType.getPrimitiveType() == PrimitiveType.STRING)) {
            castCost = 1.0f;
        } else if ((this.type_.isFloatingPointType() || this.type_.isIntegerType() || this.type_.isBoolean()) && (inType.isFloatingPointType() || inType.isIntegerType() || inType.isBoolean())) {
            castCost = 1.0f;
        }
        return ((Expr)this.getChild(0)).hasCost() ? ((Expr)this.getChild(0)).getCost() + castCost : -1.0f;
    }

    private void analyze() throws AnalysisException {
        Type childType;
        boolean twoStepCastNeeded;
        Preconditions.checkNotNull((Object)this.type_);
        if (this.type_.isComplexType()) {
            throw new AnalysisException("Unsupported cast to complex type: " + this.type_.toSql());
        }
        boolean bl = twoStepCastNeeded = this.type_.getPrimitiveType() == PrimitiveType.CHAR && ((Expr)this.children_.get(0)).getType().getPrimitiveType() != PrimitiveType.STRING && ((Expr)this.children_.get(0)).getType().getPrimitiveType() != PrimitiveType.CHAR;
        if (twoStepCastNeeded) {
            CastExpr tostring = new CastExpr(ScalarType.STRING, (Expr)this.children_.get(0), this.castFormat_, this.compatibility_);
            tostring.analyze();
            this.children_.set(0, tostring);
        }
        if (null != this.castFormat_ && !twoStepCastNeeded) {
            if (!(this.type_.isDateOrTimeType() && ((Expr)this.getChild(0)).getType().isStringType() || this.type_.isStringType() && ((Expr)this.getChild(0)).getType().isDateOrTimeType())) {
                throw new AnalysisException("FORMAT clause is not applicable from " + ((Expr)this.getChild(0)).getType() + " to " + this.type_);
            }
            if (this.castFormat_.isEmpty()) {
                throw new AnalysisException("FORMAT clause can't be empty");
            }
        }
        if (this.children_.get(0) instanceof NumericLiteral && this.type_.isFloatingPointType()) {
            NumericLiteral child = (NumericLiteral)this.children_.get(0);
            boolean isOverflow = NumericLiteral.isOverflow(child.getValue(), this.type_);
            if (this.type_.isScalarType(PrimitiveType.FLOAT)) {
                if (!isOverflow) {
                    ((NumericLiteral)this.children_.get(0)).explicitlyCastToFloat(this.type_);
                }
            } else {
                Preconditions.checkState((boolean)this.type_.isScalarType(PrimitiveType.DOUBLE));
                Preconditions.checkState((!isOverflow ? 1 : 0) != 0);
                ((NumericLiteral)this.children_.get(0)).explicitlyCastToFloat(this.type_);
            }
        }
        if (((Expr)this.children_.get(0)).getType().isNull()) {
            this.uncheckedCastChild(this.type_, 0);
        }
        if (Expr.IS_NULL_LITERAL.apply(this.children_.get(0))) {
            NullLiteral nullChild = (NullLiteral)this.children_.get(0);
            nullChild.uncheckedCastTo(this.type_);
        }
        Preconditions.checkState((!(childType = ((Expr)this.children_.get((int)0)).type_).isNull() ? 1 : 0) != 0);
        this.noOp_ = childType.equals(this.type_);
        if (this.noOp_) {
            return;
        }
        FunctionName fnName = new FunctionName("_impala_builtins", CastExpr.getFnName(this.type_));
        Type[] args = new Type[]{childType};
        Function searchDesc = new Function(fnName, args, (Type)Type.INVALID, false);
        if (this.isImplicit_) {
            this.fn_ = BuiltinsDb.getInstance().getFunction(searchDesc, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
            Preconditions.checkState((this.fn_ != null ? 1 : 0) != 0);
        } else {
            this.fn_ = BuiltinsDb.getInstance().getFunction(searchDesc, Function.CompareMode.IS_IDENTICAL);
            if (this.fn_ == null) {
                this.fn_ = BuiltinsDb.getInstance().getFunction(searchDesc.promoteCharsToStrings(), Function.CompareMode.IS_IDENTICAL);
            }
        }
        if (this.fn_ == null) {
            throw new AnalysisException("Invalid type cast of " + ((Expr)this.getChild(0)).toSql() + " from " + childType + " to " + this.type_);
        }
        Preconditions.checkState((boolean)this.type_.matchesType(this.fn_.getReturnType()), (Object)(this.type_ + " != " + this.fn_.getReturnType()));
    }

    @Override
    public Expr ignoreImplicitCast() {
        if (this.isImplicit()) {
            Preconditions.checkState((!(this.getChild(0) instanceof CastExpr) || !((CastExpr)this.getChild(0)).isImplicit() ? 1 : 0) != 0);
            return (Expr)this.getChild(0);
        }
        return this;
    }

    @Override
    public boolean isImplicitCast() {
        return this.isImplicit();
    }

    @Override
    protected boolean localEquals(Expr that) {
        if (!super.localEquals(that)) {
            return false;
        }
        CastExpr other = (CastExpr)that;
        return this.isImplicit_ == other.isImplicit_ && this.type_.equals(other.type_);
    }

    @Override
    public int hashCode() {
        if (this.isImplicit()) {
            return ((Expr)this.children_.get(0)).hashCode();
        }
        return Objects.hash(super.localHash(), this.type_, this.children_);
    }

    @Override
    public boolean shouldConvertToCNF() {
        return ((Expr)this.getChild(0)).shouldConvertToCNF();
    }

    @Override
    public Expr clone() {
        return new CastExpr(this);
    }

    @Override
    public boolean recordChildrenInWorkloadManagement() {
        return true;
    }
}

