/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CaseWhenClause;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.IsNullPredicate;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TCaseExpr;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;

public class CaseExpr
extends Expr {
    private FunctionCallExpr decodeExpr_;
    private boolean hasCaseExpr_;
    private boolean hasElseExpr_;

    public CaseExpr(Expr caseExpr, List<CaseWhenClause> whenClauses, Expr elseExpr) {
        if (caseExpr != null) {
            this.children_.add(caseExpr);
            this.hasCaseExpr_ = true;
        }
        for (CaseWhenClause whenClause : whenClauses) {
            Preconditions.checkNotNull((Object)whenClause.getWhenExpr());
            this.children_.add(whenClause.getWhenExpr());
            Preconditions.checkNotNull((Object)whenClause.getThenExpr());
            this.children_.add(whenClause.getThenExpr());
        }
        if (elseExpr != null) {
            this.children_.add(elseExpr);
            this.hasElseExpr_ = true;
        }
    }

    public CaseExpr(FunctionCallExpr decodeExpr) {
        this.decodeExpr_ = decodeExpr;
        this.hasCaseExpr_ = false;
        int childIdx = 0;
        Expr encoded = null;
        IsNullPredicate encodedIsNull = null;
        if (!decodeExpr.getChildren().isEmpty()) {
            encoded = (Expr)decodeExpr.getChild(childIdx++);
            encodedIsNull = new IsNullPredicate(encoded, false);
        }
        while (childIdx + 2 <= decodeExpr.getChildren().size()) {
            Expr candidate;
            if (IS_LITERAL.apply((Object)(candidate = (Expr)decodeExpr.getChild(childIdx++)))) {
                if (IS_NULL_VALUE.apply((Object)candidate)) {
                    this.children_.add(((Expr)encodedIsNull).clone());
                } else {
                    this.children_.add(new BinaryPredicate(BinaryPredicate.Operator.EQ, encoded.clone(), candidate));
                }
            } else {
                this.children_.add(new CompoundPredicate(CompoundPredicate.Operator.OR, new CompoundPredicate(CompoundPredicate.Operator.AND, ((Expr)encodedIsNull).clone(), new IsNullPredicate(candidate, false)), new BinaryPredicate(BinaryPredicate.Operator.EQ, encoded.clone(), candidate)));
            }
            this.children_.add(decodeExpr.getChild(childIdx++));
        }
        if (childIdx < decodeExpr.getChildren().size()) {
            this.hasElseExpr_ = true;
            this.children_.add(decodeExpr.getChild(childIdx));
        }
        Preconditions.checkState((!this.contains(encoded) && !this.contains(encodedIsNull) ? 1 : 0) != 0);
    }

    protected CaseExpr(CaseExpr other) {
        super(other);
        this.decodeExpr_ = other.decodeExpr_;
        this.hasCaseExpr_ = other.hasCaseExpr_;
        this.hasElseExpr_ = other.hasElseExpr_;
    }

    public static void initBuiltins(Db db) {
        for (Type type : Type.getSupportedTypes()) {
            if (type.isNull() || type.isScalarType(PrimitiveType.CHAR)) continue;
            db.addBuiltin(ScalarFunction.createBuiltinOperator("case", "", Lists.newArrayList((Object[])new Type[]{type}), type));
            db.addBuiltin(ScalarFunction.createBuiltinOperator("decode", "", Lists.newArrayList((Object[])new Type[]{type}), type));
        }
    }

    @Override
    protected boolean localEquals(Expr that) {
        if (!super.localEquals(that)) {
            return false;
        }
        CaseExpr expr = (CaseExpr)that;
        return this.hasCaseExpr_ == expr.hasCaseExpr_ && this.hasElseExpr_ == expr.hasElseExpr_ && this.isDecode() == expr.isDecode();
    }

    @Override
    protected int localHash() {
        return Objects.hash(super.localHash(), this.hasCaseExpr_, this.hasElseExpr_, this.isDecode());
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        return this.decodeExpr_ == null ? this.toCaseSql(options) : this.decodeExpr_.toSqlImpl(options);
    }

    @VisibleForTesting
    final String toCaseSql() {
        return this.toCaseSql(ToSqlOptions.DEFAULT);
    }

    String toCaseSql(ToSqlOptions options) {
        StringBuilder output = new StringBuilder("CASE");
        int childIdx = 0;
        if (this.hasCaseExpr_) {
            output.append(" " + ((Expr)this.children_.get(childIdx++)).toSql(options));
        }
        while (childIdx + 2 <= this.children_.size()) {
            output.append(" WHEN " + ((Expr)this.children_.get(childIdx++)).toSql(options));
            output.append(" THEN " + ((Expr)this.children_.get(childIdx++)).toSql(options));
        }
        if (this.hasElseExpr_) {
            output.append(" ELSE " + ((Expr)this.children_.get(this.children_.size() - 1)).toSql(options));
        }
        output.append(" END");
        return output.toString();
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.CASE_EXPR;
        msg.case_expr = new TCaseExpr(this.hasCaseExpr_, this.hasElseExpr_);
    }

    private void castCharToString(int childIndex) throws AnalysisException {
        if (((Expr)this.children_.get(childIndex)).getType().isScalarType(PrimitiveType.CHAR)) {
            this.children_.set(childIndex, ((Expr)this.children_.get(childIndex)).castTo(ScalarType.STRING));
        }
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        int i;
        int loopStart;
        if (this.isDecode()) {
            Preconditions.checkState((!this.hasCaseExpr_ ? 1 : 0) != 0);
            FunctionCallExpr.validateScalarFnParams(this.decodeExpr_.getParams());
            if (this.decodeExpr_.getChildren().size() < 3) {
                throw new AnalysisException("DECODE in '" + this.toSql() + "' requires at least 3 arguments.");
            }
        }
        Type whenType = null;
        Type returnType = null;
        Expr lastCompatibleThenExpr = null;
        Expr lastCompatibleWhenExpr = null;
        int loopEnd = this.children_.size();
        if (this.hasElseExpr_) {
            --loopEnd;
        }
        Expr caseExpr = null;
        if (this.hasCaseExpr_) {
            loopStart = 1;
            this.castCharToString(0);
            caseExpr = (Expr)this.children_.get(0);
            caseExpr.analyze(analyzer);
            whenType = caseExpr.getType();
            lastCompatibleWhenExpr = (Expr)this.children_.get(0);
        } else {
            whenType = Type.BOOLEAN;
            loopStart = 0;
        }
        for (i = loopStart; i < loopEnd; i += 2) {
            this.castCharToString(i);
            Expr whenExpr = (Expr)this.children_.get(i);
            if (this.hasCaseExpr_) {
                whenType = analyzer.getCompatibleType(whenType, lastCompatibleWhenExpr, whenExpr);
                lastCompatibleWhenExpr = whenExpr;
            } else {
                if (!Type.isImplicitlyCastable(whenExpr.getType(), Type.BOOLEAN, analyzer.getRegularCompatibilityLevel())) {
                    Preconditions.checkState((boolean)this.isCase());
                    throw new AnalysisException("When expr '" + whenExpr.toSql() + "' is not of type boolean and not castable to type boolean.");
                }
                if (!whenExpr.getType().isBoolean()) {
                    this.castChild(Type.BOOLEAN, i);
                }
            }
            Expr thenExpr = (Expr)this.children_.get(i + 1);
            returnType = analyzer.getCompatibleType(returnType, lastCompatibleThenExpr, thenExpr);
            lastCompatibleThenExpr = thenExpr;
        }
        if (this.hasElseExpr_) {
            Expr elseExpr = (Expr)this.children_.get(this.children_.size() - 1);
            returnType = analyzer.getCompatibleType(returnType, lastCompatibleThenExpr, elseExpr);
        }
        if (whenType.isNull()) {
            whenType = ScalarType.BOOLEAN;
        }
        if (returnType.isNull()) {
            returnType = ScalarType.BOOLEAN;
        }
        if (this.hasCaseExpr_) {
            if (!((Expr)this.children_.get((int)0)).type_.equals(whenType)) {
                this.castChild(whenType, 0);
            }
            for (i = loopStart; i < loopEnd; i += 2) {
                if (((Expr)this.children_.get((int)i)).type_.equals(whenType)) continue;
                this.castChild(whenType, i);
            }
        }
        for (i = loopStart + 1; i < this.children_.size(); i += 2) {
            if (((Expr)this.children_.get((int)i)).type_.equals(returnType)) continue;
            this.castChild(returnType, i);
        }
        if (this.hasElseExpr_ && !((Expr)this.children_.get((int)(this.children_.size() - 1))).type_.equals(returnType)) {
            this.castChild(returnType, this.children_.size() - 1);
        }
        Type[] args = new Type[]{whenType};
        this.fn_ = this.getBuiltinFunction(analyzer, "case", args, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        Preconditions.checkNotNull((Object)this.fn_);
        this.type_ = returnType;
    }

    @Override
    protected float computeEvalCost() {
        if (!this.hasChildCosts()) {
            return -1.0f;
        }
        float maxThenCost = 0.0f;
        float whenCosts = 0.0f;
        for (int i = 0; i < this.children_.size(); ++i) {
            float thenCost;
            if (this.hasCaseExpr_ && i % 2 == 1) {
                whenCosts += ((Expr)this.getChild(0)).getCost() + ((Expr)this.getChild(i)).getCost() + 1.0f;
                continue;
            }
            if (!this.hasCaseExpr_ && i % 2 == 0) {
                whenCosts += ((Expr)this.getChild(i)).getCost();
                continue;
            }
            if (i == 0 || !((thenCost = ((Expr)this.getChild(i)).getCost()) > maxThenCost)) continue;
            maxThenCost = thenCost;
        }
        return whenCosts + maxThenCost;
    }

    @Override
    protected void computeNumDistinctValues() {
        int loopStart = this.hasCaseExpr_ ? 1 : 0;
        boolean allOutputsKnown = true;
        int numOutputConstants = 0;
        long maxOutputNonConstNdv = -1L;
        HashSet constLiteralSet = Sets.newHashSetWithExpectedSize((int)this.children_.size());
        for (int i = loopStart; i < this.children_.size(); ++i) {
            if ((i - loopStart) % 2 == 0 && (i != this.children_.size() - 1 || !this.hasElseExpr_)) continue;
            Expr outputExpr = (Expr)this.children_.get(i);
            if (outputExpr.isConstant()) {
                if (IS_LITERAL.apply((Object)outputExpr)) {
                    LiteralExpr outputLiteral = (LiteralExpr)outputExpr;
                    if (!constLiteralSet.add(outputLiteral)) continue;
                    ++numOutputConstants;
                    continue;
                }
                ++numOutputConstants;
                continue;
            }
            long outputNdv = outputExpr.getNumDistinctValues();
            if (outputNdv == -1L) {
                allOutputsKnown = false;
            }
            maxOutputNonConstNdv = Math.max(maxOutputNonConstNdv, outputNdv);
        }
        if (!this.hasElseExpr_) {
            ++numOutputConstants;
        }
        this.numDistinctValues_ = allOutputsKnown ? (maxOutputNonConstNdv == -1L ? (long)numOutputConstants : (long)numOutputConstants + maxOutputNonConstNdv) : -1L;
    }

    private boolean isCase() {
        return !this.isDecode();
    }

    private boolean isDecode() {
        return this.decodeExpr_ != null;
    }

    public boolean hasCaseExpr() {
        return this.hasCaseExpr_;
    }

    public boolean hasElseExpr() {
        return this.hasElseExpr_;
    }

    @Override
    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("decodeExpr_", (Object)(this.decodeExpr_ == null ? "null" : this.decodeExpr_.debugString())).add("hasCaseExpr", this.hasCaseExpr_).add("hasElseExpr", this.hasElseExpr_).addValue((Object)super.debugString()).toString();
    }

    @Override
    public Expr clone() {
        return new CaseExpr(this);
    }

    @Override
    public boolean recordChildrenInWorkloadManagement() {
        return true;
    }
}

