/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import java.util.Objects;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.Predicate;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TExprNode;

public class BetweenPredicate
extends Predicate {
    private final boolean isNotBetween_;

    public BetweenPredicate(Expr compareExpr, Expr lowerBound, Expr upperBound, boolean isNotBetween) {
        this.children_.add(compareExpr);
        this.children_.add(lowerBound);
        this.children_.add(upperBound);
        this.isNotBetween_ = isNotBetween;
    }

    protected BetweenPredicate(BetweenPredicate other) {
        super(other);
        this.isNotBetween_ = other.isNotBetween_;
    }

    private boolean checkDecimalCast() {
        boolean allScalar = true;
        boolean noFloats = true;
        boolean atLeastOneDecimal = false;
        for (int i = 0; i < this.children_.size(); ++i) {
            if (!((Expr)this.children_.get(i)).getType().isScalarType()) {
                allScalar = false;
            }
            if (((Expr)this.children_.get(i)).getType().isFloatingPointType()) {
                noFloats = false;
            }
            if (!((Expr)this.children_.get(i)).getType().isDecimal()) continue;
            atLeastOneDecimal = true;
        }
        return allScalar && noFloats && atLeastOneDecimal;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
        if (this.children_.get(0) instanceof Subquery && (this.children_.get(1) instanceof Subquery || this.children_.get(2) instanceof Subquery)) {
            throw new AnalysisException("Comparison between subqueries is not supported in a BETWEEN predicate: " + this.toSqlImpl());
        }
        if (this.checkDecimalCast()) {
            for (int i = 0; i < this.children_.size(); ++i) {
                ScalarType t = (ScalarType)((Expr)this.children_.get(i)).getType();
                ((Expr)this.children_.get(i)).castTo(t.getMinResolutionDecimal());
            }
        } else {
            analyzer.castAllToCompatibleType(this.children_);
        }
    }

    @Override
    protected float computeEvalCost() {
        return -1.0f;
    }

    public boolean isNotBetween() {
        return this.isNotBetween_;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        throw new IllegalStateException("BetweenPredicate needs to be rewritten into a CompoundPredicate.");
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        String notStr = this.isNotBetween_ ? "NOT " : "";
        return ((Expr)this.children_.get(0)).toSql(options) + " " + notStr + "BETWEEN " + ((Expr)this.children_.get(1)).toSql(options) + " AND " + ((Expr)this.children_.get(2)).toSql(options);
    }

    @Override
    protected boolean localEquals(Expr that) {
        return super.localEquals(that) && this.isNotBetween_ == ((BetweenPredicate)that).isNotBetween_;
    }

    @Override
    protected int localHash() {
        return Objects.hash(super.localHash(), this.isNotBetween_);
    }

    @Override
    public Expr clone() {
        return new BetweenPredicate(this);
    }
}

