/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.impala.analysis.AnalyticWindow;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ArithmeticExpr;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.FunctionParams;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.OrderByElement;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.AggregateFunction;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.TreeNode;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.util.TColumnValueUtil;

public class AnalyticExpr
extends Expr {
    private FunctionCallExpr fnCall_;
    private final List<Expr> partitionExprs_;
    private List<OrderByElement> orderByElements_ = new ArrayList<OrderByElement>();
    private AnalyticWindow window_;
    private boolean resetWindow_ = false;
    private String sqlString_;
    public static String DENSERANK = "dense_rank";
    public static String RANK = "rank";
    public static String ROWNUMBER = "row_number";
    private static String LEAD = "lead";
    private static String LAG = "lag";
    private static String FIRST_VALUE = "first_value";
    private static String LAST_VALUE = "last_value";
    private static String FIRST_VALUE_IGNORE_NULLS = "first_value_ignore_nulls";
    private static String LAST_VALUE_IGNORE_NULLS = "last_value_ignore_nulls";
    private static String MIN = "min";
    private static String MAX = "max";
    private static String PERCENT_RANK = "percent_rank";
    private static String CUME_DIST = "cume_dist";
    private static String NTILE = "ntile";
    public static String FIRST_VALUE_REWRITE = "first_value_rewrite";

    public AnalyticExpr(FunctionCallExpr fnCall, List<Expr> partitionExprs, List<OrderByElement> orderByElements, AnalyticWindow window) {
        Preconditions.checkNotNull((Object)fnCall);
        this.fnCall_ = fnCall;
        ArrayList arrayList = this.partitionExprs_ = partitionExprs != null ? partitionExprs : new ArrayList();
        if (orderByElements != null) {
            this.orderByElements_.addAll(orderByElements);
        }
        this.window_ = window;
        this.setChildren();
    }

    protected AnalyticExpr(AnalyticExpr other) {
        super(other);
        this.fnCall_ = (FunctionCallExpr)other.fnCall_.clone();
        for (OrderByElement e : other.orderByElements_) {
            this.orderByElements_.add(e.clone());
        }
        this.partitionExprs_ = Expr.cloneList(other.partitionExprs_);
        this.window_ = other.window_ != null ? other.window_.clone() : null;
        this.resetWindow_ = other.resetWindow_;
        this.sqlString_ = other.sqlString_;
        this.setChildren();
    }

    public FunctionCallExpr getFnCall() {
        return this.fnCall_;
    }

    public List<Expr> getPartitionExprs() {
        return this.partitionExprs_;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements_;
    }

    public AnalyticWindow getWindow() {
        return this.window_;
    }

    @Override
    protected boolean localEquals(Expr that) {
        if (!super.localEquals(that)) {
            return false;
        }
        AnalyticExpr o = (AnalyticExpr)that;
        if (!this.fnCall_.equals(o.getFnCall())) {
            return false;
        }
        if (this.window_ == null != (o.window_ == null)) {
            return false;
        }
        if (this.window_ != null && !this.window_.equals(o.window_)) {
            return false;
        }
        return this.orderByElements_.equals(o.orderByElements_);
    }

    @Override
    protected int localHash() {
        return Objects.hash(super.localHash(), this.fnCall_, this.window_, this.orderByElements_);
    }

    @Override
    protected boolean isConstantImpl() {
        return false;
    }

    @Override
    public Expr clone() {
        return new AnalyticExpr(this);
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        if (this.sqlString_ != null) {
            return this.sqlString_;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.fnCall_.toSql(options)).append(" OVER (");
        boolean needsSpace = false;
        if (!this.partitionExprs_.isEmpty()) {
            sb.append("PARTITION BY ").append(Expr.toSql(this.partitionExprs_, options));
            needsSpace = true;
        }
        if (!this.orderByElements_.isEmpty()) {
            ArrayList<String> orderByStrings = new ArrayList<String>();
            for (OrderByElement e : this.orderByElements_) {
                orderByStrings.add(e.toSql(options));
            }
            if (needsSpace) {
                sb.append(" ");
            }
            sb.append("ORDER BY ").append(Joiner.on((String)", ").join(orderByStrings));
            needsSpace = true;
        }
        if (this.window_ != null) {
            if (needsSpace) {
                sb.append(" ");
            }
            sb.append(this.window_.toSql(options));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("fn", (Object)this.getFnCall()).add("window", (Object)this.window_).addValue((Object)super.debugString()).toString();
    }

    @Override
    protected void toThrift(TExprNode msg) {
    }

    private static boolean isAnalyticFn(Function fn) {
        return fn instanceof AggregateFunction && ((AggregateFunction)fn).isAnalyticFn();
    }

    public static boolean isAnalyticFn(Function fn, String fnName) {
        return AnalyticExpr.isAnalyticFn(fn) && fn.functionName().equals(fnName);
    }

    public static boolean isAggregateFn(Function fn) {
        return fn instanceof AggregateFunction && ((AggregateFunction)fn).isAggregateFn();
    }

    public static boolean isPercentRankFn(Function fn) {
        return AnalyticExpr.isAnalyticFn(fn, PERCENT_RANK);
    }

    public static boolean isCumeDistFn(Function fn) {
        return AnalyticExpr.isAnalyticFn(fn, CUME_DIST);
    }

    public static boolean isNtileFn(Function fn) {
        return AnalyticExpr.isAnalyticFn(fn, NTILE);
    }

    public static boolean isOffsetFn(Function fn) {
        return AnalyticExpr.isAnalyticFn(fn, LEAD) || AnalyticExpr.isAnalyticFn(fn, LAG);
    }

    public static boolean isMinMax(Function fn) {
        return AnalyticExpr.isAnalyticFn(fn, MIN) || AnalyticExpr.isAnalyticFn(fn, MAX);
    }

    public static boolean isRankingFn(Function fn) {
        return AnalyticExpr.isAnalyticFn(fn, RANK) || AnalyticExpr.isAnalyticFn(fn, DENSERANK) || AnalyticExpr.isAnalyticFn(fn, ROWNUMBER);
    }

    public static boolean isFirstOrLastValueFn(Function fn) {
        return AnalyticExpr.isAnalyticFn(fn, LAST_VALUE) || AnalyticExpr.isAnalyticFn(fn, FIRST_VALUE) || AnalyticExpr.isAnalyticFn(fn, LAST_VALUE_IGNORE_NULLS) || AnalyticExpr.isAnalyticFn(fn, FIRST_VALUE_IGNORE_NULLS);
    }

    public static Expr rewrite(AnalyticExpr analyticExpr) {
        Function fn = analyticExpr.getFnCall().getFn();
        if (AnalyticExpr.isPercentRankFn(fn)) {
            return AnalyticExpr.createPercentRank(analyticExpr);
        }
        if (AnalyticExpr.isCumeDistFn(fn)) {
            return AnalyticExpr.createCumeDist(analyticExpr);
        }
        if (AnalyticExpr.isNtileFn(fn)) {
            return AnalyticExpr.createNtile(analyticExpr);
        }
        return null;
    }

    private static Expr createPercentRank(AnalyticExpr analyticExpr) {
        Preconditions.checkState((boolean)AnalyticExpr.isPercentRankFn(analyticExpr.getFnCall().getFn()));
        NumericLiteral zero = NumericLiteral.create(0L, (Type)ScalarType.BIGINT);
        NumericLiteral one = NumericLiteral.create(1L, (Type)ScalarType.BIGINT);
        AnalyticExpr countExpr = AnalyticExpr.create("count", analyticExpr, false, false);
        AnalyticExpr rankExpr = AnalyticExpr.create("rank", analyticExpr, true, false);
        ArithmeticExpr arithmeticRewrite = new ArithmeticExpr(ArithmeticExpr.Operator.DIVIDE, new ArithmeticExpr(ArithmeticExpr.Operator.SUBTRACT, rankExpr, one), new ArithmeticExpr(ArithmeticExpr.Operator.SUBTRACT, countExpr, one));
        ArrayList<Expr> ifParams = new ArrayList<Expr>();
        ifParams.add(new BinaryPredicate(BinaryPredicate.Operator.EQ, one, countExpr));
        ifParams.add(zero);
        ifParams.add(arithmeticRewrite);
        FunctionCallExpr resultantRewrite = new FunctionCallExpr("if", ifParams);
        return resultantRewrite;
    }

    private static Expr createCumeDist(AnalyticExpr analyticExpr) {
        Preconditions.checkState((boolean)AnalyticExpr.isCumeDistFn(analyticExpr.getFnCall().getFn()));
        AnalyticExpr rankExpr = AnalyticExpr.create("rank", analyticExpr, true, true);
        AnalyticExpr countExpr = AnalyticExpr.create("count", analyticExpr, false, false);
        NumericLiteral one = NumericLiteral.create(1L, (Type)ScalarType.BIGINT);
        ArithmeticExpr arithmeticRewrite = new ArithmeticExpr(ArithmeticExpr.Operator.DIVIDE, new ArithmeticExpr(ArithmeticExpr.Operator.ADD, new ArithmeticExpr(ArithmeticExpr.Operator.SUBTRACT, countExpr, rankExpr), one), countExpr);
        return arithmeticRewrite;
    }

    private static Expr createNtile(AnalyticExpr analyticExpr) {
        Preconditions.checkState((boolean)AnalyticExpr.isNtileFn(analyticExpr.getFnCall().getFn()));
        Expr bucketExpr = (Expr)analyticExpr.getChild(0);
        AnalyticExpr rowNumExpr = AnalyticExpr.create("row_number", analyticExpr, true, false);
        AnalyticExpr countExpr = AnalyticExpr.create("count", analyticExpr, false, false);
        ArrayList<Expr> ifParams = new ArrayList<Expr>();
        ifParams.add(new BinaryPredicate(BinaryPredicate.Operator.LT, bucketExpr, countExpr));
        ifParams.add(bucketExpr);
        ifParams.add(countExpr);
        NumericLiteral one = NumericLiteral.create(1L, (Type)ScalarType.BIGINT);
        ArithmeticExpr minMultiplyRowMinusOne = new ArithmeticExpr(ArithmeticExpr.Operator.MULTIPLY, new ArithmeticExpr(ArithmeticExpr.Operator.SUBTRACT, rowNumExpr, one), new FunctionCallExpr("if", ifParams));
        ArithmeticExpr divideAddOne = new ArithmeticExpr(ArithmeticExpr.Operator.ADD, new ArithmeticExpr(ArithmeticExpr.Operator.INT_DIVIDE, minMultiplyRowMinusOne, countExpr), one);
        return divideAddOne;
    }

    private static AnalyticExpr create(String fnName, AnalyticExpr referenceExpr, boolean copyOrderBy, boolean reverseOrderBy) {
        FunctionCallExpr fnExpr = new FunctionCallExpr(fnName, new ArrayList<Expr>());
        fnExpr.setIsAnalyticFnCall(true);
        List<OrderByElement> orderByElements = null;
        if (copyOrderBy) {
            if (reverseOrderBy) {
                orderByElements = OrderByElement.reverse(referenceExpr.getOrderByElements());
            } else {
                orderByElements = new ArrayList<OrderByElement>();
                for (OrderByElement elem : referenceExpr.getOrderByElements()) {
                    orderByElements.add(elem.clone());
                }
            }
        }
        AnalyticExpr analyticExpr = new AnalyticExpr(fnExpr, Expr.cloneList(referenceExpr.getPartitionExprs()), orderByElements, null);
        return analyticExpr;
    }

    private void checkRangeOffsetBoundaryExpr(AnalyticWindow.Boundary boundary) throws AnalysisException {
        Preconditions.checkState((boolean)boundary.getType().isOffset());
        if (this.orderByElements_.size() > 1) {
            throw new AnalysisException("Only one ORDER BY expression allowed if used with a RANGE window with PRECEDING/FOLLOWING: " + this.toSql());
        }
        Expr rangeExpr = boundary.getExpr();
        if (!Type.isImplicitlyCastable(rangeExpr.getType(), this.orderByElements_.get(0).getExpr().getType(), TypeCompatibility.STRICT_DECIMAL)) {
            throw new AnalysisException("The value expression of a PRECEDING/FOLLOWING clause of a RANGE window must be implicitly convertable to the ORDER BY expression's type: " + rangeExpr.toSql() + " cannot be implicitly converted to " + this.orderByElements_.get(0).getExpr().getType().toSql());
        }
    }

    void checkOffset(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((boolean)AnalyticExpr.isOffsetFn(this.getFnCall().getFn()));
        Preconditions.checkState((this.getFnCall().getChildren().size() > 1 ? 1 : 0) != 0);
        Expr offset = (Expr)this.getFnCall().getChild(1);
        Preconditions.checkState((boolean)offset.getType().isIntegerType());
        boolean isPosConstant = true;
        if (!offset.isConstant()) {
            isPosConstant = false;
        } else {
            try {
                TColumnValue val = FeSupport.EvalExprWithoutRow(offset, analyzer.getQueryCtx());
                if (TColumnValueUtil.getNumericVal(val) <= 0.0) {
                    isPosConstant = false;
                }
            }
            catch (InternalException exc) {
                throw new AnalysisException("Couldn't evaluate LEAD/LAG offset: " + exc.getMessage());
            }
        }
        if (!isPosConstant) {
            throw new AnalysisException("The offset parameter of LEAD/LAG must be a constant positive integer: " + this.getFnCall().toSql());
        }
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        this.fnCall_.analyze(analyzer);
        this.type_ = this.getFnCall().getType();
        for (Expr expr : this.partitionExprs_) {
            if (!expr.getType().isComplexType()) continue;
            throw new AnalysisException(String.format("PARTITION BY expression '%s' with complex type '%s' is not supported.", expr.toSql(), expr.getType().toSql()));
        }
        for (OrderByElement orderByElement : this.orderByElements_) {
            if (!orderByElement.getExpr().getType().isComplexType()) continue;
            throw new AnalysisException(String.format("ORDER BY expression '%s' with complex type '%s' is not supported.", orderByElement.getExpr().toSql(), orderByElement.getExpr().getType().toSql()));
        }
        if (this.getFnCall().getParams().isDistinct()) {
            throw new AnalysisException("DISTINCT not allowed in analytic function: " + this.getFnCall().toSql());
        }
        Function fn = this.getFnCall().getFn();
        if (this.getFnCall().getParams().isIgnoreNulls() && !AnalyticExpr.isFirstOrLastValueFn(fn)) {
            throw new AnalysisException("Function " + fn.functionName().toUpperCase() + " does not accept the keyword IGNORE NULLS.");
        }
        if (!(fn instanceof AggregateFunction)) {
            throw new AnalysisException("OVER clause requires aggregate or analytic function: " + this.getFnCall().toSql());
        }
        if (!AnalyticExpr.isAnalyticFn(fn)) {
            throw new AnalysisException(String.format("Aggregate function '%s' not supported with OVER clause.", this.getFnCall().toSql()));
        }
        if (AnalyticExpr.isAnalyticFn(fn) && !AnalyticExpr.isAggregateFn(fn)) {
            if (!AnalyticExpr.isFirstOrLastValueFn(fn) && this.orderByElements_.isEmpty()) {
                throw new AnalysisException("'" + this.getFnCall().toSql() + "' requires an ORDER BY clause");
            }
            if ((AnalyticExpr.isRankingFn(fn) || AnalyticExpr.isOffsetFn(fn)) && this.window_ != null) {
                throw new AnalysisException("Windowing clause not allowed with '" + this.getFnCall().toSql() + "'");
            }
            if (AnalyticExpr.isOffsetFn(fn) && this.getFnCall().getChildren().size() > 1) {
                this.checkOffset(analyzer);
                if (this.getFnCall().getChildren().size() > 2 && !((Expr)this.getFnCall().getChild(2)).isConstant()) {
                    throw new AnalysisException("The default parameter (parameter 3) of LEAD/LAG must be a constant: " + this.getFnCall().toSql());
                }
            }
            if (AnalyticExpr.isNtileFn(fn)) {
                if (!((Expr)this.getFnCall().getChild(0)).isConstant()) {
                    throw new AnalysisException("NTILE() requires a constant argument");
                }
                try {
                    TColumnValue tColumnValue = FeSupport.EvalExprWithoutRow((Expr)this.getFnCall().getChild(0), analyzer.getQueryCtx());
                    Long arg = tColumnValue.getLong_val();
                    if (arg <= 0L) {
                        throw new AnalysisException("NTILE() requires a positive argument: " + arg);
                    }
                }
                catch (InternalException internalException) {
                    throw new AnalysisException(internalException.toString());
                }
            }
        }
        if (this.window_ != null) {
            if (this.orderByElements_.isEmpty()) {
                throw new AnalysisException("Windowing clause requires ORDER BY clause: " + this.toSql());
            }
            this.window_.analyze(analyzer);
            if (!this.orderByElements_.isEmpty() && this.window_.getType() == AnalyticWindow.Type.RANGE) {
                if (this.window_.getLeftBoundary().getType().isOffset()) {
                    this.checkRangeOffsetBoundaryExpr(this.window_.getLeftBoundary());
                }
                if (this.window_.getRightBoundary() != null && this.window_.getRightBoundary().getType().isOffset()) {
                    this.checkRangeOffsetBoundaryExpr(this.window_.getRightBoundary());
                }
            }
        }
        if (TreeNode.contains(this.getChildren(), AnalyticExpr.class)) {
            throw new AnalysisException("Nesting of analytic expressions is not allowed: " + this.toSql());
        }
        this.sqlString_ = this.toSql();
        this.standardize(analyzer);
        if (this.window_ != null && AnalyticExpr.isMinMax(fn) && this.window_.getLeftBoundary().getType() != AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING) {
            throw new AnalysisException("'" + this.getFnCall().toSql() + "' is only supported with an UNBOUNDED PRECEDING start bound.");
        }
        this.setChildren();
    }

    @Override
    protected float computeEvalCost() {
        return -1.0f;
    }

    protected void standardize(Analyzer analyzer) {
        FunctionName analyticFnName = this.getFnCall().getFnName();
        if (analyticFnName.getFunction().equals(ROWNUMBER)) {
            Preconditions.checkState((this.window_ == null ? 1 : 0) != 0, (Object)"Unexpected window set for row_numer()");
            this.window_ = new AnalyticWindow(AnalyticWindow.Type.ROWS, new AnalyticWindow.Boundary(AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING, null), new AnalyticWindow.Boundary(AnalyticWindow.BoundaryType.CURRENT_ROW, null));
            this.resetWindow_ = true;
            return;
        }
        if (AnalyticExpr.isOffsetFn(this.getFnCall().getFn())) {
            Preconditions.checkState((this.window_ == null ? 1 : 0) != 0);
            ArrayList newExprParams = null;
            if (this.getFnCall().getChildren().size() == 1) {
                newExprParams = Lists.newArrayListWithExpectedSize((int)3);
                newExprParams.addAll(this.getFnCall().getChildren());
                newExprParams.add(NumericLiteral.create(1L));
                newExprParams.add(this.createNullLiteral());
            } else if (this.getFnCall().getChildren().size() == 2) {
                newExprParams = Lists.newArrayListWithExpectedSize((int)3);
                newExprParams.addAll(this.getFnCall().getChildren());
                newExprParams.add(this.createNullLiteral());
            } else {
                Preconditions.checkState((this.getFnCall().getChildren().size() == 3 ? 1 : 0) != 0);
            }
            if (newExprParams != null) {
                this.fnCall_ = this.fnCall_.cloneWithNewParams(new FunctionParams(newExprParams));
                this.fnCall_.setIsAnalyticFnCall(true);
                this.fnCall_.analyzeNoThrow(analyzer);
            }
            AnalyticWindow.BoundaryType rightBoundaryType = AnalyticWindow.BoundaryType.FOLLOWING;
            if (analyticFnName.getFunction().equals(LAG)) {
                rightBoundaryType = AnalyticWindow.BoundaryType.PRECEDING;
            }
            this.window_ = new AnalyticWindow(AnalyticWindow.Type.ROWS, new AnalyticWindow.Boundary(AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING, null), new AnalyticWindow.Boundary(rightBoundaryType, this.getOffsetExpr(this.getFnCall())));
            try {
                this.window_.analyze(analyzer);
            }
            catch (AnalysisException e) {
                throw new IllegalStateException(e);
            }
            this.resetWindow_ = true;
            return;
        }
        if (analyticFnName.getFunction().equals(FIRST_VALUE) && this.window_ != null && this.window_.getLeftBoundary().getType() != AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING && !this.getFnCall().getParams().isIgnoreNulls()) {
            if (this.window_.getLeftBoundary().getType() != AnalyticWindow.BoundaryType.PRECEDING) {
                this.window_ = new AnalyticWindow(this.window_.getType(), this.window_.getLeftBoundary(), this.window_.getLeftBoundary());
                this.fnCall_ = this.createRewrittenFunction(new FunctionName(LAST_VALUE), this.getFnCall().getParams());
            } else {
                List<Expr> paramExprs = Expr.cloneList(this.getFnCall().getParams().exprs());
                if (this.window_.getRightBoundary().getType() == AnalyticWindow.BoundaryType.PRECEDING) {
                    paramExprs.add(NumericLiteral.create(this.window_.getRightBoundary().getOffsetValue(), (Type)Type.BIGINT));
                } else {
                    paramExprs.add(NumericLiteral.create(-1L, (Type)Type.BIGINT));
                }
                this.window_ = new AnalyticWindow(this.window_.getType(), new AnalyticWindow.Boundary(AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING, null), this.window_.getLeftBoundary());
                this.fnCall_ = this.createRewrittenFunction(new FunctionName(FIRST_VALUE_REWRITE), new FunctionParams(paramExprs));
                this.fnCall_.setIsInternalFnCall(true);
            }
            this.fnCall_.setIsAnalyticFnCall(true);
            this.fnCall_.analyzeNoThrow(analyzer);
            this.type_ = this.fnCall_.getType();
            analyticFnName = this.getFnCall().getFnName();
        }
        if (this.window_ != null && this.window_.getLeftBoundary().getType() != AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING && (this.window_.getRightBoundary().getType() == AnalyticWindow.BoundaryType.UNBOUNDED_FOLLOWING || analyticFnName.getFunction().equals(FIRST_VALUE) && this.getFnCall().getParams().isIgnoreNulls())) {
            this.orderByElements_ = OrderByElement.reverse(this.orderByElements_);
            this.window_ = this.window_.reverse();
            FunctionName reversedFnName = null;
            if (analyticFnName.getFunction().equals(FIRST_VALUE)) {
                reversedFnName = new FunctionName(LAST_VALUE);
            } else if (analyticFnName.getFunction().equals(LAST_VALUE)) {
                reversedFnName = new FunctionName(FIRST_VALUE);
            }
            if (reversedFnName != null) {
                this.fnCall_ = this.createRewrittenFunction(reversedFnName, this.getFnCall().getParams());
                this.fnCall_.setIsAnalyticFnCall(true);
                this.fnCall_.analyzeNoThrow(analyzer);
            }
            analyticFnName = this.getFnCall().getFnName();
        }
        if (analyticFnName.getFunction().equals(FIRST_VALUE) && this.window_ != null && this.window_.getLeftBoundary().getType() == AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING && this.window_.getRightBoundary().getType() != AnalyticWindow.BoundaryType.PRECEDING && !this.getFnCall().getParams().isIgnoreNulls()) {
            this.window_.setRightBoundary(new AnalyticWindow.Boundary(AnalyticWindow.BoundaryType.CURRENT_ROW, null));
        }
        if (!this.orderByElements_.isEmpty() && this.window_ == null) {
            this.window_ = AnalyticWindow.DEFAULT_WINDOW;
            this.resetWindow_ = true;
        }
        if ((analyticFnName.getFunction().equals(FIRST_VALUE) || analyticFnName.getFunction().equals(LAST_VALUE)) && this.window_ != null && this.window_.getType() == AnalyticWindow.Type.RANGE) {
            this.window_ = new AnalyticWindow(AnalyticWindow.Type.ROWS, this.window_.getLeftBoundary(), this.window_.getRightBoundary());
        }
        if (this.getFnCall().getParams().isIgnoreNulls()) {
            if (analyticFnName.getFunction().equals(LAST_VALUE)) {
                this.fnCall_ = this.createRewrittenFunction(new FunctionName(LAST_VALUE_IGNORE_NULLS), this.getFnCall().getParams());
            } else {
                Preconditions.checkState((boolean)analyticFnName.getFunction().equals(FIRST_VALUE));
                this.fnCall_ = this.createRewrittenFunction(new FunctionName(FIRST_VALUE_IGNORE_NULLS), this.getFnCall().getParams());
            }
            this.getFnCall().getParams().setIsIgnoreNulls(false);
            this.fnCall_.setIsAnalyticFnCall(true);
            this.fnCall_.setIsInternalFnCall(true);
            this.fnCall_.analyzeNoThrow(analyzer);
            analyticFnName = this.getFnCall().getFnName();
            Preconditions.checkState((boolean)this.type_.equals(this.fnCall_.getType()));
        }
    }

    private Expr getOffsetExpr(FunctionCallExpr offsetFnCall) {
        Preconditions.checkState((boolean)AnalyticExpr.isOffsetFn(this.getFnCall().getFn()));
        if (offsetFnCall.getChild(1) != null) {
            return (Expr)offsetFnCall.getChild(1);
        }
        return NumericLiteral.create(1L);
    }

    private void syncWithChildren() {
        int i;
        int numArgs = this.fnCall_.getChildren().size();
        for (int i2 = 0; i2 < numArgs; ++i2) {
            this.fnCall_.setChild(i2, this.getChild(i2));
        }
        int numPartitionExprs = this.partitionExprs_.size();
        for (i = 0; i < numPartitionExprs; ++i) {
            this.partitionExprs_.set(i, (Expr)this.getChild(numArgs + i));
        }
        for (i = 0; i < this.orderByElements_.size(); ++i) {
            this.orderByElements_.get(i).setExpr((Expr)this.getChild(numArgs + numPartitionExprs + i));
        }
    }

    protected void setChildren() {
        this.getChildren().clear();
        this.addChildren(this.fnCall_.getChildren());
        this.addChildren(this.partitionExprs_);
        for (OrderByElement e : this.orderByElements_) {
            this.addChild(e.getExpr());
        }
        if (this.window_ != null) {
            if (this.window_.getLeftBoundary().getExpr() != null) {
                this.addChild(this.window_.getLeftBoundary().getExpr());
            }
            if (this.window_.getRightBoundary() != null && this.window_.getRightBoundary().getExpr() != null) {
                this.addChild(this.window_.getRightBoundary().getExpr());
            }
        }
    }

    @Override
    protected void resetAnalysisState() {
        super.resetAnalysisState();
        this.fnCall_.resetAnalysisState();
        if (this.resetWindow_) {
            this.window_ = null;
        }
        this.resetWindow_ = false;
        this.syncWithChildren();
    }

    @Override
    protected Expr substituteImpl(ExprSubstitutionMap smap, Analyzer analyzer) {
        Expr e = super.substituteImpl(smap, analyzer);
        if (!(e instanceof AnalyticExpr)) {
            return e;
        }
        ((AnalyticExpr)e).syncWithChildren();
        return e;
    }

    protected FunctionCallExpr createRewrittenFunction(FunctionName funcName, FunctionParams funcParams) {
        return new FunctionCallExpr(funcName, funcParams);
    }
}

