/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.impala.analysis.AdminFnStmt;
import org.apache.impala.analysis.AlterDbStmt;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.AlterViewStmt;
import org.apache.impala.analysis.AnalysisDriver;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CommentOnStmt;
import org.apache.impala.analysis.ComputeStatsStmt;
import org.apache.impala.analysis.ConvertTableToIcebergStmt;
import org.apache.impala.analysis.CopyTestCaseStmt;
import org.apache.impala.analysis.CreateDataSrcStmt;
import org.apache.impala.analysis.CreateDbStmt;
import org.apache.impala.analysis.CreateDropRoleStmt;
import org.apache.impala.analysis.CreateTableAsSelectStmt;
import org.apache.impala.analysis.CreateTableLikeStmt;
import org.apache.impala.analysis.CreateTableStmt;
import org.apache.impala.analysis.CreateUdaStmt;
import org.apache.impala.analysis.CreateUdfStmt;
import org.apache.impala.analysis.CreateViewStmt;
import org.apache.impala.analysis.DeleteStmt;
import org.apache.impala.analysis.DescribeDbStmt;
import org.apache.impala.analysis.DescribeHistoryStmt;
import org.apache.impala.analysis.DescribeTableStmt;
import org.apache.impala.analysis.DropDataSrcStmt;
import org.apache.impala.analysis.DropDbStmt;
import org.apache.impala.analysis.DropFunctionStmt;
import org.apache.impala.analysis.DropStatsStmt;
import org.apache.impala.analysis.DropTableOrViewStmt;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.GrantRevokePrivStmt;
import org.apache.impala.analysis.GrantRevokeRoleStmt;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.InsertStmt;
import org.apache.impala.analysis.KillQueryStmt;
import org.apache.impala.analysis.LoadDataStmt;
import org.apache.impala.analysis.MergeStmt;
import org.apache.impala.analysis.OptimizeStmt;
import org.apache.impala.analysis.ParsedStatement;
import org.apache.impala.analysis.ParsedStatementImpl;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.ResetMetadataStmt;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SetOperationStmt;
import org.apache.impala.analysis.SetStmt;
import org.apache.impala.analysis.ShowCreateFunctionStmt;
import org.apache.impala.analysis.ShowCreateTableStmt;
import org.apache.impala.analysis.ShowDataSrcsStmt;
import org.apache.impala.analysis.ShowDbsStmt;
import org.apache.impala.analysis.ShowFilesStmt;
import org.apache.impala.analysis.ShowFunctionsStmt;
import org.apache.impala.analysis.ShowGrantPrincipalStmt;
import org.apache.impala.analysis.ShowMetadataTablesStmt;
import org.apache.impala.analysis.ShowRolesStmt;
import org.apache.impala.analysis.ShowStatsStmt;
import org.apache.impala.analysis.ShowTablesStmt;
import org.apache.impala.analysis.ShowViewsStmt;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.StmtMetadataLoader;
import org.apache.impala.analysis.StmtRewriter;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TruncateStmt;
import org.apache.impala.analysis.UpdateStmt;
import org.apache.impala.analysis.UseStmt;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.authorization.AuthorizationContext;
import org.apache.impala.authorization.AuthorizationException;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.PrivilegeRequest;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.service.CompilerFactory;
import org.apache.impala.thrift.TAccessEvent;
import org.apache.impala.thrift.TClientRequest;
import org.apache.impala.thrift.TLineageGraph;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.util.EventSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalysisContext {
    private static final Logger LOG = LoggerFactory.getLogger(AnalysisContext.class);
    private final TQueryCtx queryCtx_;
    private final AuthorizationFactory authzFactory_;
    private final EventSequence timeline_;
    private FeCatalog catalog_;
    private AnalysisResult analysisResult_;
    private boolean useHiveColLabels_;

    public AnalysisContext(TQueryCtx queryCtx, AuthorizationFactory authzFactory, EventSequence timeline) {
        this.queryCtx_ = queryCtx;
        this.authzFactory_ = authzFactory;
        this.timeline_ = timeline;
    }

    public FeCatalog getCatalog() {
        return this.catalog_;
    }

    public TQueryCtx getQueryCtx() {
        return this.queryCtx_;
    }

    public AuthorizationFactory getAuthzFactory() {
        return this.authzFactory_;
    }

    public boolean getUseHiveColLabels() {
        return this.useHiveColLabels_;
    }

    public TQueryOptions getQueryOptions() {
        return this.queryCtx_.client_request.query_options;
    }

    public String getUser() {
        return this.queryCtx_.session.connected_user;
    }

    public void setUseHiveColLabels(boolean b) {
        Preconditions.checkState((boolean)RuntimeEnv.INSTANCE.isTestEnv());
        this.useHiveColLabels_ = b;
    }

    public AnalysisResult analyzeAndAuthorize(CompilerFactory compilerFactory, ParsedStatement parsedStmt, StmtMetadataLoader.StmtTableCache stmtTableCache, AuthorizationChecker authzChecker) throws ImpalaException {
        return this.analyzeAndAuthorize(compilerFactory, parsedStmt, stmtTableCache, authzChecker, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalysisResult analyzeAndAuthorize(CompilerFactory compilerFactory, ParsedStatement parsedStmt, StmtMetadataLoader.StmtTableCache stmtTableCache, AuthorizationChecker authzChecker, boolean disableAuthorization) throws ImpalaException {
        this.catalog_ = stmtTableCache.catalog;
        TClientRequest clientRequest = this.queryCtx_.getClient_request();
        AuthorizationContext authzCtx = authzChecker.createAuthorizationContext(true, clientRequest.isSetRedacted_stmt() ? clientRequest.getRedacted_stmt() : clientRequest.getStmt(), this.queryCtx_.getSession(), Optional.of(this.timeline_));
        Preconditions.checkState((authzCtx != null ? 1 : 0) != 0);
        AnalysisDriver analysisDriver = compilerFactory.createAnalysisDriver(this, parsedStmt, stmtTableCache, authzCtx);
        this.analysisResult_ = analysisDriver.analyze();
        authzChecker.postAnalyze(authzCtx);
        ImpalaException analysisException = this.analysisResult_.getException();
        if (analysisException == null && this.analysisResult_.getStmt() instanceof SelectStmt && ((SelectStmt)this.analysisResult_.getStmt()).returnsAtMostOneRow()) {
            clientRequest.query_options.setSpool_query_results(false);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Result spooling is disabled due to the statement returning at most one row.");
            }
        }
        long durationMs = this.timeline_.markEvent("Analysis finished") / 1000000L;
        LOG.info("Analysis took {} ms", (Object)durationMs);
        AuthorizationException authException = null;
        if (!disableAuthorization) {
            try {
                if (this.analysisResult_.getAnalyzer().encounteredMVAuthException()) {
                    throw new AuthorizationException(this.analysisResult_.getAnalyzer().getMVAuthExceptionMsg());
                }
                authzChecker.authorize(authzCtx, this.analysisResult_, this.catalog_);
                authzChecker.postAuthorize(authzCtx, authException == null, analysisException == null);
            }
            catch (AuthorizationException e) {
                try {
                    authException = e;
                    authzChecker.postAuthorize(authzCtx, authException == null, analysisException == null);
                }
                catch (Throwable throwable) {
                    authzChecker.postAuthorize(authzCtx, authException == null, analysisException == null);
                    throw throwable;
                }
            }
        }
        if (authException != null) {
            throw authException;
        }
        if (analysisException != null) {
            throw analysisException;
        }
        return this.analysisResult_;
    }

    public Analyzer getAnalyzer() {
        return this.analysisResult_.getAnalyzer();
    }

    public EventSequence getTimeline() {
        return this.timeline_;
    }

    public AnalysisResult getAnalysisResult() {
        Preconditions.checkNotNull((Object)this.analysisResult_);
        Preconditions.checkNotNull((Object)this.analysisResult_.stmt_);
        return this.analysisResult_;
    }

    public static class AnalysisDriverImpl
    implements AnalysisDriver {
        private ParsedStatement parsedStmt_;
        private StatementBase stmt_;
        private Analyzer analyzer_;
        private final AnalysisContext ctx_;
        private final StmtMetadataLoader.StmtTableCache stmtTableCache_;
        private final AuthorizationContext authzCtx_;

        public AnalysisDriverImpl(AnalysisContext ctx, ParsedStatement parsedStmt, StmtMetadataLoader.StmtTableCache stmtTableCache, AuthorizationContext authzCtx) {
            Preconditions.checkNotNull((Object)parsedStmt);
            this.parsedStmt_ = parsedStmt;
            this.ctx_ = ctx;
            Preconditions.checkNotNull((Object)parsedStmt.getTopLevelNode());
            this.stmt_ = (StatementBase)parsedStmt.getTopLevelNode();
            this.stmtTableCache_ = stmtTableCache;
            this.authzCtx_ = authzCtx;
            this.analyzer_ = AnalysisDriverImpl.createAnalyzer(this.ctx_, stmtTableCache, authzCtx);
        }

        @Override
        public AnalysisResult analyze() {
            try {
                this.stmt_.analyze(this.analyzer_);
                this.analyzer_.checkStmtExprLimit();
                ArrayList<Type> origResultTypes = new ArrayList<Type>();
                for (Expr e : this.stmt_.getResultExprs()) {
                    origResultTypes.add(e.getType());
                }
                ArrayList origColLabels = Lists.newArrayList(this.stmt_.getColLabels());
                boolean shouldReAnalyze = false;
                if (this.ctx_.getAuthzFactory().getAuthorizationConfig().isEnabled()) {
                    shouldReAnalyze = this.stmt_.resolveTableMask(this.analyzer_);
                    if (shouldReAnalyze) {
                        this.reAnalyze(this.stmtTableCache_, this.authzCtx_, origResultTypes, origColLabels, true);
                    }
                    shouldReAnalyze = false;
                }
                ExprRewriter rewriter = this.analyzer_.getExprRewriter();
                if (this.requiresExprRewrite()) {
                    rewriter.reset();
                    this.stmt_.rewriteExprs(rewriter);
                    shouldReAnalyze = rewriter.changed();
                }
                if (this.requiresSubqueryRewrite()) {
                    new StmtRewriter.SubqueryRewriter().rewrite(this.stmt_);
                    shouldReAnalyze = true;
                }
                if (this.requiresSetOperationRewrite()) {
                    new StmtRewriter().rewrite(this.stmt_);
                    shouldReAnalyze = true;
                }
                if (this.requiresAcidComplexScanRewrite()) {
                    new StmtRewriter.AcidRewriter().rewrite(this.stmt_);
                    shouldReAnalyze = true;
                }
                if (this.requiresZippingUnnestRewrite()) {
                    new StmtRewriter.ZippingUnnestRewriter().rewrite(this.stmt_);
                    shouldReAnalyze = true;
                }
                if (!shouldReAnalyze) {
                    return new AnalysisResult(this.parsedStmt_, this.analyzer_);
                }
                if (this.requiresSetOperationRewrite() && this.stmt_ instanceof SetOperationStmt && ((SetOperationStmt)this.stmt_).hasRewrittenStmt()) {
                    boolean isExplain = this.stmt_.isExplain();
                    this.stmt_ = ((SetOperationStmt)this.stmt_).getRewrittenStmt();
                    this.parsedStmt_ = new ParsedStatementImpl(this.stmt_);
                    if (isExplain) {
                        this.stmt_.setIsExplain();
                    }
                }
                this.reAnalyze(this.stmtTableCache_, this.authzCtx_, origResultTypes, origColLabels, false);
                Preconditions.checkState((!this.requiresSubqueryRewrite() ? 1 : 0) != 0);
                return new AnalysisResult(this.parsedStmt_, this.analyzer_);
            }
            catch (ImpalaException e) {
                return new AnalysisResult(this.parsedStmt_, this.analyzer_, e);
            }
        }

        private void reAnalyze(StmtMetadataLoader.StmtTableCache stmtTableCache, AuthorizationContext authzCtx, List<Type> origResultTypes, List<String> origColLabels, boolean collectPrivileges) throws AnalysisException {
            boolean isExplain = this.stmt_.isExplain();
            ImmutableList<PrivilegeRequest> origPrivReqs = this.analyzer_.getPrivilegeReqs();
            this.analyzer_ = AnalysisDriverImpl.createAnalyzer(this.ctx_, stmtTableCache, authzCtx);
            for (PrivilegeRequest req : origPrivReqs) {
                this.analyzer_.registerPrivReq(req);
            }
            this.analyzer_.setEnablePrivChecks(collectPrivileges);
            this.stmt_.reset();
            try {
                this.stmt_.analyze(this.analyzer_);
                this.analyzer_.setEnablePrivChecks(true);
            }
            catch (AnalysisException e) {
                this.logRewriteErrorNoThrow(this.stmt_, e);
                throw new AnalysisException("An error occurred after query rewrite: " + e.getMessage(), e);
            }
            this.stmt_.castResultExprs(origResultTypes);
            this.stmt_.setColLabels(origColLabels);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Rewritten SQL: " + this.stmt_.toSql(ToSqlOptions.REWRITTEN));
            }
            if (isExplain) {
                this.stmt_.setIsExplain();
            }
        }

        private void logRewriteErrorNoThrow(StatementBase stmt, AnalysisException analysisException) {
            try {
                LOG.error(String.format("Error analyzing the rewritten query.\nOriginal SQL: %s\nRewritten SQL: %s", stmt.toSql(), stmt.toSql(ToSqlOptions.REWRITTEN)), (Throwable)analysisException);
            }
            catch (Exception e) {
                LOG.error("An exception occurred during printing out the rewritten SQL statement.", (Throwable)e);
            }
        }

        public boolean canRewriteStatement() {
            return !this.isCreateViewStmt() && !this.isAlterViewStmt() && !this.isShowCreateTableStmt();
        }

        public boolean requiresSubqueryRewrite() {
            return this.canRewriteStatement() && this.analyzer_.containsSubquery();
        }

        public boolean requiresAcidComplexScanRewrite() {
            return this.canRewriteStatement() && this.analyzer_.hasTopLevelAcidCollectionTableRef();
        }

        public boolean requiresZippingUnnestRewrite() {
            return this.canRewriteStatement() && this.isZippingUnnestInSelectList(this.stmt_);
        }

        public boolean requiresExprRewrite() {
            return this.isQueryStmt() || this.isInsertStmt() || this.isCreateTableAsSelectStmt() || this.isUpdateStmt() || this.isDeleteStmt() || this.isOptimizeStmt() || this.isMergeStmt();
        }

        public boolean requiresSetOperationRewrite() {
            return this.analyzer_.containsSetOperation() && this.canRewriteStatement();
        }

        public boolean isCreateViewStmt() {
            return this.stmt_ instanceof CreateViewStmt;
        }

        public boolean isAlterViewStmt() {
            return this.stmt_ instanceof AlterViewStmt;
        }

        public boolean isShowCreateTableStmt() {
            return this.stmt_ instanceof ShowCreateTableStmt;
        }

        public boolean isQueryStmt() {
            return this.stmt_ instanceof QueryStmt;
        }

        public boolean isInsertStmt() {
            return this.stmt_ instanceof InsertStmt;
        }

        public boolean isMergeStmt() {
            return this.stmt_ instanceof MergeStmt;
        }

        public boolean isDeleteStmt() {
            return this.stmt_ instanceof DeleteStmt;
        }

        public boolean isOptimizeStmt() {
            return this.stmt_ instanceof OptimizeStmt;
        }

        public boolean isUpdateStmt() {
            return this.stmt_ instanceof UpdateStmt;
        }

        public boolean isCreateTableAsSelectStmt() {
            return this.stmt_ instanceof CreateTableAsSelectStmt;
        }

        private boolean isZippingUnnestInSelectList(StatementBase stmt) {
            if (!(stmt instanceof SelectStmt)) {
                return false;
            }
            if (!stmt.analyzer_.getTableRefsFromUnnestExpr().isEmpty()) {
                return true;
            }
            SelectStmt selectStmt = (SelectStmt)stmt;
            for (TableRef tblRef : selectStmt.fromClause_.getTableRefs()) {
                if (!(tblRef instanceof InlineViewRef) || !this.isZippingUnnestInSelectList(((InlineViewRef)tblRef).getViewStmt())) continue;
                return true;
            }
            return false;
        }

        public static Analyzer createAnalyzer(AnalysisContext ctx, StmtMetadataLoader.StmtTableCache stmtTableCache) {
            return AnalysisDriverImpl.createAnalyzer(ctx, stmtTableCache, null);
        }

        private static Analyzer createAnalyzer(AnalysisContext ctx, StmtMetadataLoader.StmtTableCache stmtTableCache, AuthorizationContext authzCtx) {
            Analyzer result = new Analyzer(stmtTableCache, ctx.getQueryCtx(), ctx.getAuthzFactory(), authzCtx);
            result.setUseHiveColLabels(ctx.getUseHiveColLabels());
            return result;
        }
    }

    public static class AnalysisResult {
        private final ParsedStatement parsedStmt_;
        private final StatementBase stmt_;
        private final Analyzer analyzer_;
        private final ImpalaException exception_;
        private boolean userHasProfileAccess_ = true;

        public AnalysisResult(ParsedStatement parsedStmt, Analyzer analyzer) {
            this(parsedStmt, analyzer, null);
        }

        public AnalysisResult(ParsedStatement parsedStmt, Analyzer analyzer, ImpalaException e) {
            this.parsedStmt_ = parsedStmt;
            this.stmt_ = this.parsedStmt_.getTopLevelNode() instanceof StatementBase ? (StatementBase)this.parsedStmt_.getTopLevelNode() : null;
            this.analyzer_ = analyzer;
            this.exception_ = e;
        }

        public boolean isAlterTableStmt() {
            return this.stmt_ instanceof AlterTableStmt;
        }

        public boolean isAlterViewStmt() {
            return this.stmt_ instanceof AlterViewStmt;
        }

        public boolean isComputeStatsStmt() {
            return this.stmt_ instanceof ComputeStatsStmt;
        }

        public boolean isQueryStmt() {
            return this.parsedStmt_.isQueryStmt();
        }

        public boolean isSetOperationStmt() {
            return this.stmt_ instanceof SetOperationStmt;
        }

        public boolean isInsertStmt() {
            return this.stmt_ instanceof InsertStmt;
        }

        public boolean isMergeStmt() {
            return this.stmt_ instanceof MergeStmt;
        }

        public boolean isOptimizeStmt() {
            return this.stmt_ instanceof OptimizeStmt;
        }

        public boolean isDropDbStmt() {
            return this.stmt_ instanceof DropDbStmt;
        }

        public boolean isDropTableOrViewStmt() {
            return this.stmt_ instanceof DropTableOrViewStmt;
        }

        public boolean isDropFunctionStmt() {
            return this.stmt_ instanceof DropFunctionStmt;
        }

        public boolean isDropDataSrcStmt() {
            return this.stmt_ instanceof DropDataSrcStmt;
        }

        public boolean isDropStatsStmt() {
            return this.stmt_ instanceof DropStatsStmt;
        }

        public boolean isCreateTableLikeStmt() {
            return this.stmt_ instanceof CreateTableLikeStmt;
        }

        public boolean isCreateViewStmt() {
            return this.stmt_ instanceof CreateViewStmt;
        }

        public boolean isCreateTableAsSelectStmt() {
            return this.stmt_ instanceof CreateTableAsSelectStmt;
        }

        public boolean isCreateTableStmt() {
            return this.stmt_ instanceof CreateTableStmt;
        }

        public boolean isCreateDbStmt() {
            return this.stmt_ instanceof CreateDbStmt;
        }

        public boolean isCreateUdfStmt() {
            return this.stmt_ instanceof CreateUdfStmt;
        }

        public boolean isCreateUdaStmt() {
            return this.stmt_ instanceof CreateUdaStmt;
        }

        public boolean isCreateDataSrcStmt() {
            return this.stmt_ instanceof CreateDataSrcStmt;
        }

        public boolean isLoadDataStmt() {
            return this.stmt_ instanceof LoadDataStmt;
        }

        public boolean isUseStmt() {
            return this.stmt_ instanceof UseStmt;
        }

        public boolean isSetStmt() {
            return this.stmt_ instanceof SetStmt;
        }

        public boolean isShowTablesStmt() {
            return this.stmt_ instanceof ShowTablesStmt;
        }

        public boolean isShowMetadataTablesStmt() {
            return this.stmt_ instanceof ShowMetadataTablesStmt;
        }

        public boolean isShowViewsStmt() {
            return this.stmt_ instanceof ShowViewsStmt;
        }

        public boolean isDescribeHistoryStmt() {
            return this.stmt_ instanceof DescribeHistoryStmt;
        }

        public boolean isShowDbsStmt() {
            return this.stmt_ instanceof ShowDbsStmt;
        }

        public boolean isShowDataSrcsStmt() {
            return this.stmt_ instanceof ShowDataSrcsStmt;
        }

        public boolean isShowStatsStmt() {
            return this.stmt_ instanceof ShowStatsStmt;
        }

        public boolean isShowFunctionsStmt() {
            return this.stmt_ instanceof ShowFunctionsStmt;
        }

        public boolean isShowCreateTableStmt() {
            return this.stmt_ instanceof ShowCreateTableStmt;
        }

        public boolean isShowCreateFunctionStmt() {
            return this.stmt_ instanceof ShowCreateFunctionStmt;
        }

        public boolean isShowFilesStmt() {
            return this.stmt_ instanceof ShowFilesStmt;
        }

        public boolean isAdminFnStmt() {
            return this.stmt_ instanceof AdminFnStmt;
        }

        public boolean isDescribeDbStmt() {
            return this.stmt_ instanceof DescribeDbStmt;
        }

        public boolean isDescribeTableStmt() {
            return this.stmt_ instanceof DescribeTableStmt;
        }

        public boolean isResetMetadataStmt() {
            return this.stmt_ instanceof ResetMetadataStmt;
        }

        public boolean isExplainStmt() {
            return this.parsedStmt_.isExplain();
        }

        public boolean isShowRolesStmt() {
            return this.stmt_ instanceof ShowRolesStmt;
        }

        public boolean isShowGrantPrincipalStmt() {
            return this.stmt_ instanceof ShowGrantPrincipalStmt;
        }

        public boolean isCreateDropRoleStmt() {
            return this.stmt_ instanceof CreateDropRoleStmt;
        }

        public boolean isGrantRevokeRoleStmt() {
            return this.stmt_ instanceof GrantRevokeRoleStmt;
        }

        public boolean isGrantRevokePrivStmt() {
            return this.stmt_ instanceof GrantRevokePrivStmt;
        }

        public boolean isTruncateStmt() {
            return this.stmt_ instanceof TruncateStmt;
        }

        public boolean isUpdateStmt() {
            return this.stmt_ instanceof UpdateStmt;
        }

        public UpdateStmt getUpdateStmt() {
            return (UpdateStmt)this.stmt_;
        }

        public boolean isDeleteStmt() {
            return this.stmt_ instanceof DeleteStmt;
        }

        public DeleteStmt getDeleteStmt() {
            return (DeleteStmt)this.stmt_;
        }

        public boolean isCommentOnStmt() {
            return this.stmt_ instanceof CommentOnStmt;
        }

        public boolean isAlterDbStmt() {
            return this.stmt_ instanceof AlterDbStmt;
        }

        public boolean isCatalogOp() {
            return this.isUseStmt() || this.isViewMetadataStmt() || this.isDdlStmt();
        }

        public boolean isTestCaseStmt() {
            return this.stmt_ instanceof CopyTestCaseStmt;
        }

        private boolean isDdlStmt() {
            return this.isCreateTableLikeStmt() || this.isCreateTableStmt() || this.isCreateViewStmt() || this.isCreateDbStmt() || this.isDropDbStmt() || this.isDropTableOrViewStmt() || this.isResetMetadataStmt() || this.isAlterTableStmt() || this.isAlterViewStmt() || this.isComputeStatsStmt() || this.isCreateUdfStmt() || this.isCreateUdaStmt() || this.isDropFunctionStmt() || this.isCreateTableAsSelectStmt() || this.isCreateDataSrcStmt() || this.isDropDataSrcStmt() || this.isDropStatsStmt() || this.isCreateDropRoleStmt() || this.isGrantRevokeStmt() || this.isTruncateStmt() || this.isCommentOnStmt() || this.isAlterDbStmt();
        }

        private boolean isViewMetadataStmt() {
            return this.isShowFilesStmt() || this.isShowTablesStmt() || this.isShowMetadataTablesStmt() || this.isShowViewsStmt() || this.isShowDbsStmt() || this.isShowFunctionsStmt() || this.isShowRolesStmt() || this.isShowGrantPrincipalStmt() || this.isShowCreateTableStmt() || this.isShowDataSrcsStmt() || this.isShowStatsStmt() || this.isDescribeTableStmt() || this.isDescribeDbStmt() || this.isShowCreateFunctionStmt() || this.isDescribeHistoryStmt();
        }

        private boolean isGrantRevokeStmt() {
            return this.isGrantRevokeRoleStmt() || this.isGrantRevokePrivStmt();
        }

        public boolean isDmlStmt() {
            return this.isInsertStmt() || this.isUpdateStmt() || this.isDeleteStmt() || this.isOptimizeStmt() || this.isMergeStmt();
        }

        public boolean isHierarchicalAuthStmt() {
            return this.isQueryStmt() || this.isInsertStmt() || this.isUpdateStmt() || this.isDeleteStmt() || this.isCreateTableAsSelectStmt() || this.isCreateViewStmt() || this.isAlterViewStmt() || this.isOptimizeStmt() || this.isTestCaseStmt() || this.isMergeStmt();
        }

        public boolean isSingleColumnPrivStmt() {
            return this.isDescribeTableStmt() || this.isResetMetadataStmt() || this.isUseStmt() || this.isShowTablesStmt() || this.isShowMetadataTablesStmt() || this.isShowViewsStmt() || this.isAlterTableStmt() || this.isShowFunctionsStmt();
        }

        public boolean isConvertTableToIcebergStmt() {
            return this.stmt_ instanceof ConvertTableToIcebergStmt;
        }

        public boolean isKillQueryStmt() {
            return this.stmt_ instanceof KillQueryStmt;
        }

        public AlterTableStmt getAlterTableStmt() {
            Preconditions.checkState((boolean)this.isAlterTableStmt());
            return (AlterTableStmt)this.stmt_;
        }

        public AlterViewStmt getAlterViewStmt() {
            Preconditions.checkState((boolean)this.isAlterViewStmt());
            return (AlterViewStmt)this.stmt_;
        }

        public ComputeStatsStmt getComputeStatsStmt() {
            Preconditions.checkState((boolean)this.isComputeStatsStmt());
            return (ComputeStatsStmt)this.stmt_;
        }

        public CreateTableLikeStmt getCreateTableLikeStmt() {
            Preconditions.checkState((boolean)this.isCreateTableLikeStmt());
            return (CreateTableLikeStmt)this.stmt_;
        }

        public CreateViewStmt getCreateViewStmt() {
            Preconditions.checkState((boolean)this.isCreateViewStmt());
            return (CreateViewStmt)this.stmt_;
        }

        public CreateTableAsSelectStmt getCreateTableAsSelectStmt() {
            Preconditions.checkState((boolean)this.isCreateTableAsSelectStmt());
            return (CreateTableAsSelectStmt)this.stmt_;
        }

        public CreateTableStmt getCreateTableStmt() {
            Preconditions.checkState((boolean)this.isCreateTableStmt());
            return (CreateTableStmt)this.stmt_;
        }

        public CreateDbStmt getCreateDbStmt() {
            Preconditions.checkState((boolean)this.isCreateDbStmt());
            return (CreateDbStmt)this.stmt_;
        }

        public CreateUdfStmt getCreateUdfStmt() {
            Preconditions.checkState((boolean)this.isCreateUdfStmt());
            return (CreateUdfStmt)this.stmt_;
        }

        public CreateUdaStmt getCreateUdaStmt() {
            Preconditions.checkState((boolean)this.isCreateUdfStmt());
            return (CreateUdaStmt)this.stmt_;
        }

        public DropDbStmt getDropDbStmt() {
            Preconditions.checkState((boolean)this.isDropDbStmt());
            return (DropDbStmt)this.stmt_;
        }

        public DropTableOrViewStmt getDropTableOrViewStmt() {
            Preconditions.checkState((boolean)this.isDropTableOrViewStmt());
            return (DropTableOrViewStmt)this.stmt_;
        }

        public TruncateStmt getTruncateStmt() {
            Preconditions.checkState((boolean)this.isTruncateStmt());
            return (TruncateStmt)this.stmt_;
        }

        public DropFunctionStmt getDropFunctionStmt() {
            Preconditions.checkState((boolean)this.isDropFunctionStmt());
            return (DropFunctionStmt)this.stmt_;
        }

        public LoadDataStmt getLoadDataStmt() {
            Preconditions.checkState((boolean)this.isLoadDataStmt());
            return (LoadDataStmt)this.stmt_;
        }

        public QueryStmt getQueryStmt() {
            Preconditions.checkState((boolean)this.isQueryStmt());
            return (QueryStmt)this.stmt_;
        }

        public OptimizeStmt getOptimizeStmt() {
            Preconditions.checkState((boolean)this.isOptimizeStmt());
            return (OptimizeStmt)this.stmt_;
        }

        public MergeStmt getMergeStmt() {
            Preconditions.checkState((boolean)this.isMergeStmt());
            return (MergeStmt)this.stmt_;
        }

        public InsertStmt getInsertStmt() {
            if (this.isCreateTableAsSelectStmt()) {
                return this.getCreateTableAsSelectStmt().getInsertStmt();
            }
            Preconditions.checkState((boolean)this.isInsertStmt());
            return (InsertStmt)this.stmt_;
        }

        public UseStmt getUseStmt() {
            Preconditions.checkState((boolean)this.isUseStmt());
            return (UseStmt)this.stmt_;
        }

        public SetStmt getSetStmt() {
            Preconditions.checkState((boolean)this.isSetStmt());
            return (SetStmt)this.stmt_;
        }

        public ShowTablesStmt getShowTablesStmt() {
            Preconditions.checkState((boolean)this.isShowTablesStmt());
            return (ShowTablesStmt)this.stmt_;
        }

        public ShowMetadataTablesStmt getShowMetadataTablesStmt() {
            Preconditions.checkState((boolean)this.isShowMetadataTablesStmt());
            return (ShowMetadataTablesStmt)this.stmt_;
        }

        public ShowViewsStmt getShowViewsStmt() {
            Preconditions.checkState((boolean)this.isShowViewsStmt());
            return (ShowViewsStmt)this.stmt_;
        }

        public ShowDbsStmt getShowDbsStmt() {
            Preconditions.checkState((boolean)this.isShowDbsStmt());
            return (ShowDbsStmt)this.stmt_;
        }

        public ShowDataSrcsStmt getShowDataSrcsStmt() {
            Preconditions.checkState((boolean)this.isShowDataSrcsStmt());
            return (ShowDataSrcsStmt)this.stmt_;
        }

        public ShowStatsStmt getShowStatsStmt() {
            Preconditions.checkState((boolean)this.isShowStatsStmt());
            return (ShowStatsStmt)this.stmt_;
        }

        public ShowFunctionsStmt getShowFunctionsStmt() {
            Preconditions.checkState((boolean)this.isShowFunctionsStmt());
            return (ShowFunctionsStmt)this.stmt_;
        }

        public ShowFilesStmt getShowFilesStmt() {
            Preconditions.checkState((boolean)this.isShowFilesStmt());
            return (ShowFilesStmt)this.stmt_;
        }

        public DescribeHistoryStmt getDescribeHistoryStmt() {
            Preconditions.checkState((boolean)this.isDescribeHistoryStmt());
            return (DescribeHistoryStmt)this.stmt_;
        }

        public DescribeDbStmt getDescribeDbStmt() {
            Preconditions.checkState((boolean)this.isDescribeDbStmt());
            return (DescribeDbStmt)this.stmt_;
        }

        public DescribeTableStmt getDescribeTableStmt() {
            Preconditions.checkState((boolean)this.isDescribeTableStmt());
            return (DescribeTableStmt)this.stmt_;
        }

        public ShowCreateTableStmt getShowCreateTableStmt() {
            Preconditions.checkState((boolean)this.isShowCreateTableStmt());
            return (ShowCreateTableStmt)this.stmt_;
        }

        public ShowCreateFunctionStmt getShowCreateFunctionStmt() {
            Preconditions.checkState((boolean)this.isShowCreateFunctionStmt());
            return (ShowCreateFunctionStmt)this.stmt_;
        }

        public CommentOnStmt getCommentOnStmt() {
            Preconditions.checkState((boolean)this.isCommentOnStmt());
            return (CommentOnStmt)this.stmt_;
        }

        public AlterDbStmt getAlterDbStmt() {
            Preconditions.checkState((boolean)this.isAlterDbStmt());
            return (AlterDbStmt)this.stmt_;
        }

        public AdminFnStmt getAdminFnStmt() {
            Preconditions.checkState((boolean)this.isAdminFnStmt());
            return (AdminFnStmt)this.stmt_;
        }

        public ConvertTableToIcebergStmt getConvertTableToIcebergStmt() {
            Preconditions.checkState((boolean)this.isConvertTableToIcebergStmt());
            return (ConvertTableToIcebergStmt)this.stmt_;
        }

        public KillQueryStmt getKillQueryStmt() {
            Preconditions.checkState((boolean)this.isKillQueryStmt());
            return (KillQueryStmt)this.stmt_;
        }

        public ParsedStatement getParsedStmt() {
            return this.parsedStmt_;
        }

        public StatementBase getStmt() {
            return this.stmt_;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer_;
        }

        public ImpalaException getException() {
            return this.exception_;
        }

        public Set<TAccessEvent> getAccessEvents() {
            return this.analyzer_.getAccessEvents();
        }

        public TLineageGraph getThriftLineageGraph() {
            return this.analyzer_.getThriftSerializedLineageGraph();
        }

        public void setUserHasProfileAccess(boolean value) {
            this.userHasProfileAccess_ = value;
        }

        public boolean userHasProfileAccess() {
            return this.userHasProfileAccess_;
        }
    }
}

