/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.CreateOrAlterViewStmtBase;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TAccessEvent;
import org.apache.impala.thrift.TCatalogObjectType;

public class AlterViewStmt
extends CreateOrAlterViewStmtBase {
    public AlterViewStmt(TableName tableName, List<ColumnDef> columnDefs, QueryStmt viewDefStmt) {
        super(false, tableName, columnDefs, null, null, viewDefStmt);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        analyzer.setUseHiveColLabels(true);
        this.viewDefStmt_.analyze(analyzer);
        Preconditions.checkState((this.tableName_ != null && !this.tableName_.isEmpty() ? 1 : 0) != 0);
        this.dbName_ = analyzer.getTargetDbName(this.tableName_);
        this.owner_ = analyzer.getUserShortName();
        this.serverName_ = analyzer.getServerName();
        FeTable table = analyzer.getTable(this.tableName_, Privilege.ALTER);
        Preconditions.checkNotNull((Object)table);
        if (!(table instanceof FeView)) {
            throw new AnalysisException(String.format("ALTER VIEW not allowed on a table: %s.%s", this.dbName_, this.getTbl()));
        }
        analyzer.addAccessEvent(new TAccessEvent(this.dbName_ + "." + this.tableName_.getTbl(), TCatalogObjectType.VIEW, Privilege.ALTER.toString()));
        HashSet<FeView> inlineViews = new HashSet<FeView>();
        this.viewDefStmt_.collectInlineViews(inlineViews);
        TableRef tblRef = analyzer.resolveTableRef(new TableRef(this.tableName_.toPath(), null));
        if (inlineViews.contains(((InlineViewRef)tblRef).getView())) {
            throw new AnalysisException(String.format("Self-reference not allowed on view: %s", tblRef.toSql()));
        }
        this.createColumnAndViewDefs(analyzer);
        if (BackendConfig.INSTANCE.getComputeLineage() || RuntimeEnv.INSTANCE.isTestEnv()) {
            this.computeLineageGraph(analyzer);
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER VIEW ");
        if (this.tableName_.getDb() != null) {
            sb.append(this.tableName_.getDb() + ".");
        }
        sb.append(this.tableName_.getTbl());
        if (this.columnDefs_ != null) {
            sb.append("(" + this.getColumnNames() + ")");
        }
        sb.append(" AS " + this.viewDefStmt_.toSql(options));
        return sb.toString();
    }
}

