/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.PartitionSet;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.DataSourceTable;
import org.apache.impala.catalog.FeDataSourceTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.KuduTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.TAlterTableUnSetTblPropertiesParams;
import org.apache.impala.thrift.TTablePropertyType;
import org.apache.impala.util.MetaStoreUtil;

public class AlterTableUnSetTblProperties
extends AlterTableStmt {
    private final PartitionSet partitionSet_;
    private final TTablePropertyType targetProperty_;
    private final List<String> tblPropertyKeys_;
    private final boolean ifExists_;

    public AlterTableUnSetTblProperties(TableName tableName, PartitionSet partitionSet, boolean ifExist, TTablePropertyType targetProperty, List<String> tblPropertyKeys) {
        super(tableName);
        Preconditions.checkNotNull(tblPropertyKeys);
        Preconditions.checkNotNull((Object)((Object)targetProperty));
        this.targetProperty_ = targetProperty;
        this.tblPropertyKeys_ = tblPropertyKeys;
        this.partitionSet_ = partitionSet;
        this.ifExists_ = ifExist;
    }

    public List<String> getTblPropertyKeys() {
        return this.tblPropertyKeys_;
    }

    @Override
    public String getOperation() {
        return this.targetProperty_ == TTablePropertyType.TBL_PROPERTY ? "UNSET TBLPROPERTIES" : "UNSET SERDEPROPERTIES";
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.UNSET_TBL_PROPERTIES);
        TAlterTableUnSetTblPropertiesParams tblUnsetPropertyParams = new TAlterTableUnSetTblPropertiesParams();
        tblUnsetPropertyParams.setTarget(this.targetProperty_);
        tblUnsetPropertyParams.setProperty_keys(this.tblPropertyKeys_);
        if (this.partitionSet_ != null) {
            tblUnsetPropertyParams.setPartition_set(this.partitionSet_.toThrift());
        }
        tblUnsetPropertyParams.setIf_exists(this.ifExists_);
        params.setUnset_tbl_properties_params(tblUnsetPropertyParams);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        for (String property : this.tblPropertyKeys_) {
            MetaStoreUtil.checkShortProperty("Property key", property, 256);
        }
        if (this.tblPropertyKeys_.contains("storage_handler")) {
            throw new AnalysisException(String.format("Changing the '%s' table property is not supported to protect against metadata corruption.", "storage_handler"));
        }
        if (this.getTargetTable() instanceof FeKuduTable) {
            this.analyzeKuduTable(analyzer);
        } else if (this.getTargetTable() instanceof FeIcebergTable) {
            this.analyzeIcebergTable(analyzer);
        } else if (this.getTargetTable() instanceof FeDataSourceTable) {
            this.analyzeDataSourceTable(analyzer);
        }
        this.propertyCheck(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName(), "Avro");
        this.propertyCheck(AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName(), "Avro");
    }

    private void analyzeKuduTable(Analyzer analyzer) throws AnalysisException {
        if (KuduTable.isSynchronizedTable(this.table_.getMetaStoreTable())) {
            this.propertyCheck("kudu.table_name", "synchronized Kudu");
        }
        this.propertyCheck("kudu.table_id", "Kudu");
        this.propertyCheck("kudu.master_addresses", "Kudu");
    }

    private void analyzeIcebergTable(Analyzer analyzer) throws AnalysisException {
        this.propertyCheck("iceberg.catalog", "Iceberg");
        this.propertyCheck("iceberg.catalog_location", "Iceberg");
        this.propertyCheck("iceberg.table_identifier", "Iceberg");
        this.propertyCheck("metadata_location", "Iceberg");
    }

    private void analyzeDataSourceTable(Analyzer analyzer) throws AnalysisException {
        if (this.partitionSet_ != null) {
            throw new AnalysisException("Partition is not supported for DataSource table.");
        }
        if (this.targetProperty_ == TTablePropertyType.SERDE_PROPERTY) {
            throw new AnalysisException("ALTER TABLE UNSET SERDEPROPERTIES is not supported for DataSource table.");
        }
        this.propertyCheck("__IMPALA_DATA_SOURCE_NAME", "DataSource");
        this.propertyCheck("__IMPALA_DATA_SOURCE_INIT_STRING", "DataSource");
        this.propertyCheck("__IMPALA_DATA_SOURCE_LOCATION", "DataSource");
        this.propertyCheck("__IMPALA_DATA_SOURCE_CLASS", "DataSource");
        this.propertyCheck("__IMPALA_DATA_SOURCE_API_VERSION", "DataSource");
        for (String property : this.tblPropertyKeys_) {
            if (!DataSourceTable.isRequiredJdbcParameter(property)) continue;
            throw new AnalysisException(String.format("Unsetting the '%s' table property is not supported for JDBC DataSource table.", property));
        }
    }

    private void propertyCheck(String property, String tableType) throws AnalysisException {
        if (this.tblPropertyKeys_.contains(property)) {
            throw new AnalysisException(String.format("Unsetting the '%s' table property is not supported for %s table.", property, tableType));
        }
    }
}

