/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.avro.SchemaParseException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.impala.analysis.AlterTableSetStmt;
import org.apache.impala.analysis.AnalysisUtils;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CreateTableStmt;
import org.apache.impala.analysis.PartitionSet;
import org.apache.impala.analysis.TableDef;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.catalog.FeDataSourceTable;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsStorageDescriptor;
import org.apache.impala.catalog.KuduTable;
import org.apache.impala.catalog.local.LocalCatalogException;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableSetTblPropertiesParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.thrift.TTablePropertyType;
import org.apache.impala.util.AvroSchemaParser;
import org.apache.impala.util.AvroSchemaUtils;
import org.apache.impala.util.IcebergUtil;
import org.apache.impala.util.MetaStoreUtil;

public class AlterTableSetTblProperties
extends AlterTableSetStmt {
    private final TTablePropertyType targetProperty_;
    private final Map<String, String> tblProperties_;

    public AlterTableSetTblProperties(TableName tableName, PartitionSet partitionSet, TTablePropertyType targetProperty, Map<String, String> tblProperties) {
        super(tableName, partitionSet);
        Preconditions.checkNotNull(tblProperties);
        Preconditions.checkNotNull((Object)((Object)targetProperty));
        this.targetProperty_ = targetProperty;
        this.tblProperties_ = tblProperties;
        CreateTableStmt.unescapeProperties(this.tblProperties_);
    }

    public Map<String, String> getTblProperties() {
        return this.tblProperties_;
    }

    @Override
    public String getOperation() {
        return this.targetProperty_ == TTablePropertyType.TBL_PROPERTY ? "SET TBLPROPERTIES" : "SET SERDEPROPERTIES";
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.SET_TBL_PROPERTIES);
        TAlterTableSetTblPropertiesParams tblPropertyParams = new TAlterTableSetTblPropertiesParams();
        tblPropertyParams.setTarget(this.targetProperty_);
        tblPropertyParams.setProperties(this.tblProperties_);
        if (this.partitionSet_ != null) {
            tblPropertyParams.setPartition_set(this.partitionSet_.toThrift());
        }
        params.setSet_tbl_properties_params(tblPropertyParams);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        MetaStoreUtil.checkShortPropertyMap("Property", this.tblProperties_);
        if (this.tblProperties_.containsKey("storage_handler")) {
            throw new AnalysisException(String.format("Changing the '%s' table property is not supported to protect against metadata corruption.", "storage_handler"));
        }
        if (this.getTargetTable() instanceof FeKuduTable) {
            this.analyzeKuduTable(analyzer);
        } else if (this.getTargetTable() instanceof FeIcebergTable) {
            this.analyzeIcebergTable(analyzer);
        } else if (this.getTargetTable() instanceof FeDataSourceTable) {
            this.analyzeDataSourceTable(analyzer);
        }
        if (this.tblProperties_.containsKey(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName()) || this.tblProperties_.containsKey(AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName())) {
            this.analyzeAvroSchema(analyzer);
        }
        AlterTableSetTblProperties.analyzeSkipHeaderLineCount(this.getTargetTable(), this.tblProperties_);
        AlterTableSetTblProperties.analyzeSortColumns(this.getTargetTable(), this.tblProperties_);
        this.analyzeSerializationEncoding(this.tblProperties_);
    }

    private void analyzeKuduTable(Analyzer analyzer) throws AnalysisException {
        String keyForExternalProperty;
        if (KuduTable.isSynchronizedTable(this.table_.getMetaStoreTable())) {
            AnalysisUtils.throwIfNotNull(this.tblProperties_.get("kudu.table_name"), String.format("Not allowed to set '%s' manually for synchronized Kudu tables .", "kudu.table_name"));
        }
        AnalysisUtils.throwIfNotNull(this.tblProperties_.get("kudu.table_id"), String.format("Property '%s' cannot be altered for Kudu tables", "kudu.table_id"));
        AuthorizationConfig authzConfig = analyzer.getAuthzConfig();
        if (authzConfig.isEnabled() && ((keyForExternalProperty = MetaStoreUtil.findTblPropKeyCaseInsensitive(this.tblProperties_, "EXTERNAL")) != null || this.tblProperties_.containsKey("kudu.master_addresses"))) {
            String authzServer = authzConfig.getServerName();
            Preconditions.checkNotNull((Object)authzServer);
            analyzer.registerPrivReq(builder -> builder.onServer(authzServer).all().build());
        }
    }

    private void analyzeIcebergTable(Analyzer analyzer) throws AnalysisException {
        this.icebergPropertyCheck("iceberg.catalog");
        this.icebergPropertyCheck("iceberg.catalog_location");
        this.icebergPropertyCheck("iceberg.table_identifier");
        this.icebergPropertyCheck("name");
        this.icebergPropertyCheck("iceberg.mr.table.identifier");
        this.icebergPropertyCheck("metadata_location");
        if (this.tblProperties_.containsKey("write.format.default")) {
            this.icebergTableFormatCheck(this.tblProperties_.get("write.format.default"));
        }
        this.icebergParquetCompressionCodecCheck();
        this.icebergParquetRowGroupSizeCheck();
        this.icebergParquetPageSizeCheck("write.parquet.page-size-bytes", "page size");
        this.icebergParquetPageSizeCheck("write.parquet.dict-size-bytes", "dictionary page size");
    }

    private void icebergPropertyCheck(String property) throws AnalysisException {
        if (this.tblProperties_.containsKey(property)) {
            throw new AnalysisException(String.format("Changing the '%s' table property is not supported for Iceberg table.", property));
        }
    }

    private void icebergTableFormatCheck(String fileformat) throws AnalysisException {
        Preconditions.checkState((boolean)(this.getTargetTable() instanceof FeIcebergTable));
        Preconditions.checkState((fileformat != null ? 1 : 0) != 0);
        if (IcebergUtil.getIcebergFileFormat(fileformat) == null) {
            throw new AnalysisException("Invalid fileformat for Iceberg table: " + fileformat);
        }
    }

    private void icebergParquetCompressionCodecCheck() throws AnalysisException {
        StringBuilder errMsg = new StringBuilder();
        if (IcebergUtil.parseParquetCompressionCodec(false, this.tblProperties_, errMsg) == null) {
            throw new AnalysisException(errMsg.toString());
        }
    }

    private void icebergParquetRowGroupSizeCheck() throws AnalysisException {
        StringBuilder errMsg = new StringBuilder();
        if (IcebergUtil.parseParquetRowGroupSize(this.tblProperties_, errMsg) == null) {
            throw new AnalysisException(errMsg.toString());
        }
    }

    private void icebergParquetPageSizeCheck(String property, String descr) throws AnalysisException {
        StringBuilder errMsg = new StringBuilder();
        if (IcebergUtil.parseParquetPageSize(this.getTblProperties(), property, descr, errMsg) == null) {
            throw new AnalysisException(errMsg.toString());
        }
    }

    private void analyzeDataSourceTable(Analyzer analyzer) throws AnalysisException {
        if (this.partitionSet_ != null) {
            throw new AnalysisException("Partition is not supported for DataSource table.");
        }
        if (this.targetProperty_ == TTablePropertyType.SERDE_PROPERTY) {
            throw new AnalysisException("ALTER TABLE SET SERDEPROPERTIES is not supported for DataSource table.");
        }
        this.dataSourcePropertyCheck("__IMPALA_DATA_SOURCE_NAME");
        this.dataSourcePropertyCheck("__IMPALA_DATA_SOURCE_INIT_STRING");
        this.dataSourcePropertyCheck("__IMPALA_DATA_SOURCE_LOCATION");
        this.dataSourcePropertyCheck("__IMPALA_DATA_SOURCE_CLASS");
        this.dataSourcePropertyCheck("__IMPALA_DATA_SOURCE_API_VERSION");
    }

    private void dataSourcePropertyCheck(String property) throws AnalysisException {
        if (this.tblProperties_.containsKey(property)) {
            throw new AnalysisException(String.format("Changing the '%s' table property is not supported for DataSource table.", property));
        }
    }

    private void analyzeAvroSchema(Analyzer analyzer) throws AnalysisException {
        ArrayList<Map<String, String>> schemaSearchLocations = new ArrayList<Map<String, String>>();
        schemaSearchLocations.add(this.tblProperties_);
        String avroSchema = AvroSchemaUtils.getAvroSchema(schemaSearchLocations);
        avroSchema = Strings.nullToEmpty((String)avroSchema);
        if (avroSchema.isEmpty()) {
            throw new AnalysisException("Avro schema is null or empty: " + this.table_.getFullName());
        }
        try {
            AvroSchemaParser.parse(avroSchema);
        }
        catch (SchemaParseException e) {
            throw new AnalysisException(String.format("Error parsing Avro schema for table '%s': %s", this.table_.getFullName(), e.getMessage()));
        }
    }

    public void analyzeSerializationEncoding(Map<String, String> tblProperties) throws AnalysisException {
        String encoding;
        if (!tblProperties.containsKey("serialization.encoding") || !this.getOperation().equals("SET SERDEPROPERTIES")) {
            return;
        }
        FeTable tbl = this.getTargetTable();
        if (!(tbl instanceof FeFsTable)) {
            throw new AnalysisException(String.format("Property 'serialization.encoding' is only supported on HDFS tables. Conflicting table: %s", tbl.getFullName()));
        }
        if (this.partitionSet_ != null) {
            for (FeFsPartition feFsPartition : this.partitionSet_.getPartitions()) {
                if (feFsPartition.getFileFormat() == HdfsFileFormat.TEXT) continue;
                throw new AnalysisException(String.format("Property 'serialization.encoding' is only supported on TEXT file format.  Conflicting partition/format: %s %s", feFsPartition.getPartitionName(), feFsPartition.getFileFormat().name()));
            }
        } else {
            StorageDescriptor sd = tbl.getMetaStoreTable().getSd();
            HdfsFileFormat hdfsFileFormat = HdfsFileFormat.fromHdfsInputFormatClass(sd.getInputFormat(), sd.getSerdeInfo().getSerializationLib());
            if (hdfsFileFormat != HdfsFileFormat.TEXT) {
                throw new AnalysisException(String.format("Property 'serialization.encoding' is only supported on TEXT file format. Conflicting table/format: %s %s", tbl.getFullName(), hdfsFileFormat.name()));
            }
        }
        if (!Charset.isSupported(encoding = tblProperties.get("serialization.encoding"))) {
            throw new AnalysisException(String.format("Unsupported encoding: %s.", encoding));
        }
        Charset charset = Charset.forName(encoding);
        if (this.partitionSet_ != null) {
            for (FeFsPartition feFsPartition : this.partitionSet_.getPartitions()) {
                if (AlterTableSetTblProperties.isLineDelimiterSameAsAscii(feFsPartition.getInputFormatDescriptor().getLineDelim(), charset)) continue;
                throw new AnalysisException(String.format("Property 'serialization.encoding' only supports encodings in which line delimiter is compatible with ASCII. Conflicting partition: %s. Please refer to IMPALA-10319 for more info.", feFsPartition.getPartitionName()));
            }
        } else {
            HdfsStorageDescriptor hdfsStorageDescriptor;
            StorageDescriptor sd = tbl.getMetaStoreTable().getSd();
            try {
                hdfsStorageDescriptor = HdfsStorageDescriptor.fromStorageDescriptor(tbl.getName(), sd);
            }
            catch (HdfsStorageDescriptor.InvalidStorageDescriptorException e) {
                throw new LocalCatalogException(String.format("Invalid input format descriptor for table %s", this.table_.getFullName()), e);
            }
            if (!AlterTableSetTblProperties.isLineDelimiterSameAsAscii(hdfsStorageDescriptor.getLineDelim(), charset)) {
                throw new AnalysisException(String.format("Property 'serialization.encoding' only supports encodings in which line delimiter is compatible with ASCII. Conflicting table: %1$s. Please refer to IMPALA-10319 for more info.", this.table_.getFullName()));
            }
        }
    }

    public static boolean isLineDelimiterSameAsAscii(byte lineDelim, Charset charset) {
        String lineDelimStr = new String(new byte[]{lineDelim}, charset);
        byte[] newlineBytesInEncoding = lineDelimStr.getBytes(charset);
        byte[] newlineBytesInAscii = lineDelimStr.getBytes(StandardCharsets.US_ASCII);
        return Arrays.equals(newlineBytesInEncoding, newlineBytesInAscii);
    }

    public static void analyzeSkipHeaderLineCount(Map<String, String> tblProperties) throws AnalysisException {
        AlterTableSetTblProperties.analyzeSkipHeaderLineCount(null, tblProperties);
    }

    public static void analyzeSkipHeaderLineCount(FeTable table, Map<String, String> tblProperties) throws AnalysisException {
        if (tblProperties.containsKey("skip.header.line.count")) {
            if (table != null && !(table instanceof FeFsTable)) {
                throw new AnalysisException(String.format("Table property 'skip.header.line.count' is only supported for HDFS tables.", new Object[0]));
            }
            StringBuilder error = new StringBuilder();
            FeFsTable.Utils.parseSkipHeaderLineCount(tblProperties, error);
            if (error.length() > 0) {
                throw new AnalysisException(error.toString());
            }
        }
    }

    public static Pair<List<Integer>, TSortingOrder> analyzeSortColumns(FeTable table, Map<String, String> tblProperties) throws AnalysisException {
        boolean containsOrderingProperties = tblProperties.containsKey("sort.order");
        boolean containsSortingColumnProperties = tblProperties.containsKey("sort.columns");
        if (containsOrderingProperties || containsSortingColumnProperties) {
            if (table instanceof FeKuduTable) {
                throw new AnalysisException("'sort.*' table properties are not supported for Kudu tables.");
            }
            if (table instanceof FeDataSourceTable) {
                throw new AnalysisException("'sort.*' table properties are not supported for DataSource tables.");
            }
        }
        TSortingOrder sortingOrder = TSortingOrder.LEXICAL;
        if (containsOrderingProperties) {
            sortingOrder = TSortingOrder.valueOf(tblProperties.get("sort.order"));
        }
        if (!containsSortingColumnProperties) {
            return new Pair<List<Integer>, TSortingOrder>(new ArrayList(), sortingOrder);
        }
        Preconditions.checkState((!(table instanceof FeHBaseTable) ? 1 : 0) != 0);
        ArrayList sortCols = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)tblProperties.get("sort.columns")));
        return new Pair<List<Integer>, TSortingOrder>(TableDef.analyzeSortColumns(sortCols, table, sortingOrder), sortingOrder);
    }
}

