/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.impala.analysis.AlterTableSetStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.PartitionSet;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.RowFormat;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableSetRowFormatParams;
import org.apache.impala.thrift.TAlterTableType;

public class AlterTableSetRowFormatStmt
extends AlterTableSetStmt {
    private final RowFormat rowFormat_;

    public AlterTableSetRowFormatStmt(TableName tableName, PartitionSet partitionSet, RowFormat rowFormat) {
        super(tableName, partitionSet);
        this.rowFormat_ = rowFormat;
    }

    public RowFormat getRowFormat() {
        return this.rowFormat_;
    }

    @Override
    public String getOperation() {
        return "SET ROW FORMAT";
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.SET_ROW_FORMAT);
        TAlterTableSetRowFormatParams rowFormatParams = new TAlterTableSetRowFormatParams(this.getRowFormat().toThrift());
        if (this.getPartitionSet() != null) {
            rowFormatParams.setPartition_set(this.getPartitionSet().toThrift());
        }
        params.setSet_row_format_params(rowFormatParams);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        FeTable tbl = this.getTargetTable();
        if (!(tbl instanceof FeFsTable)) {
            throw new AnalysisException(String.format("ALTER TABLE SET ROW FORMAT is only supported on HDFS tables. Conflicting table: %1$s", tbl.getFullName()));
        }
        if (tbl instanceof FeIcebergTable) {
            throw new AnalysisException("ALTER TABLE SET ROWFORMAT is not supported on Iceberg tables: " + tbl.getFullName());
        }
        if (this.partitionSet_ != null) {
            for (FeFsPartition feFsPartition : this.partitionSet_.getPartitions()) {
                if (feFsPartition.getFileFormat() == HdfsFileFormat.TEXT || feFsPartition.getFileFormat() == HdfsFileFormat.SEQUENCE_FILE) continue;
                throw new AnalysisException(String.format("ALTER TABLE SET ROW FORMAT is only supported on TEXT or SEQUENCE file formats.  Conflicting partition/format: %1$s / %2$s", feFsPartition.getPartitionName(), feFsPartition.getFileFormat().name()));
            }
        } else {
            StorageDescriptor sd = ((FeFsTable)tbl).getMetaStoreTable().getSd();
            HdfsFileFormat hdfsFileFormat = HdfsFileFormat.fromHdfsInputFormatClass(sd.getInputFormat(), sd.getSerdeInfo().getSerializationLib());
            if (hdfsFileFormat != HdfsFileFormat.TEXT && hdfsFileFormat != HdfsFileFormat.SEQUENCE_FILE) {
                throw new AnalysisException(String.format("ALTER TABLE SET ROW FORMAT is only supported on TEXT or SEQUENCE file formats. Conflicting table/format: %1$s / %2$s", tbl.getFullName(), hdfsFileFormat.name()));
            }
        }
    }
}

