/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.IcebergPartitionField;
import org.apache.impala.analysis.IcebergPartitionSpec;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableSetPartitionSpecParams;
import org.apache.impala.thrift.TAlterTableType;

public class AlterTableSetPartitionSpecStmt
extends AlterTableStmt {
    private final IcebergPartitionSpec icebergPartSpec_;

    public AlterTableSetPartitionSpecStmt(TableName tableName, IcebergPartitionSpec icebergPartSpec) {
        super(tableName);
        Preconditions.checkNotNull((Object)icebergPartSpec);
        Preconditions.checkState((boolean)icebergPartSpec.hasPartitionFields());
        this.icebergPartSpec_ = icebergPartSpec;
    }

    @Override
    public String getOperation() {
        return "SET PARTITION SPEC";
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder("ALTER TABLE ");
        if (this.getDb() != null) {
            sb.append(this.getDb() + ".");
        }
        sb.append(this.getTbl()).append(" SET PARTITION SPEC ").append(this.icebergPartSpec_.toSql(options));
        return sb.toString();
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableSetPartitionSpecParams setPartSpecParams = new TAlterTableSetPartitionSpecParams();
        setPartSpecParams.setPartition_spec(this.icebergPartSpec_.toThrift());
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.SET_PARTITION_SPEC);
        params.setSet_partition_spec_params(setPartSpecParams);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        FeTable table = this.getTargetTable();
        if (!(table instanceof FeIcebergTable)) {
            throw new AnalysisException("ALTER TABLE SET PARTITION SPEC is only supported for Iceberg tables: " + table.getTableName());
        }
        this.icebergPartSpec_.analyze(analyzer);
        for (IcebergPartitionField partField : this.icebergPartSpec_.getIcebergPartitionFields()) {
            Column col = table.getColumn(partField.getFieldName());
            if (col == null) {
                throw new AnalysisException(String.format("Source column '%s' does not exist in table: %s", partField.getFieldName(), table.getTableName()));
            }
            if (!col.getType().isComplexType()) continue;
            throw new AnalysisException(String.format("Source column '%s' in table %s must be a primitive type", partField.getFieldName(), table.getTableName()));
        }
    }
}

