/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.impala.analysis.AlterTableSetStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.PartitionSet;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableSetLocationParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.TPartitionKeyValue;

public class AlterTableSetLocationStmt
extends AlterTableSetStmt {
    private static final int NUM_PARTITION_LOG_LIMIT = 3;
    private final HdfsUri location_;

    public AlterTableSetLocationStmt(TableName tableName, PartitionSet partitionSet, HdfsUri location) {
        super(tableName, partitionSet);
        Preconditions.checkNotNull((Object)location);
        this.location_ = location;
    }

    public HdfsUri getLocation() {
        return this.location_;
    }

    @Override
    public String getOperation() {
        return "SET LOCATION";
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.SET_LOCATION);
        TAlterTableSetLocationParams locationParams = new TAlterTableSetLocationParams(this.location_.toString());
        PartitionSet partitionSet = this.getPartitionSet();
        if (partitionSet != null && !partitionSet.getPartitions().isEmpty()) {
            List<List<TPartitionKeyValue>> tPartitionSet = partitionSet.toThrift();
            Preconditions.checkState((tPartitionSet.size() == 1 ? 1 : 0) != 0);
            locationParams.setPartition_spec(tPartitionSet.get(0));
        }
        params.setSet_location_params(locationParams);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        this.location_.analyze(analyzer, Privilege.ALL, FsAction.READ_WRITE);
        FeTable table = this.getTargetTable();
        Preconditions.checkNotNull((Object)table);
        if (table instanceof FeIcebergTable) {
            throw new AnalysisException("ALTER TABLE SET LOCATION is not supported on Iceberg tables: " + table.getFullName());
        }
        if (table instanceof FeFsTable) {
            FeFsTable hdfsTable = (FeFsTable)table;
            if (this.getPartitionSet() != null) {
                List<? extends FeFsPartition> partitions = this.getPartitionSet().getPartitions();
                if (partitions.isEmpty()) {
                    return;
                }
                if (partitions.size() != 1) {
                    ArrayList sortedPartitions = Lists.newArrayList(partitions);
                    Collections.sort(sortedPartitions, HdfsPartition.KV_COMPARATOR);
                    List sortedPartitionNames = Lists.transform(sortedPartitions.subList(0, 3), (Function)new Function<FeFsPartition, String>(){

                        public String apply(FeFsPartition hdfsPartition) {
                            return hdfsPartition.getPartitionName();
                        }
                    });
                    throw new AnalysisException(String.format("Partition expr in set location statements can only match one partition. Too many matched partitions %s %s", Joiner.on((String)",").join((Iterable)sortedPartitionNames), sortedPartitions.size() < partitions.size() ? "..." : "."));
                }
                if (partitions.get(0).isMarkedCached()) {
                    throw new AnalysisException(String.format("Target partition is cached, please uncache before changing the location using: ALTER TABLE %s %s SET UNCACHED", table.getFullName(), this.getPartitionSet().toSql()));
                }
            } else if (hdfsTable.isMarkedCached()) {
                throw new AnalysisException(String.format("Target table is cached, please uncache before changing the location using: ALTER TABLE %s SET UNCACHED", table.getFullName()));
            }
        } else if (table instanceof FeKuduTable) {
            throw new AnalysisException("ALTER TABLE SET LOCATION is not supported on Kudu tables: " + table.getFullName());
        }
    }
}

