/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import org.apache.impala.analysis.AlterTableSetStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.PartitionSet;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableSetFileFormatParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.THdfsFileFormat;

public class AlterTableSetFileFormatStmt
extends AlterTableSetStmt {
    private final THdfsFileFormat fileFormat_;

    public AlterTableSetFileFormatStmt(TableName tableName, PartitionSet partitionSet, THdfsFileFormat fileFormat) {
        super(tableName, partitionSet);
        this.fileFormat_ = fileFormat;
    }

    public THdfsFileFormat getFileFormat() {
        return this.fileFormat_;
    }

    @Override
    public String getOperation() {
        return "SET FILEFORMAT";
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.SET_FILE_FORMAT);
        TAlterTableSetFileFormatParams fileFormatParams = new TAlterTableSetFileFormatParams(this.fileFormat_);
        if (this.getPartitionSet() != null) {
            fileFormatParams.setPartition_set(this.getPartitionSet().toThrift());
        }
        params.setSet_file_format_params(fileFormatParams);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        FeTable tbl = this.getTargetTable();
        if (tbl instanceof FeKuduTable) {
            throw new AnalysisException("ALTER TABLE SET FILEFORMAT is not supported on Kudu tables: " + tbl.getFullName());
        }
        if (tbl instanceof FeIcebergTable) {
            throw new AnalysisException("ALTER TABLE SET FILEFORMAT is not supported on Iceberg tables: " + tbl.getFullName());
        }
    }
}

