/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.TAlterTableUpdateStatsParams;

public class AlterTableSetColumnStats
extends AlterTableStmt {
    private final String colName_;
    private final Map<String, String> statsMap_;
    private ColumnStats colStats_;

    public AlterTableSetColumnStats(TableName tableName, String colName, Map<String, String> statsMap) {
        super(tableName);
        this.colName_ = colName;
        this.statsMap_ = statsMap;
    }

    @Override
    public String getOperation() {
        return "SET COLUMN STATS";
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        Column col = this.getTargetTable().getColumn(this.colName_);
        if (col == null) {
            throw new AnalysisException(String.format("Column '%s' does not exist in table: %s", this.colName_, this.getTargetTable().getFullName()));
        }
        if (col.getPosition() < this.getTargetTable().getNumClusteringCols()) {
            throw new AnalysisException("Updating the stats of a partition column is not allowed: " + this.colName_);
        }
        if (!ColumnStats.isSupportedColType(col.getType())) {
            throw new AnalysisException(String.format("Statistics for column '%s' are not supported because it has type '%s'.", col.getName(), col.getType().toSql()));
        }
        this.colStats_ = col.getStats().clone();
        for (Map.Entry<String, String> entry : this.statsMap_.entrySet()) {
            ColumnStats.StatsKey statsKey = ColumnStats.StatsKey.fromString(entry.getKey());
            if (statsKey == null) {
                throw new AnalysisException(String.format("Invalid column stats key: %s\nValid keys are: %s", entry.getKey(), Joiner.on((char)',').join((Object[])ColumnStats.StatsKey.values())));
            }
            this.setStatsValue(statsKey, entry.getValue(), col, this.colStats_);
        }
    }

    private void setStatsValue(ColumnStats.StatsKey statsKey, String statsValue, Column col, ColumnStats stats) throws AnalysisException {
        if (col.getType().isFixedLengthType() && (statsKey == ColumnStats.StatsKey.AVG_SIZE || statsKey == ColumnStats.StatsKey.MAX_SIZE)) {
            throw new AnalysisException(String.format("Cannot update the '%s' stats of column '%s' with type '%s'.\nChanging '%s' is only allowed for variable-length columns.", new Object[]{statsKey, col.getName(), col.getType().toSql(), statsKey}));
        }
        if (statsKey == ColumnStats.StatsKey.NUM_DISTINCT_VALUES || statsKey == ColumnStats.StatsKey.NUM_NULLS || statsKey == ColumnStats.StatsKey.MAX_SIZE || statsKey == ColumnStats.StatsKey.NUM_TRUES || statsKey == ColumnStats.StatsKey.NUM_FALSES) {
            Long statsVal = null;
            try {
                statsVal = Long.parseLong(statsValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (statsVal == null || statsVal < -1L) {
                throw new AnalysisException(String.format("Invalid stats value '%s' for column stats key: %s\nExpected a non-negative integer or -1 for unknown.", new Object[]{statsValue, statsKey}));
            }
            stats.update(col.getType(), statsKey, statsVal);
        } else if (statsKey == ColumnStats.StatsKey.AVG_SIZE) {
            Float statsVal = null;
            try {
                statsVal = Float.valueOf(Float.parseFloat(statsValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (statsVal == null || statsVal.floatValue() < 0.0f && statsVal.floatValue() != -1.0f || statsVal.isNaN() || statsVal.isInfinite()) {
                throw new AnalysisException(String.format("Invalid stats value '%s' for column stats key: %s\nExpected a non-negative floating-point number or -1 for unknown.", new Object[]{statsValue, statsKey}));
            }
            stats.update(col.getType(), statsKey, statsVal);
        } else {
            Preconditions.checkState((boolean)false, (Object)("Unhandled StatsKey value: " + (Object)((Object)statsKey)));
        }
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.UPDATE_STATS);
        TAlterTableUpdateStatsParams updateStatsParams = new TAlterTableUpdateStatsParams();
        updateStatsParams.setTable_name(this.getTargetTable().getTableName().toThrift());
        updateStatsParams.putToColumn_stats(this.colName_.toString(), this.colStats_.toThrift());
        params.setUpdate_stats_params(updateStatsParams);
        return params;
    }
}

