/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Owner;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterTableOrViewSetOwnerParams;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.TOwnerType;

public abstract class AlterTableOrViewSetOwnerStmt
extends AlterTableStmt {
    protected final Owner owner_;
    private String serverName_;

    public AlterTableOrViewSetOwnerStmt(TableName tableName, Owner owner) {
        super(tableName);
        Preconditions.checkNotNull((Object)owner);
        this.owner_ = owner;
    }

    @Override
    public String getOperation() {
        return "SET OWNER";
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        AuthorizationFactory authzFactory;
        AuthorizationChecker authzChecker;
        String ownerName = this.owner_.getOwnerName();
        if (ownerName.length() > 128) {
            throw new AnalysisException(String.format("Owner name exceeds maximum length of %d characters. The given owner name has %d characters.", 128, ownerName.length()));
        }
        if (analyzer.isAuthzEnabled() && this.owner_.getOwnerType() == TOwnerType.ROLE && !(authzChecker = (authzFactory = analyzer.getAuthzFactory()).newAuthorizationChecker()).roleExists(ownerName)) {
            throw new AnalysisException(String.format("Role '%s' does not exist.", ownerName));
        }
        this.tableName_ = analyzer.getFqTableName(this.tableName_);
        TableRef tableRef = new TableRef(this.tableName_.toPath(), null, Privilege.ALL, true);
        tableRef = analyzer.resolveTableRef(tableRef);
        Preconditions.checkNotNull((Object)tableRef);
        tableRef.analyze(analyzer);
        this.validateType(tableRef);
        this.serverName_ = analyzer.getServerName();
    }

    protected abstract void validateType(TableRef var1) throws AnalysisException;

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = new TAlterTableParams();
        params.setTable_name(this.tableName_.toThrift());
        TAlterTableOrViewSetOwnerParams ownerParams = new TAlterTableOrViewSetOwnerParams();
        ownerParams.setOwner_type(this.owner_.getOwnerType());
        ownerParams.setOwner_name(this.owner_.getOwnerName());
        ownerParams.setServer_name(this.serverName_);
        params.setAlter_type(TAlterTableType.SET_OWNER);
        params.setSet_owner_params(ownerParams);
        return params;
    }
}

