/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.AlterTableExecuteStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.thrift.TAlterTableExecuteParams;
import org.apache.impala.thrift.TAlterTableExecuteRemoveOrphanFilesParams;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.util.ExprUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTableExecuteRemoveOrphanFilesStmt
extends AlterTableExecuteStmt {
    public static final String USAGE = "EXECUTE REMOVE_ORPHAN_FILES(<expression>):";
    private static final Logger LOG = LoggerFactory.getLogger(AlterTableExecuteRemoveOrphanFilesStmt.class);

    public AlterTableExecuteRemoveOrphanFilesStmt(TableName tableName, FunctionCallExpr fnCallExpr) {
        super(tableName, fnCallExpr);
    }

    @Override
    public String getOperation() {
        return "EXECUTE REMOVE_ORPHAN_FILES";
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        FeTable table = this.getTargetTable();
        if (!(table instanceof FeIcebergTable)) {
            throw new AnalysisException("ALTER TABLE EXECUTE REMOVE_ORPHAN_FILES is only supported for Iceberg tables: " + table.getTableName());
        }
        this.analyzeFunctionCallExpr(analyzer, USAGE);
        this.analyzeParameter(analyzer);
    }

    private void analyzeParameter(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkNotNull((Object)this.fnParamValue_);
        this.fnParamValue_.analyze(analyzer);
        if (!this.fnParamValue_.isConstant()) {
            throw new AnalysisException("EXECUTE REMOVE_ORPHAN_FILES(<expression>): <expression> must be a constant expression: " + this.fnCallExpr_.toSql());
        }
        Expr timestampExpr = this.getParamConvertibleToTimestamp();
        if (timestampExpr == null) {
            throw new AnalysisException("EXECUTE REMOVE_ORPHAN_FILES(<expression>): <expression> must be a timestamp, but is '" + this.fnParamValue_.getType() + "': " + this.fnCallExpr_.toSql());
        }
        try {
            this.olderThanMillis_ = ExprUtil.localTimestampToUnixTimeMicros(analyzer, timestampExpr) / 1000L;
            LOG.debug("EXECUTE REMOVE_ORPHAN_FILES(<expression>): millis: " + this.olderThanMillis_);
        }
        catch (InternalException ie) {
            throw new AnalysisException("An invalid TIMESTAMP expression has been given to EXECUTE REMOVE_ORPHAN_FILES(<expression>): the expression " + this.fnParamValue_.toSql() + " cannot be converted to a TIMESTAMP", ie);
        }
    }

    private Expr getParamConvertibleToTimestamp() {
        Preconditions.checkNotNull((Object)this.fnParamValue_);
        Expr timestampExpr = this.fnParamValue_;
        if (timestampExpr.getType().isStringType()) {
            timestampExpr = new CastExpr(Type.TIMESTAMP, this.fnParamValue_);
        }
        if (timestampExpr.getType().isTimestamp()) {
            return timestampExpr;
        }
        return null;
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.EXECUTE);
        TAlterTableExecuteParams executeParams = new TAlterTableExecuteParams();
        TAlterTableExecuteRemoveOrphanFilesParams removeOrphanParams = new TAlterTableExecuteRemoveOrphanFilesParams();
        executeParams.setRemove_orphan_files_params(removeOrphanParams);
        removeOrphanParams.setOlder_than_millis(this.olderThanMillis_);
        params.setSet_execute_params(executeParams);
        return params;
    }
}

