/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.AlterTableExecuteStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.thrift.TAlterTableExecuteExpireSnapshotsParams;
import org.apache.impala.thrift.TAlterTableExecuteParams;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.util.ExprUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTableExecuteExpireSnapshotsStmt
extends AlterTableExecuteStmt {
    private static final Logger LOG = LoggerFactory.getLogger(AlterTableExecuteExpireSnapshotsStmt.class);
    protected static final String USAGE = "EXPIRE_SNAPSHOTS(<expression>)";

    protected AlterTableExecuteExpireSnapshotsStmt(TableName tableName, Expr fnCallExpr) {
        super(tableName, fnCallExpr);
    }

    @Override
    public String getOperation() {
        return "EXECUTE EXPIRE_SNAPSHOTS";
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        Preconditions.checkState((boolean)(this.getTargetTable() instanceof FeIcebergTable));
        this.analyzeFunctionCallExpr(analyzer, USAGE);
        this.analyzeOlderThan(analyzer);
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.EXECUTE);
        TAlterTableExecuteParams executeParams = new TAlterTableExecuteParams();
        TAlterTableExecuteExpireSnapshotsParams executeExpireSnapshotsParams = new TAlterTableExecuteExpireSnapshotsParams();
        executeParams.setExpire_snapshots_params(executeExpireSnapshotsParams);
        executeExpireSnapshotsParams.setOlder_than_millis(this.olderThanMillis_);
        params.setSet_execute_params(executeParams);
        return params;
    }

    protected void analyzeOlderThan(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkNotNull((Object)this.fnParamValue_);
        this.fnParamValue_.analyze(analyzer);
        if (!this.fnParamValue_.isConstant()) {
            throw new AnalysisException("EXPIRE_SNAPSHOTS(<expression>) must be a constant expression: " + this.fnCallExpr_.toSql());
        }
        if (this.fnParamValue_.getType().isStringType()) {
            this.fnParamValue_ = new CastExpr(Type.TIMESTAMP, this.fnParamValue_);
        }
        if (!this.fnParamValue_.getType().isTimestamp()) {
            throw new AnalysisException("EXPIRE_SNAPSHOTS(<expression>) must be a timestamp type but is '" + this.fnParamValue_.getType() + "': " + this.fnParamValue_.toSql());
        }
        try {
            this.olderThanMillis_ = ExprUtil.localTimestampToUnixTimeMicros(analyzer, this.fnParamValue_) / 1000L;
            LOG.debug("EXPIRE_SNAPSHOTS(<expression>) millis: " + this.olderThanMillis_);
        }
        catch (InternalException ie) {
            throw new AnalysisException("Invalid TIMESTAMP expression has been given to EXPIRE_SNAPSHOTS(<expression>): " + ie.getMessage(), ie);
        }
    }
}

