/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.impala.analysis.AlterTableStmt;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.IcebergPartitionExpressionRewriter;
import org.apache.impala.analysis.PartitionSet;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.IcebergPartitionPredicateConverter;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TAlterTableDropPartitionParams;
import org.apache.impala.thrift.TAlterTableParams;
import org.apache.impala.thrift.TAlterTableType;
import org.apache.impala.thrift.TIcebergDropPartitionRequest;
import org.apache.impala.util.IcebergUtil;

public class AlterTableDropPartitionStmt
extends AlterTableStmt {
    private final boolean ifExists_;
    private final PartitionSet partitionSet_;
    private final boolean purgePartition_;
    private List<String> icebergFilePaths_;
    private long numberOfIcebergPartitions_;
    private boolean isIcebergTruncate_ = false;

    public AlterTableDropPartitionStmt(TableName tableName, PartitionSet partitionSet, boolean ifExists, boolean purgePartition) {
        super(tableName);
        Preconditions.checkNotNull((Object)partitionSet);
        this.partitionSet_ = partitionSet;
        this.partitionSet_.setTableName(tableName);
        this.ifExists_ = ifExists;
        this.purgePartition_ = purgePartition;
    }

    public boolean getIfNotExists() {
        return this.ifExists_;
    }

    @Override
    public String getOperation() {
        StringBuilder sb = new StringBuilder("DROP ");
        if (this.ifExists_) {
            sb.append("IF EXISTS ");
        }
        sb.append("PARTITION");
        return sb.toString();
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder("ALTER TABLE " + this.getTbl());
        sb.append(" DROP ");
        if (this.ifExists_) {
            sb.append("IF EXISTS ");
        }
        sb.append(this.partitionSet_.toSql(options));
        if (this.purgePartition_) {
            sb.append(" PURGE");
        }
        return sb.toString();
    }

    @Override
    public TAlterTableParams toThrift() {
        TAlterTableParams params = super.toThrift();
        params.setAlter_type(TAlterTableType.DROP_PARTITION);
        TAlterTableDropPartitionParams dropPartParams = new TAlterTableDropPartitionParams();
        dropPartParams.setIf_exists(!this.partitionSet_.getPartitionShouldExist());
        dropPartParams.setPurge(this.purgePartition_);
        params.setDrop_partition_params(dropPartParams);
        if (this.table_ instanceof FeIcebergTable) {
            TIcebergDropPartitionRequest request = new TIcebergDropPartitionRequest();
            request.setIs_truncate(this.isIcebergTruncate_);
            if (this.isIcebergTruncate_) {
                request.setPaths(Collections.emptyList());
            } else {
                request.setPaths(this.icebergFilePaths_);
            }
            request.num_partitions = this.numberOfIcebergPartitions_;
            dropPartParams.setIceberg_drop_partition_request(request);
            dropPartParams.setPartition_set(Collections.emptyList());
        } else {
            dropPartParams.setPartition_set(this.partitionSet_.toThrift());
        }
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        FeTable table = this.getTargetTable();
        if (table instanceof FeKuduTable) {
            throw new AnalysisException("ALTER TABLE DROP PARTITION is not supported for Kudu tables: " + this.partitionSet_.toSql());
        }
        if (!this.ifExists_) {
            this.partitionSet_.setPartitionShouldExist();
        }
        this.partitionSet_.setPrivilegeRequirement(Privilege.ALTER);
        this.partitionSet_.analyze(analyzer);
        if (table instanceof FeIcebergTable) {
            this.analyzeIceberg(analyzer);
        }
    }

    public void analyzeIceberg(Analyzer analyzer) throws AnalysisException {
        if (this.purgePartition_) {
            throw new AnalysisException("Partition purge is not supported for Iceberg tables");
        }
        FeIcebergTable table = (FeIcebergTable)this.table_;
        IcebergPartitionExpressionRewriter rewriter = new IcebergPartitionExpressionRewriter(analyzer, table.getIcebergApiTable().spec());
        IcebergPartitionPredicateConverter converter = new IcebergPartitionPredicateConverter(table.getIcebergSchema(), analyzer);
        ArrayList<Expression> icebergPartitionExprs = new ArrayList<Expression>();
        for (Expr expr : this.partitionSet_.getPartitionExprs()) {
            expr = rewriter.rewrite(expr);
            expr.analyze(analyzer);
            analyzer.getConstantFolder().rewrite(expr, analyzer);
            try {
                icebergPartitionExprs.add(converter.convert(expr));
            }
            catch (ImpalaException e) {
                throw new AnalysisException("Invalid partition filtering expression: " + expr.toSql());
            }
        }
        try (CloseableIterable<FileScanTask> fileScanTasks = IcebergUtil.planFiles(table, icebergPartitionExprs, null, null);){
            this.icebergFilePaths_ = new ArrayList<String>();
            HashSet<String> icebergPartitionSummary = new HashSet<String>();
            for (FileScanTask fileScanTask : fileScanTasks) {
                if (!fileScanTask.residual().isEquivalentTo((Expression)Expressions.alwaysTrue())) continue;
                icebergPartitionSummary.add(((DataFile)fileScanTask.file()).partition().toString());
                List deleteFiles = fileScanTask.deletes();
                if (!deleteFiles.isEmpty()) {
                    this.icebergFilePaths_.addAll(deleteFiles.stream().map(deleteFile -> deleteFile.path().toString()).collect(Collectors.toSet()));
                }
                this.icebergFilePaths_.add(((DataFile)fileScanTask.file()).path().toString());
            }
            this.numberOfIcebergPartitions_ = icebergPartitionSummary.size();
            if ((long)this.icebergFilePaths_.size() == FeIcebergTable.Utils.getTotalNumberOfFiles(table, null)) {
                this.isIcebergTruncate_ = true;
                this.icebergFilePaths_ = Collections.emptyList();
            }
        }
        catch (IOException | TableLoadingException | ImpalaRuntimeException e) {
            throw new AnalysisException("Error loading metadata for Iceberg table", e);
        }
        if (this.numberOfIcebergPartitions_ == 0L && !this.ifExists_) {
            throw new AnalysisException("No matching partition(s) found");
        }
    }
}

