/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TAlterDbParams;

public abstract class AlterDbStmt
extends StatementBase {
    protected final String dbName_;

    public AlterDbStmt(String dbName) {
        Preconditions.checkNotNull((Object)dbName);
        this.dbName_ = dbName;
    }

    public TAlterDbParams toThrift() {
        TAlterDbParams params = new TAlterDbParams();
        params.setDb(this.dbName_);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        analyzer.getDb(this.dbName_, Privilege.ALTER);
    }

    @Override
    public String getParsedDb() {
        return this.dbName_;
    }
}

