/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.AggregateInfoBase;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.IsNullPredicate;
import org.apache.impala.analysis.MultiAggregateInfo;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.AggregateFunction;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.planner.ProcessingCost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateInfo
extends AggregateInfoBase {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateInfo.class);
    private static final double COST_COEFFICIENT_AGG_EXPR = 0.07;
    private static final double COST_COEFFICIENT_AGG_INPUT_SINGLE_GROUP = 0.2925;
    private static final double COST_COEFFICIENT_AGG_OUTPUT_SINGLE_GROUP = 2.6072;
    private static final double COST_COEFFICIENT_AGG_INPUT_MULTI_GROUP = 1.3741;
    private static final double COST_COEFFICIENT_AGG_OUTPUT_MULTI_GROUP = 4.5285;
    private AggregateInfo mergeAggInfo_;
    private AggregateInfo secondPhaseDistinctAggInfo_;
    private final MultiAggregateInfo.AggPhase aggPhase_;
    protected ExprSubstitutionMap intermediateTupleSmap_ = new ExprSubstitutionMap();
    protected ExprSubstitutionMap outputTupleSmap_ = new ExprSubstitutionMap();
    private List<Expr> partitionExprs_;

    private AggregateInfo(List<Expr> groupingExprs, List<FunctionCallExpr> aggExprs, MultiAggregateInfo.AggPhase aggPhase) {
        super(groupingExprs, aggExprs);
        this.aggPhase_ = aggPhase;
    }

    private AggregateInfo(AggregateInfo other) {
        super(other);
        if (other.mergeAggInfo_ != null) {
            this.mergeAggInfo_ = other.mergeAggInfo_.clone();
        }
        if (other.secondPhaseDistinctAggInfo_ != null) {
            this.secondPhaseDistinctAggInfo_ = other.secondPhaseDistinctAggInfo_.clone();
        }
        this.aggPhase_ = other.aggPhase_;
        this.outputTupleSmap_ = other.outputTupleSmap_.clone();
        if (other.requiresIntermediateTuple()) {
            this.intermediateTupleSmap_ = other.intermediateTupleSmap_.clone();
        } else {
            Preconditions.checkState((other.intermediateTupleDesc_ == other.outputTupleDesc_ ? 1 : 0) != 0);
            this.intermediateTupleSmap_ = this.outputTupleSmap_;
        }
        this.partitionExprs_ = other.partitionExprs_ != null ? Expr.cloneList(other.partitionExprs_) : null;
    }

    public List<Expr> getPartitionExprs() {
        return this.partitionExprs_;
    }

    public void setPartitionExprs(List<Expr> exprs) {
        this.partitionExprs_ = exprs;
    }

    public static AggregateInfo create(List<Expr> groupingExprs, List<FunctionCallExpr> aggExprs, TupleDescriptor tupleDesc, Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((groupingExprs != null && !groupingExprs.isEmpty() || aggExprs != null && !aggExprs.isEmpty() ? 1 : 0) != 0);
        AggregateInfo result = new AggregateInfo(groupingExprs, aggExprs, MultiAggregateInfo.AggPhase.FIRST);
        ArrayList<FunctionCallExpr> distinctAggExprs = new ArrayList<FunctionCallExpr>();
        if (aggExprs != null) {
            for (FunctionCallExpr aggExpr : aggExprs) {
                if (!aggExpr.isDistinct()) continue;
                distinctAggExprs.add(aggExpr);
            }
        }
        if (distinctAggExprs.isEmpty()) {
            if (tupleDesc == null) {
                result.createTupleDescs(analyzer);
                result.createSmaps(analyzer);
            } else {
                Preconditions.checkState((aggExprs == null ? 1 : 0) != 0);
                result.outputTupleDesc_ = tupleDesc;
                result.intermediateTupleDesc_ = tupleDesc;
            }
            result.createMergeAggInfo(analyzer);
        } else {
            Preconditions.checkState((tupleDesc == null ? 1 : 0) != 0);
            result.createDistinctAggInfo(groupingExprs, distinctAggExprs, analyzer);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("agg info:\n" + result.debugString());
        }
        return result;
    }

    public static AggregateInfo create(List<Expr> groupingExprs, List<FunctionCallExpr> aggExprs, Analyzer analyzer) throws AnalysisException {
        return AggregateInfo.create(groupingExprs, aggExprs, null, analyzer);
    }

    private void createDistinctAggInfo(List<Expr> origGroupingExprs, List<FunctionCallExpr> distinctAggExprs, Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((!distinctAggExprs.isEmpty() ? 1 : 0) != 0);
        List<Expr> expr0Children = AggregateFunction.getCanonicalDistinctAggChildren(distinctAggExprs.get(0));
        for (int i = 1; i < distinctAggExprs.size(); ++i) {
            List<Expr> exprIChildren = AggregateFunction.getCanonicalDistinctAggChildren(distinctAggExprs.get(i));
            Preconditions.checkState((boolean)Expr.equalLists(expr0Children, exprIChildren));
        }
        this.groupingExprs_.addAll(expr0Children);
        this.aggregateExprs_.removeAll(distinctAggExprs);
        this.createTupleDescs(analyzer);
        this.createSmaps(analyzer);
        this.createMergeAggInfo(analyzer);
        this.createSecondPhaseAggInfo(origGroupingExprs, distinctAggExprs, analyzer);
    }

    public AggregateInfo getMergeAggInfo() {
        return this.mergeAggInfo_;
    }

    public AggregateInfo getSecondPhaseDistinctAggInfo() {
        return this.secondPhaseDistinctAggInfo_;
    }

    public boolean isMerge() {
        return this.aggPhase_.isMerge();
    }

    public boolean isDistinctAgg() {
        return this.secondPhaseDistinctAggInfo_ != null;
    }

    public ExprSubstitutionMap getIntermediateSmap() {
        return this.intermediateTupleSmap_;
    }

    public ExprSubstitutionMap getOutputSmap() {
        return this.outputTupleSmap_;
    }

    public boolean hasAggregateExprs() {
        return !this.aggregateExprs_.isEmpty() || this.secondPhaseDistinctAggInfo_ != null && !this.secondPhaseDistinctAggInfo_.getAggregateExprs().isEmpty();
    }

    public TupleId getResultTupleId() {
        if (this.isDistinctAgg()) {
            return this.secondPhaseDistinctAggInfo_.getOutputTupleId();
        }
        return this.getOutputTupleId();
    }

    public TupleDescriptor getResultTupleDesc() {
        if (this.isDistinctAgg()) {
            return this.secondPhaseDistinctAggInfo_.getOutputTupleDesc();
        }
        return this.getOutputTupleDesc();
    }

    public ExprSubstitutionMap getResultSmap() {
        if (this.isDistinctAgg()) {
            return this.secondPhaseDistinctAggInfo_.getOutputSmap();
        }
        return this.getOutputSmap();
    }

    public List<FunctionCallExpr> getMaterializedAggregateExprs() {
        ArrayList<FunctionCallExpr> result = new ArrayList<FunctionCallExpr>();
        for (Integer i : this.materializedSlots_) {
            result.add((FunctionCallExpr)this.aggregateExprs_.get(i));
        }
        return result;
    }

    public void substitute(ExprSubstitutionMap smap, Analyzer analyzer) throws InternalException {
        this.groupingExprs_ = Expr.substituteList(this.groupingExprs_, smap, analyzer, true);
        if (LOG.isTraceEnabled()) {
            LOG.trace("AggInfo: grouping_exprs=" + Expr.debugString(this.groupingExprs_));
        }
        List<Expr> substitutedAggs = Expr.substituteList(this.aggregateExprs_, smap, analyzer, false);
        this.aggregateExprs_.clear();
        for (Expr substitutedAgg : substitutedAggs) {
            this.aggregateExprs_.add((FunctionCallExpr)substitutedAgg);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("AggInfo: agg_exprs=" + Expr.debugString(this.aggregateExprs_));
        }
        this.outputTupleSmap_.substituteLhs(smap, analyzer);
        this.intermediateTupleSmap_.substituteLhs(smap, analyzer);
        if (this.secondPhaseDistinctAggInfo_ != null) {
            this.secondPhaseDistinctAggInfo_.substitute(smap, analyzer);
        }
    }

    private void createMergeAggInfo(Analyzer analyzer) {
        Preconditions.checkState((this.mergeAggInfo_ == null ? 1 : 0) != 0);
        TupleDescriptor inputDesc = this.intermediateTupleDesc_;
        ArrayList<Expr> groupingExprs = new ArrayList<Expr>();
        for (int i = 0; i < this.getGroupingExprs().size(); ++i) {
            SlotRef slotRef = new SlotRef(inputDesc.getSlots().get(i));
            groupingExprs.add(slotRef);
        }
        ArrayList<FunctionCallExpr> aggExprs = new ArrayList<FunctionCallExpr>();
        for (int i = 0; i < this.getAggregateExprs().size(); ++i) {
            FunctionCallExpr inputExpr = this.getAggregateExprs().get(i);
            Preconditions.checkState((boolean)inputExpr.isAggregateFunction());
            SlotRef aggExprParam = new SlotRef(inputDesc.getSlots().get(i + this.getGroupingExprs().size()));
            FunctionCallExpr aggExpr = FunctionCallExpr.createMergeAggCall(inputExpr, Lists.newArrayList((Object[])new Expr[]{aggExprParam}));
            aggExpr.analyzeNoThrow(analyzer);
            aggExprs.add(aggExpr);
        }
        MultiAggregateInfo.AggPhase aggPhase = this.aggPhase_ == MultiAggregateInfo.AggPhase.FIRST ? MultiAggregateInfo.AggPhase.FIRST_MERGE : MultiAggregateInfo.AggPhase.SECOND_MERGE;
        this.mergeAggInfo_ = new AggregateInfo(groupingExprs, aggExprs, aggPhase);
        this.mergeAggInfo_.intermediateTupleDesc_ = this.intermediateTupleDesc_;
        this.mergeAggInfo_.outputTupleDesc_ = this.outputTupleDesc_;
        this.mergeAggInfo_.intermediateTupleSmap_ = this.intermediateTupleSmap_;
        this.mergeAggInfo_.outputTupleSmap_ = this.outputTupleSmap_;
        this.mergeAggInfo_.materializedSlots_ = this.materializedSlots_;
    }

    private Expr createCountDistinctAggExprParam(int firstIdx, int lastIdx, List<SlotDescriptor> slots) {
        if (firstIdx > lastIdx) {
            return null;
        }
        Expr elseExpr = new SlotRef(slots.get(lastIdx));
        if (firstIdx == lastIdx) {
            return elseExpr;
        }
        for (int i = lastIdx - 1; i >= firstIdx; --i) {
            ArrayList<Expr> ifArgs = new ArrayList<Expr>();
            SlotRef slotRef = new SlotRef(slots.get(i));
            IsNullPredicate isNullPred = new IsNullPredicate(slotRef, false);
            ifArgs.add(isNullPred);
            ifArgs.add(new NullLiteral());
            ifArgs.add(elseExpr);
            elseExpr = new FunctionCallExpr("if", ifArgs);
        }
        return elseExpr;
    }

    private void createSecondPhaseAggInfo(List<Expr> origGroupingExprs, List<FunctionCallExpr> distinctAggExprs, Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((this.secondPhaseDistinctAggInfo_ == null ? 1 : 0) != 0);
        Preconditions.checkState((!distinctAggExprs.isEmpty() ? 1 : 0) != 0);
        TupleDescriptor inputDesc = this.intermediateTupleDesc_;
        ArrayList<FunctionCallExpr> secondPhaseAggExprs = new ArrayList<FunctionCallExpr>();
        for (FunctionCallExpr inputExpr : distinctAggExprs) {
            Preconditions.checkState((boolean)inputExpr.isAggregateFunction());
            FunctionCallExpr aggExpr = null;
            if (inputExpr.getFnName().getFunction().equals("count")) {
                Expr ifExpr = this.createCountDistinctAggExprParam(origGroupingExprs.size(), origGroupingExprs.size() + inputExpr.getChildren().size() - 1, inputDesc.getSlots());
                Preconditions.checkNotNull((Object)ifExpr);
                ifExpr.analyzeNoThrow(analyzer);
                aggExpr = new FunctionCallExpr("count", (List<Expr>)Lists.newArrayList((Object[])new Expr[]{ifExpr}));
            } else if (inputExpr.getFnName().getFunction().equals("group_concat")) {
                ArrayList<Expr> exprList = new ArrayList<Expr>();
                exprList.add(new SlotRef(inputDesc.getSlots().get(origGroupingExprs.size())));
                if (inputExpr.getChildren().size() == 2) {
                    exprList.add((Expr)inputExpr.getChild(1));
                }
                aggExpr = new FunctionCallExpr(inputExpr.getFnName(), exprList);
            } else {
                SlotRef aggExprParam = new SlotRef(inputDesc.getSlots().get(origGroupingExprs.size()));
                aggExpr = new FunctionCallExpr(inputExpr.getFnName(), (List<Expr>)Lists.newArrayList((Object[])new Expr[]{aggExprParam}));
            }
            secondPhaseAggExprs.add(aggExpr);
        }
        for (int i = 0; i < this.aggregateExprs_.size(); ++i) {
            FunctionCallExpr inputExpr;
            inputExpr = (FunctionCallExpr)this.aggregateExprs_.get(i);
            Preconditions.checkState((boolean)inputExpr.isAggregateFunction());
            SlotRef aggExprParam = new SlotRef(inputDesc.getSlots().get(i + this.getGroupingExprs().size()));
            FunctionCallExpr aggExpr = FunctionCallExpr.createMergeAggCall(inputExpr, Lists.newArrayList((Object[])new Expr[]{aggExprParam}));
            secondPhaseAggExprs.add(aggExpr);
        }
        Preconditions.checkState((secondPhaseAggExprs.size() == this.aggregateExprs_.size() + distinctAggExprs.size() ? 1 : 0) != 0);
        for (FunctionCallExpr aggExpr : secondPhaseAggExprs) {
            aggExpr.analyzeNoThrow(analyzer);
            Preconditions.checkState((boolean)aggExpr.isAggregateFunction());
        }
        List<Expr> substGroupingExprs = Expr.substituteList(origGroupingExprs, this.intermediateTupleSmap_, analyzer, false);
        this.secondPhaseDistinctAggInfo_ = new AggregateInfo(substGroupingExprs, secondPhaseAggExprs, MultiAggregateInfo.AggPhase.SECOND);
        this.secondPhaseDistinctAggInfo_.createTupleDescs(analyzer);
        this.secondPhaseDistinctAggInfo_.createSecondPhaseAggSMap(this, distinctAggExprs);
        this.secondPhaseDistinctAggInfo_.createMergeAggInfo(analyzer);
    }

    private void createSecondPhaseAggSMap(AggregateInfo inputAggInfo, List<FunctionCallExpr> distinctAggExprs) {
        Expr aggExpr;
        this.outputTupleSmap_.clear();
        int slotIdx = 0;
        List<SlotDescriptor> slotDescs = this.outputTupleDesc_.getSlots();
        int numDistinctParams = distinctAggExprs.get(0).getChildren().size();
        if (distinctAggExprs.get(0).getFnName().getFunction().equalsIgnoreCase("group_concat") && numDistinctParams == 2) {
            --numDistinctParams;
        }
        int numOrigGroupingExprs = inputAggInfo.getGroupingExprs().size() - numDistinctParams;
        Preconditions.checkState((slotDescs.size() == numOrigGroupingExprs + distinctAggExprs.size() + inputAggInfo.getAggregateExprs().size() ? 1 : 0) != 0);
        int i = 0;
        while (i < numOrigGroupingExprs) {
            Expr groupingExpr = inputAggInfo.getGroupingExprs().get(i);
            this.outputTupleSmap_.put(groupingExpr.clone(), new SlotRef(slotDescs.get(slotIdx)));
            ++i;
            ++slotIdx;
        }
        i = 0;
        while (i < distinctAggExprs.size()) {
            aggExpr = distinctAggExprs.get(i);
            this.outputTupleSmap_.put(aggExpr.clone(), new SlotRef(slotDescs.get(slotIdx)));
            ++i;
            ++slotIdx;
        }
        i = 0;
        while (i < inputAggInfo.getAggregateExprs().size()) {
            aggExpr = inputAggInfo.getAggregateExprs().get(i);
            this.outputTupleSmap_.put(aggExpr.clone(), new SlotRef(slotDescs.get(slotIdx)));
            ++i;
            ++slotIdx;
        }
        ArrayList exprs = Lists.newArrayListWithCapacity((int)(this.groupingExprs_.size() + this.aggregateExprs_.size()));
        exprs.addAll(this.groupingExprs_);
        exprs.addAll(this.aggregateExprs_);
        for (int i2 = 0; i2 < exprs.size(); ++i2) {
            this.intermediateTupleSmap_.put(((Expr)exprs.get(i2)).clone(), new SlotRef(this.intermediateTupleDesc_.getSlots().get(i2)));
        }
    }

    public void createSmaps(Analyzer analyzer) {
        Preconditions.checkNotNull((Object)this.outputTupleDesc_);
        Preconditions.checkNotNull((Object)this.intermediateTupleDesc_);
        ArrayList exprs = Lists.newArrayListWithCapacity((int)(this.groupingExprs_.size() + this.aggregateExprs_.size()));
        exprs.addAll(this.groupingExprs_);
        exprs.addAll(this.aggregateExprs_);
        for (int i = 0; i < exprs.size(); ++i) {
            this.outputTupleSmap_.put(((Expr)exprs.get(i)).clone(), new SlotRef(this.outputTupleDesc_.getSlots().get(i)));
            if (!this.requiresIntermediateTuple()) continue;
            this.intermediateTupleSmap_.put(((Expr)exprs.get(i)).clone(), new SlotRef(this.intermediateTupleDesc_.getSlots().get(i)));
            if (i >= this.groupingExprs_.size()) continue;
            analyzer.createAuxEqPredicate(new SlotRef(this.outputTupleDesc_.getSlots().get(i)), new SlotRef(this.intermediateTupleDesc_.getSlots().get(i)));
        }
        if (!this.requiresIntermediateTuple()) {
            this.intermediateTupleSmap_ = this.outputTupleSmap_;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("output smap=" + this.outputTupleSmap_.debugString());
            LOG.trace("intermediate smap=" + this.intermediateTupleSmap_.debugString());
        }
    }

    @Override
    public void materializeRequiredSlots(Analyzer analyzer, ExprSubstitutionMap smap) {
        for (int i = 0; i < this.groupingExprs_.size(); ++i) {
            this.outputTupleDesc_.getSlots().get(i).setIsMaterialized(true);
            this.intermediateTupleDesc_.getSlots().get(i).setIsMaterialized(true);
        }
        this.materializedSlots_.clear();
        ArrayList exprs = new ArrayList();
        exprs.addAll(this.groupingExprs_);
        for (int i = 0; i < this.aggregateExprs_.size(); ++i) {
            SlotDescriptor slotDesc = this.outputTupleDesc_.getSlots().get(this.groupingExprs_.size() + i);
            SlotDescriptor intermediateSlotDesc = this.intermediateTupleDesc_.getSlots().get(this.groupingExprs_.size() + i);
            if (this.isDistinctAgg()) {
                slotDesc.setIsMaterialized(true);
                intermediateSlotDesc.setIsMaterialized(true);
            }
            if (!slotDesc.isMaterialized()) continue;
            intermediateSlotDesc.setIsMaterialized(true);
            exprs.add(this.aggregateExprs_.get(i));
            this.materializedSlots_.add(i);
        }
        List<Expr> resolvedExprs = Expr.substituteList(exprs, smap, analyzer, false);
        analyzer.materializeSlots(resolvedExprs);
        if (this.isDistinctAgg()) {
            this.secondPhaseDistinctAggInfo_.materializeRequiredSlots(analyzer, null);
        }
    }

    public boolean hasAllDistinctAgg() {
        if (this.hasAggregateExprs()) {
            for (FunctionCallExpr aggExpr : this.getMaterializedAggregateExprs()) {
                if (aggExpr.isDistinct() || aggExpr.ignoresDistinct()) continue;
                return false;
            }
        } else {
            Preconditions.checkState((!this.groupingExprs_.isEmpty() ? 1 : 0) != 0);
        }
        return true;
    }

    public boolean hasCountStarOnly() {
        if (this.getMaterializedAggregateExprs().size() != 1) {
            return false;
        }
        if (this.isDistinctAgg()) {
            return false;
        }
        FunctionCallExpr origExpr = this.getMaterializedAggregateExprs().get(0);
        if (!origExpr.getFnName().getFunction().equalsIgnoreCase("count")) {
            return false;
        }
        return origExpr.getParams().isStar();
    }

    public void checkConsistency() {
        Type slotType;
        int i;
        List<SlotDescriptor> slots = this.outputTupleDesc_.getSlots();
        int numMaterializedSlots = 0;
        for (SlotDescriptor slotDesc : slots) {
            if (!slotDesc.isMaterialized()) continue;
            ++numMaterializedSlots;
        }
        Preconditions.checkState((numMaterializedSlots == this.materializedSlots_.size() + this.groupingExprs_.size() ? 1 : 0) != 0);
        int slotIdx = 0;
        for (i = 0; i < this.groupingExprs_.size(); ++i) {
            Expr groupingExpr = (Expr)this.groupingExprs_.get(i);
            slotType = slots.get(slotIdx).getType();
            Preconditions.checkState((boolean)groupingExpr.getType().equals(slotType), (Object)String.format("Grouping expr %s returns type %s but its output tuple slot has type %s", groupingExpr.toSql(), groupingExpr.getType().toString(), slotType.toString()));
            ++slotIdx;
        }
        for (i = 0; i < this.aggregateExprs_.size(); ++i) {
            Expr aggExpr = (Expr)this.aggregateExprs_.get(i);
            slotType = slots.get(slotIdx).getType();
            Preconditions.checkState((boolean)aggExpr.getType().equals(slotType), (Object)String.format("Agg expr %s returns type %s but its output tuple slot has type %s", aggExpr.toSql(), aggExpr.getType().toString(), slotType.toString()));
            ++slotIdx;
        }
        if (this.mergeAggInfo_ != null) {
            for (i = 0; i < this.aggregateExprs_.size(); ++i) {
                FunctionCallExpr mergeAggExpr = (FunctionCallExpr)this.mergeAggInfo_.aggregateExprs_.get(i);
                mergeAggExpr.validateMergeAggFn((FunctionCallExpr)this.aggregateExprs_.get(i));
            }
        }
    }

    public boolean needsSerialize() {
        for (FunctionCallExpr aggregateExpr : this.aggregateExprs_) {
            Preconditions.checkState((boolean)aggregateExpr.isAnalyzed());
            AggregateFunction fn = (AggregateFunction)aggregateExpr.getFn();
            if (fn.getSerializeFnSymbol() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String debugString() {
        StringBuilder out = new StringBuilder(super.debugString());
        out.append(MoreObjects.toStringHelper((Object)this).add("phase", (Object)this.aggPhase_).add("intermediate_smap", (Object)this.intermediateTupleSmap_.debugString()).add("output_smap", (Object)this.outputTupleSmap_.debugString()).toString());
        if (this.mergeAggInfo_ != this && this.mergeAggInfo_ != null) {
            out.append("\nmergeAggInfo:\n" + this.mergeAggInfo_.debugString());
        }
        if (this.secondPhaseDistinctAggInfo_ != null) {
            out.append("\nsecondPhaseDistinctAggInfo:\n" + this.secondPhaseDistinctAggInfo_.debugString());
        }
        return out.toString();
    }

    @Override
    protected String tupleDebugName() {
        return "agg-tuple";
    }

    public AggregateInfo clone() {
        return new AggregateInfo(this);
    }

    public ProcessingCost computeProcessingCost(String label, long inputCardinality, long intermediateOutputCardinality) {
        Preconditions.checkArgument((inputCardinality >= 0L ? 1 : 0) != 0, (Object)"inputCardinality should not be negative!");
        Preconditions.checkArgument((intermediateOutputCardinality >= 0L ? 1 : 0) != 0, (Object)"intermediateOutputCardinality should not be negative!");
        int numGroupingExprs = this.getGroupingExprs().size();
        int numAggExprs = this.getMaterializedAggregateExprs().size();
        int numExtraAggExprs = numAggExprs > 1 ? numAggExprs - 1 : 0;
        double totalCost = 0.0;
        totalCost = numGroupingExprs == 0 ? (double)(inputCardinality * (long)numAggExprs) * 0.07 : (numGroupingExprs == 1 ? (double)inputCardinality * 0.2925 + (double)intermediateOutputCardinality * 2.6072 + (double)(inputCardinality * (long)numExtraAggExprs) * 0.07 : (double)inputCardinality * 1.3741 + (double)intermediateOutputCardinality * 4.5285 + (double)(inputCardinality * (long)numExtraAggExprs) * 0.07);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Total CPU cost estimate: " + totalCost + ", Grouping Exprs Count: " + numGroupingExprs + ", Agg Exprs Count: " + numAggExprs + ", Input Card: " + inputCardinality + ", Intermediate Output Card: " + intermediateOutputCardinality);
        }
        return ProcessingCost.basicCost(label, totalCost);
    }
}

