/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.PrivilegeRequestBuilder;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TAdminRequest;
import org.apache.impala.thrift.TAdminRequestType;
import org.apache.impala.thrift.TEventProcessorCmdParams;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TShutdownParams;

public class AdminFnStmt
extends StatementBase {
    private final String fnName_;
    private final List<Expr> params_;
    private TAdminRequestType type_;
    private TNetworkAddress backend_;
    private long deadlineSecs_;
    private String action_;
    private long event_id_ = 0L;

    public AdminFnStmt(String fnName, List<Expr> params) {
        this.fnName_ = fnName;
        this.params_ = params;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder sb = new StringBuilder();
        sb.append(":").append(this.fnName_).append("(");
        ArrayList<String> paramsSql = new ArrayList<String>();
        for (Expr param : this.params_) {
            paramsSql.add(param.toSql(options));
        }
        sb.append(Joiner.on((String)", ").join(paramsSql));
        sb.append(")");
        return sb.toString();
    }

    public TAdminRequest toThrift() throws InternalException {
        TAdminRequest result = new TAdminRequest();
        result.type = this.type_;
        if (this.type_ == TAdminRequestType.SHUTDOWN) {
            result.shutdown_params = new TShutdownParams();
            if (this.backend_ != null) {
                result.shutdown_params.setBackend(this.backend_);
            }
            if (this.deadlineSecs_ != -1L) {
                result.shutdown_params.setDeadline_s(this.deadlineSecs_);
            }
        } else if (this.type_ == TAdminRequestType.EVENT_PROCESSOR) {
            result.event_processor_cmd_params = new TEventProcessorCmdParams(this.action_);
            if (this.event_id_ != 0L) {
                result.event_processor_cmd_params.setEvent_id(this.event_id_);
            }
        } else {
            Preconditions.checkState((boolean)false, (String)"Unsupported TAdminRequest type %s", (Object)((Object)this.type_));
        }
        return result;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        for (Expr param : this.params_) {
            param.analyze(analyzer);
        }
        if (this.fnName_.equalsIgnoreCase("shutdown")) {
            this.type_ = TAdminRequestType.SHUTDOWN;
            this.analyzeShutdown(analyzer);
        } else if (this.fnName_.equalsIgnoreCase("event_processor")) {
            this.type_ = TAdminRequestType.EVENT_PROCESSOR;
            this.analyzeEventProcessorCmd(analyzer);
        } else {
            throw new AnalysisException("Unknown admin function: " + this.fnName_);
        }
    }

    private void registerPrivReq(Analyzer analyzer) {
        AuthorizationConfig authzConfig = analyzer.getAuthzConfig();
        if (authzConfig.isEnabled()) {
            String authzServer = authzConfig.getServerName();
            Preconditions.checkNotNull((Object)authzServer);
            analyzer.registerPrivReq((PrivilegeRequestBuilder builder) -> builder.onServer(authzServer).all().build());
        }
    }

    private void analyzeShutdown(Analyzer analyzer) throws AnalysisException {
        this.registerPrivReq(analyzer);
        Pair<Expr, Expr> args = this.getShutdownArgs();
        Expr backendExpr = (Expr)args.first;
        Expr deadlineExpr = (Expr)args.second;
        this.backend_ = null;
        this.deadlineSecs_ = -1L;
        if (backendExpr != null) {
            if (!(backendExpr instanceof StringLiteral)) {
                throw new AnalysisException("Invalid backend, must be a string literal: " + backendExpr.toSql());
            }
            this.backend_ = this.parseBackendAddress(((StringLiteral)backendExpr).getUnescapedValue());
        }
        if (deadlineExpr != null) {
            this.deadlineSecs_ = deadlineExpr.evalToNonNegativeInteger(analyzer, "deadline");
        }
    }

    private Pair<Expr, Expr> getShutdownArgs() throws AnalysisException {
        if (this.params_.size() == 0) {
            return Pair.create(null, null);
        }
        if (this.params_.size() == 1) {
            if (this.params_.get(0).getType().isStringType()) {
                return Pair.create(this.params_.get(0), null);
            }
            return Pair.create(null, this.params_.get(0));
        }
        if (this.params_.size() == 2) {
            return Pair.create(this.params_.get(0), this.params_.get(1));
        }
        throw new AnalysisException("Shutdown takes 0, 1 or 2 arguments: " + this.toSql());
    }

    private TNetworkAddress parseBackendAddress(String backend) throws AnalysisException {
        TNetworkAddress result = new TNetworkAddress();
        String[] toks = backend.trim().split(":");
        if (toks.length == 0 || toks.length > 2) {
            throw new AnalysisException("Invalid backend address: " + backend);
        }
        result.hostname = toks[0];
        result.port = 0;
        if (toks.length == 2) {
            try {
                result.port = Integer.parseInt(toks[1]);
            }
            catch (NumberFormatException nfe) {
                throw new AnalysisException("Invalid port number in backend address: " + backend);
            }
        }
        return result;
    }

    private void analyzeEventProcessorCmd(Analyzer analyzer) throws AnalysisException {
        this.registerPrivReq(analyzer);
        if (this.params_.isEmpty() || this.params_.size() > 2) {
            throw new AnalysisException("event_processor() takes 1 or 2 arguments: " + this.toSql());
        }
        if (!(this.params_.get(0) instanceof StringLiteral)) {
            throw new AnalysisException("First argument of event_processor() should be STRING");
        }
        this.action_ = ((StringLiteral)this.params_.get(0)).getStringValue().toUpperCase();
        if (this.params_.size() > 1) {
            this.event_id_ = this.params_.get(1).evalToInteger(analyzer, "event_id");
        }
    }

    @Override
    public boolean requiresHmsMetadata() {
        return false;
    }
}

