/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util.treevis;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class Visualizer {
    private static final Class<?>[] STD_SCALARS = new Class[]{Byte.class, Integer.class, Character.class, Long.class, Float.class, Double.class, String.class, Boolean.class, Enum.class, AtomicLong.class, BigDecimal.class, BigInteger.class};
    private TreeVisualizer treeVis_;
    private Set<Class<?>> scalarTypes_ = new HashSet();
    private Set<Class<?>> ignoreTypes_ = new HashSet();
    private Map<Object, Object> parents_ = new IdentityHashMap<Object, Object>();
    private int depthLimit_ = Integer.MAX_VALUE;

    public Visualizer(TreeVisualizer treeVis) {
        this.treeVis_ = treeVis;
        for (Class<?> c : STD_SCALARS) {
            this.scalarTypes_.add(c);
        }
    }

    public void ignore(Class<?> cls) {
        this.ignoreTypes_.add(cls);
    }

    public void scalar(Class<?> cls) {
        this.scalarTypes_.add(cls);
    }

    public void depthLimit(int limit) {
        this.depthLimit_ = limit;
    }

    public void visualize(Object root) {
        this.treeVis_.startObj("<root>", root);
        this.visit(root);
        this.treeVis_.endObj();
    }

    public void visit(Object obj) {
        Method customMethod;
        Class<?> objClass = obj.getClass();
        try {
            customMethod = objClass.getMethod("visualize", this.getClass());
        }
        catch (NoSuchMethodException e) {
            this.visualizeObj(obj);
            return;
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        try {
            customMethod.invoke(obj, this);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private void visualizeObj(Object obj) {
        Class<?> objClass = obj.getClass();
        this.visualizeMembers(obj, objClass);
    }

    private void visualizeMembers(Object obj, Class<?> objClass) {
        Field[] fields;
        if (objClass == Object.class) {
            return;
        }
        Class<?> parent = objClass.getSuperclass();
        this.visualizeMembers(obj, parent);
        for (Field field : fields = objClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            String name = field.getName();
            try {
                field.setAccessible(true);
                Object value = field.get(obj);
                this.visitValue(name, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                this.treeVis_.elide(name, obj, "Unavailable");
            }
        }
    }

    public void visitValue(String name, Object value) {
        if (value == null) {
            this.treeVis_.field(name, value);
            return;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass.isArray()) {
            this.visualizeArray(name, value);
            return;
        }
        if (this.scalarTypes_.contains(valueClass)) {
            this.treeVis_.field(name, value);
            return;
        }
        if (valueClass.isEnum()) {
            this.treeVis_.field(name, value);
            return;
        }
        if (this.ignoreTypes_.contains(valueClass)) {
            this.treeVis_.elide(name, value, "Skip");
            return;
        }
        if (this.parents_.containsKey(value)) {
            this.treeVis_.elide(name, value, "Back pointer");
            return;
        }
        if (this.parents_.size() >= this.depthLimit_) {
            this.treeVis_.elide(name, value, "...");
            return;
        }
        this.parents_.put(value, value);
        if (value instanceof Collection) {
            this.visitCollection(name, (Collection)value);
        } else {
            this.treeVis_.startObj(name, value);
            this.visit(value);
            this.treeVis_.endObj();
        }
        this.parents_.remove(value);
    }

    private void visualizeArray(String name, Object value) {
        int len = Array.getLength(value);
        if (len == 0) {
            this.treeVis_.emptyArray(name);
            return;
        }
        this.treeVis_.startArray(name);
        for (int i = 0; i < len; ++i) {
            this.visitValue(Integer.toString(i), Array.get(value, i));
        }
        this.treeVis_.endArray();
    }

    private void visitCollection(String name, Collection<?> col) {
        if (col.isEmpty()) {
            this.treeVis_.elide(name, col, "[]");
            return;
        }
        this.treeVis_.startArray(name);
        if (col instanceof Map) {
            Map map = (Map)((Object)col);
            for (Map.Entry entry : map.entrySet()) {
                this.visitValue(entry.getKey().toString(), entry.getValue());
            }
        } else {
            int i = 0;
            for (Object member : col) {
                this.visitValue(Integer.toString(i++), member);
            }
        }
        this.treeVis_.endArray();
    }

    public static interface TreeVisualizer {
        public void startObj(String var1, Object var2);

        public void startArray(String var1);

        public void field(String var1, Object var2);

        public void elide(String var1, Object var2, String var3);

        public void emptyArray(String var1);

        public void endArray();

        public void endObj();
    }
}

