/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util.treevis;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.impala.util.treevis.Visualizer;

public class TreePrinter
implements Visualizer.TreeVisualizer {
    private final PrintWriter out_;
    private final Deque<LevelType> levels_ = new ArrayDeque<LevelType>();

    public TreePrinter(PrintWriter out) {
        this.out_ = out;
    }

    @Override
    public void startObj(String name, Object obj) {
        this.objHeader(name, obj);
        this.out_.println("{");
        this.levels_.push(LevelType.OBJ);
    }

    private void objHeader(String name, Object obj) {
        this.indent();
        this.printName(name);
        this.out_.print(" (");
        this.out_.print(obj.getClass().getSimpleName());
        this.out_.print(", ");
        this.out_.print(System.identityHashCode(obj) % 1000);
        this.out_.print("): ");
    }

    private void printName(String name) {
        name = name.replaceAll("_$", "");
        this.out_.print(name);
    }

    @Override
    public void startArray(String name) {
        this.indent();
        this.printName(name);
        this.out_.println(": [");
        this.levels_.push(LevelType.ARRAY);
    }

    @Override
    public void field(String name, Object value) {
        this.indent();
        this.printName(name);
        this.out_.print(": ");
        if (value == null) {
            this.out_.println("<null>");
        } else if (value instanceof String) {
            this.out_.print("\"");
            this.out_.print(value);
            this.out_.println("\"");
        } else {
            this.out_.println(value.toString());
        }
    }

    @Override
    public void endArray() {
        Preconditions.checkState((!this.levels_.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this.levels_.peek() == LevelType.ARRAY ? 1 : 0) != 0);
        this.levels_.pop();
        this.indent();
        this.out_.println("]");
    }

    @Override
    public void endObj() {
        Preconditions.checkState((!this.levels_.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this.levels_.peek() == LevelType.OBJ ? 1 : 0) != 0);
        this.levels_.pop();
        this.indent();
        this.out_.println("}");
    }

    private void indent() {
        for (int i = 0; i < this.levels_.size(); ++i) {
            this.out_.print(". ");
        }
    }

    @Override
    public void elide(String name, Object obj, String reason) {
        this.objHeader(name, obj);
        if (reason.equals("[]")) {
            this.out_.println(reason);
        } else {
            this.out_.print("<");
            this.out_.print(reason);
            this.out_.println(">");
        }
    }

    @Override
    public void emptyArray(String name) {
        this.indent();
        this.printName(name);
        this.out_.println(": []");
    }

    private static enum LevelType {
        OBJ,
        ARRAY;

    }
}

