/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util.treevis;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ParseNode;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.util.treevis.TreePrinter;
import org.apache.impala.util.treevis.Visualizer;

public class AstPrinter {
    public static final int NODE_DEPTH = 3;
    public static final int TREE_DEPTH = 20;
    private static ParseNode lastNode;

    public static void print(ParseNode node) {
        if (node == lastNode) {
            return;
        }
        AstPrinter.printTree(node, 3);
        lastNode = node;
    }

    public static void printNode(ParseNode node) {
        AstPrinter.printTree(node, 3);
    }

    public static void printTree(ParseNode node) {
        AstPrinter.printTree(node, 20);
    }

    public static void printTree(ParseNode node, int maxDepth) {
        Visualizer vis = new Visualizer(new TreePrinter(new PrintWriter((Writer)new OutputStreamWriter(System.out), true)));
        vis.ignore(TupleDescriptor.class);
        vis.ignore(HdfsTable.class);
        vis.ignore(Analyzer.class);
        vis.scalar(ScalarType.class);
        vis.scalar(Function.class);
        vis.scalar(ScalarFunction.class);
        vis.depthLimit(maxDepth);
        vis.visualize(node);
    }
}

