/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.impala.authorization.User;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.thrift.TErrorCode;
import org.apache.impala.thrift.TPoolConfig;
import org.apache.impala.thrift.TResolveRequestPoolParams;
import org.apache.impala.thrift.TResolveRequestPoolResult;
import org.apache.impala.util.RequestPoolService;
import org.apache.impala.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.impala.yarn.server.resourcemanager.scheduler.fair.AllocationFileLoaderService;
import org.apache.impala.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TestRequestPoolService {
    private static final String ALLOCATION_FILE = "fair-scheduler-test.xml";
    private static final String ALLOCATION_FILE_MODIFIED = "fair-scheduler-test2.xml";
    private static final String ALLOCATION_FILE_EXTRA = "fair-scheduler-test3.xml";
    private static final String ALLOCATION_FILE_EMPTY = "fair-scheduler-empty.xml";
    private static final String ALLOCATION_FILE_GROUP_RULE = "fair-scheduler-group-rule.xml";
    private static final String LLAMA_CONFIG_FILE = "llama-site-test.xml";
    private static final String LLAMA_CONFIG_FILE_MODIFIED = "llama-site-test2.xml";
    private static final String LLAMA_CONFIG_FILE_EMPTY = "llama-site-empty.xml";
    private static final long CHECK_INTERVAL_MS = 100L;
    public static final List<String> EMPTY_LIST = Collections.emptyList();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private RequestPoolService poolService_;
    private File allocationConfFile_;
    private File llamaConfFile_;

    private void createPoolService(String allocationFile, String llamaConfFile) throws Exception {
        this.allocationConfFile_ = this.tempFolder.newFile();
        Files.copy((File)this.getClasspathFile(allocationFile), (File)this.allocationConfFile_);
        String llamaConfPath = null;
        if (llamaConfFile != null) {
            this.llamaConfFile_ = this.tempFolder.newFile();
            Files.copy((File)this.getClasspathFile(llamaConfFile), (File)this.llamaConfFile_);
            llamaConfPath = this.llamaConfFile_.getAbsolutePath();
        }
        this.poolService_ = RequestPoolService.getInstance((String)this.allocationConfFile_.getAbsolutePath(), llamaConfPath, (boolean)true);
        Field f = AllocationFileLoaderService.class.getDeclaredField("reloadIntervalMs");
        f.setAccessible(true);
        f.set(this.poolService_.allocLoader_, 100L);
        if (llamaConfFile != null) {
            this.poolService_.confWatcher_.setCheckIntervalMs(100L);
        }
        this.poolService_.start();
        QueuePlacementPolicy policy = this.poolService_.getAllocationConfig().getPlacementPolicy();
        Configuration conf = policy.getConf();
        Assert.assertTrue((boolean)conf.getBoolean("impala.core-site.overridden", false));
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        RuntimeEnv.INSTANCE.setTestEnv(true);
        User.setRulesForTesting((String)new Configuration().get("hadoop.security.auth_to_local", "DEFAULT"));
    }

    @AfterClass
    public static void cleanUpClass() {
        RuntimeEnv.INSTANCE.reset();
    }

    @After
    public void cleanUp() throws Exception {
        if (this.poolService_ != null && this.poolService_.isRunning()) {
            this.poolService_.stop();
        }
    }

    private File getClasspathFile(String filename) throws URISyntaxException {
        return new File(this.getClass().getClassLoader().getResource(filename).toURI());
    }

    @Test
    public void testPoolResolution() throws Exception {
        this.createPoolService(ALLOCATION_FILE, LLAMA_CONFIG_FILE);
        Assert.assertEquals((Object)"root.queueA", (Object)this.poolService_.assignToPool("root.queueA", "userA"));
        Assert.assertNull((Object)this.poolService_.assignToPool("nonexistentQueue", "userA"));
    }

    @Test
    public void testResolvePrincipalName() throws Exception {
        this.createPoolService(ALLOCATION_FILE, LLAMA_CONFIG_FILE);
        TResolveRequestPoolResult result = this.poolService_.resolveRequestPool(new TResolveRequestPoolParams("userA@abc.com", "root.queueA"));
        Assert.assertEquals((Object)TErrorCode.OK, (Object)result.getStatus().getStatus_code());
        Assert.assertEquals((Object)"root.queueA", (Object)result.getResolved_pool());
        result = this.poolService_.resolveRequestPool(new TResolveRequestPoolParams("userA/a.qualified.domain@abc.com", "root.queueA"));
        Assert.assertEquals((Object)TErrorCode.OK, (Object)result.getStatus().getStatus_code());
        Assert.assertEquals((Object)"root.queueA", (Object)result.getResolved_pool());
    }

    @Test
    public void testUserNoGroupsError() throws Exception {
        this.createPoolService(ALLOCATION_FILE_GROUP_RULE, LLAMA_CONFIG_FILE);
        TResolveRequestPoolResult result = this.poolService_.resolveRequestPool(new TResolveRequestPoolParams("userA", "root.NOT_A_POOL"));
        Assert.assertEquals((Object)false, (Object)result.isSetResolved_pool());
        Assert.assertEquals((Object)false, (Object)result.isSetHas_access());
        Assert.assertEquals((Object)TErrorCode.INTERNAL_ERROR, (Object)result.getStatus().getStatus_code());
        String expectedMessage = "Failed to resolve user 'userA' to a pool while evaluating the 'primaryGroup' or 'secondaryGroup' queue placement rules because no groups were found for the user. This is likely because the user does not exist on the local operating system.";
        Assert.assertEquals((Object)expectedMessage, (Object)Iterables.getOnlyElement((Iterable)result.getStatus().getError_msgs()));
    }

    @Test
    public void testPoolAcls() throws Exception {
        this.createPoolService(ALLOCATION_FILE, LLAMA_CONFIG_FILE);
        this.checkPoolAcls("root.queueA", Arrays.asList("userA", "userB", "userZ"), EMPTY_LIST);
        this.checkPoolAcls("root.queueB", Arrays.asList("userB", "root"), Arrays.asList("userA", "userZ"));
        this.checkPoolAcls("root.queueD", Arrays.asList("userB", "userA"), Arrays.asList("userZ"));
    }

    private static boolean containsSubstring(List<String> list, String substring) {
        for (String str : list) {
            if (!str.contains(substring)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testBadConfiguration() {
        List<String> bad_configs = Arrays.asList("duplicate_user_limit_at_leaf.xml", "duplicate_user_limit_at_root.xml", "duplicate_group_limit_at_leaf.xml", "duplicate_group_limit_at_root.xml");
        List<String> expected_errors = Arrays.asList("Duplicate entry for user 'alice' in pool 'root.group-set-small' has multiple values 4 and 5", "Duplicate entry for user 'alice' in pool 'root' has multiple values 4 and 5", "Duplicate entry for group 'it' in pool 'root.group-set-small' has multiple values 2 and 3", "Duplicate entry for group 'it' in pool 'root' has multiple values 2 and 3");
        for (int i = 0; i < bad_configs.size(); ++i) {
            String config = bad_configs.get(i);
            String expected_error = expected_errors.get(i);
            try {
                this.createPoolService("bad_configurations/" + config, LLAMA_CONFIG_FILE);
                Assert.fail((String)"should have got exception");
                continue;
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains(expected_error));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVerifyConfiguration() throws Exception {
        Logger logger = Logger.getLogger(AllocationFileLoaderService.class);
        ReadableAppender logAppender = new ReadableAppender();
        logger.addAppender((Appender)logAppender);
        try {
            List<String> expected_messages = Arrays.asList("Completed loading allocation file", "Potential misconfiguration in queue 'root.group-set-small': the user limit for 'howard' of 100 is greater than the root limit 4 and so will have no effect", "Potential misconfiguration in queue 'root.group-set-small': the user limit for '*' of 12 is greater than the root limit 8 and so will have no effect", "Potential misconfiguration in queue 'root.group-set-small': the group limit for 'support' of 10 is greater than the root limit 6 and so will have no effect", "Potential misconfiguration in queue 'root.group-set-small': no aclSubmitApps permissions were found, this will prevent query submission on this queue");
            this.createPoolService("bad_configurations/warnings-fair-scheduler-test.xml", LLAMA_CONFIG_FILE);
            List<String> messages = logAppender.getMessages();
            for (String expected_warning : expected_messages) {
                Assert.assertTrue((String)("missing message: " + expected_warning + " in " + messages), (boolean)TestRequestPoolService.containsSubstring(messages, expected_warning));
            }
        }
        finally {
            logger.removeAppender((Appender)logAppender);
        }
    }

    private void checkPoolAcls(String queueName, List<String> allowedUsers, List<String> deniedUsers) throws InternalException {
        for (String allowed : allowedUsers) {
            Assert.assertTrue((boolean)this.poolService_.hasAccess(queueName, allowed));
        }
        for (String denied : deniedUsers) {
            Assert.assertFalse((boolean)this.poolService_.hasAccess(queueName, denied));
        }
    }

    @Test
    public void testPoolLimitConfigs() throws Exception {
        this.createPoolService(ALLOCATION_FILE, LLAMA_CONFIG_FILE);
        HashMap<String, Integer> rootUserQueryLimits = new HashMap<String, Integer>();
        rootUserQueryLimits.put("userB", 6);
        rootUserQueryLimits.put("*", 10);
        HashMap<String, Integer> rootGroupQueryLimits = new HashMap<String, Integer>();
        rootGroupQueryLimits.put("group3", 5);
        this.checkPoolConfigResult("root", 15L, 50L, -1L, 30000L, "mem_limit=1024m", rootUserQueryLimits, rootGroupQueryLimits);
        this.checkPoolConfigResult("root.queueA", 10L, 30L, 0x40000000L, 10000L, "mem_limit=1024m,query_timeout_s=10");
        this.checkPoolConfigResult("root.queueB", 5L, 10L, -1L, 30000L, "mem_limit=1024m");
        this.checkPoolConfigResult("root.queueC", 5L, 10L, 0x40000000L, 30000L, "mem_limit=1024m", 1000L, 10L, false, 8L, 8L, null, null, true);
        HashMap<String, Integer> queueDUserQueryLimits = new HashMap<String, Integer>();
        queueDUserQueryLimits.put("userA", 2);
        queueDUserQueryLimits.put("userF", 2);
        queueDUserQueryLimits.put("userG", 101);
        queueDUserQueryLimits.put("*", 3);
        HashMap<String, Integer> queueDGroupQueryLimits = new HashMap<String, Integer>();
        queueDGroupQueryLimits.put("group1", 1);
        queueDGroupQueryLimits.put("group2", 1);
        this.checkPoolConfigResult("root.queueD", 5L, 10L, -1L, 30000L, "mem_limit=1024m", queueDUserQueryLimits, queueDGroupQueryLimits);
    }

    @Test
    public void testDefaultConfigs() throws Exception {
        this.createPoolService(ALLOCATION_FILE_EMPTY, LLAMA_CONFIG_FILE_EMPTY);
        Assert.assertEquals((Object)"root.userA", (Object)this.poolService_.assignToPool("", "userA"));
        this.checkPoolAcls("root.userA", Arrays.asList("userA", "userB", "userZ"), EMPTY_LIST);
        this.checkPoolConfigResult("root", -1L, 200L, -1L, null, "", 0L, 0L, true, 0L, 0L, null, null, false);
    }

    @Ignore(value="IMPALA-4868")
    @Test
    public void testUpdatingConfigs() throws Exception {
        this.createPoolService(ALLOCATION_FILE, LLAMA_CONFIG_FILE);
        Thread.sleep(1000L);
        Files.copy((File)this.getClasspathFile(ALLOCATION_FILE_MODIFIED), (File)this.allocationConfFile_);
        Files.copy((File)this.getClasspathFile(LLAMA_CONFIG_FILE_MODIFIED), (File)this.llamaConfFile_);
        Thread.sleep(5100L);
        int numAttempts = 20;
        while (true) {
            try {
                this.checkModifiedConfigResults();
            }
            catch (AssertionError e) {
                if (numAttempts == 0) {
                    throw e;
                }
                --numAttempts;
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
    }

    @Test
    public void testModifiedConfigs() throws Exception {
        this.createPoolService(ALLOCATION_FILE_MODIFIED, LLAMA_CONFIG_FILE_MODIFIED);
        this.checkModifiedConfigResults();
    }

    @Test
    public void testReadUserGroupQuotas() throws Exception {
        this.createPoolService(ALLOCATION_FILE_EXTRA, null);
        TPoolConfig rootConfig = this.poolService_.getPoolConfig("root");
        HashMap<String, Integer> rootUserExpected = new HashMap<String, Integer>(){
            {
                this.put("*", 8);
                this.put("howard", 4);
                this.put("jade", 100);
            }
        };
        Assert.assertEquals((Object)rootUserExpected, (Object)rootConfig.user_query_limits);
        HashMap<String, Integer> rootGroupExpected = new HashMap<String, Integer>(){
            {
                this.put("support", 6);
            }
        };
        Assert.assertEquals((Object)rootGroupExpected, (Object)rootConfig.group_query_limits);
        TPoolConfig smallConfig = this.poolService_.getPoolConfig("root.group-set-small");
        HashMap<String, Integer> smallUserExpected = new HashMap<String, Integer>(){
            {
                this.put("*", 1);
                this.put("alice", 4);
                this.put("fiona", 3);
                this.put("howard", 100);
                this.put("jade", 8);
            }
        };
        Assert.assertEquals((Object)smallUserExpected, (Object)smallConfig.user_query_limits);
        HashMap<String, Integer> smallGroupExpected = new HashMap<String, Integer>(){
            {
                this.put("support", 5);
                this.put("dev", 5);
                this.put("it", 2);
            }
        };
        Assert.assertEquals((Object)smallGroupExpected, (Object)smallConfig.group_query_limits);
        TPoolConfig largeConfig = this.poolService_.getPoolConfig("root.group-set-large");
        HashMap<String, Integer> largeUserExpected = new HashMap<String, Integer>(){
            {
                this.put("*", 1);
                this.put("alice", 4);
                this.put("claire", 3);
            }
        };
        Assert.assertEquals((Object)largeUserExpected, (Object)largeConfig.user_query_limits);
        HashMap<String, Integer> largeGroupExpected = new HashMap<String, Integer>(){
            {
                this.put("support", 1);
                this.put("dev", 2);
            }
        };
        Assert.assertEquals((Object)largeGroupExpected, (Object)largeConfig.group_query_limits);
    }

    @Test
    public void testNullLlamaSite() throws Exception {
        this.createPoolService(ALLOCATION_FILE_MODIFIED, null);
        Assert.assertEquals((Object)"root.queueA", (Object)this.poolService_.assignToPool("queueA", "userA"));
        Assert.assertNull((Object)this.poolService_.assignToPool("queueX", "userA"));
        Assert.assertEquals((Object)"root.queueC", (Object)this.poolService_.assignToPool("queueC", "userA"));
        this.checkPoolAcls("root.queueA", Arrays.asList("userA", "userB"), EMPTY_LIST);
        this.checkPoolAcls("root.queueB", Arrays.asList("userA", "userB"), EMPTY_LIST);
        this.checkPoolAcls("root.queueC", Arrays.asList("userC", "root"), Arrays.asList("userA", "userB"));
        this.checkPoolAcls("root.queueD", Arrays.asList("userA", "userB"), EMPTY_LIST);
        HashMap<String, Integer> rootQueryLimits = new HashMap<String, Integer>();
        HashMap<String, Integer> rootGroupLimits = new HashMap<String, Integer>();
        rootQueryLimits.put("userD", 2);
        this.checkPoolConfigResult("root", -1L, 200L, -1L, null, "", rootQueryLimits, rootGroupLimits);
        this.checkPoolConfigResult("root.queueA", -1L, 200L, 104857600000L);
        this.checkPoolConfigResult("root.queueB", -1L, 200L, -1L);
        this.checkPoolConfigResult("root.queueC", -1L, 200L, 0x8000000L);
        HashMap<String, Integer> queueEUserQueryLimits = new HashMap<String, Integer>();
        queueEUserQueryLimits.put("userA", 3);
        queueEUserQueryLimits.put("userG", 3);
        queueEUserQueryLimits.put("userH", 0);
        queueEUserQueryLimits.put("*", 1);
        HashMap<String, Integer> queueEGroupQueryLimits = new HashMap<String, Integer>();
        queueEGroupQueryLimits.put("group1", 2);
        queueEGroupQueryLimits.put("group2", 2);
        this.checkPoolConfigResult("root.queueE", -1L, 200L, -1L, null, "", queueEUserQueryLimits, queueEGroupQueryLimits);
    }

    private static Map<String, Integer> doQueryLimitParsing(String xmlString, String name) throws ParserConfigurationException, SAXException, IOException, AllocationConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new ByteArrayInputStream(xmlString.getBytes()));
        Element rootElement = document.getDocumentElement();
        HashMap userQueryLimits = new HashMap();
        String queueName = "queue1";
        AllocationFileLoaderService.addQueryLimits((String)queueName, (Element)rootElement, (String)"userQueryLimit", userQueryLimits, (String)name);
        return (Map)userQueryLimits.get(queueName);
    }

    private static void assertFailureMessage(String xmlString, String expectedError) {
        try {
            TestRequestPoolService.doQueryLimitParsing(xmlString, "user");
            Assert.fail((String)("did not get expected exception, with expected message " + expectedError));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof AllocationConfigurationException));
            Assert.assertTrue((boolean)e.getMessage().contains(expectedError));
        }
    }

    @Test
    public void testLimitsParsing() throws Exception {
        String xmlString = String.join((CharSequence)"\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<userQueryLimit>", "    <user>John</user>", "    <totalCount>30</totalCount>", "</userQueryLimit>");
        HashMap<String, Integer> expected = new HashMap<String, Integer>(){
            {
                this.put("John", 30);
            }
        };
        Map<String, Integer> parsed = TestRequestPoolService.doQueryLimitParsing(xmlString, "user");
        Assert.assertEquals((Object)expected, parsed);
        String xmlString2 = String.join((CharSequence)"\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<userQueryLimit>", "    <user>John</user>", "    <user>Barry</user>", "    <totalCount>30</totalCount>", "</userQueryLimit>");
        HashMap<String, Integer> expected2 = new HashMap<String, Integer>(){
            {
                this.put("John", 30);
                this.put("Barry", 30);
            }
        };
        Map<String, Integer> parsed2 = TestRequestPoolService.doQueryLimitParsing(xmlString2, "user");
        Assert.assertEquals((Object)expected2, parsed2);
        String xmlString3 = String.join((CharSequence)"\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<groupQueryLimit>", "    <group>group1</group>", "    <group>group2</group>", "    <totalCount>1</totalCount>", "</groupQueryLimit>");
        HashMap<String, Integer> expected3 = new HashMap<String, Integer>(){
            {
                this.put("group1", 1);
                this.put("group2", 1);
            }
        };
        Map<String, Integer> parsed3 = TestRequestPoolService.doQueryLimitParsing(xmlString3, "group");
        Assert.assertEquals((Object)expected3, parsed3);
    }

    @Test
    public void testLimitsParsingErrors() throws Exception {
        String xmlString1 = String.join((CharSequence)"\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<userQueryLimit>", "    <totalCount>30</totalCount>", "</userQueryLimit>");
        TestRequestPoolService.assertFailureMessage(xmlString1, "Empty user names");
        String xmlString2 = String.join((CharSequence)"\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<userQueryLimit>", "    <user>John</user>", "    <user>Barry</user>", "    <totalCount>30</totalCount>", "    <totalCount>31</totalCount>", "</userQueryLimit>");
        TestRequestPoolService.assertFailureMessage(xmlString2, "Duplicate totalCount tags");
        String xmlString3 = String.join((CharSequence)"\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<userQueryLimit>", "    <user>John</user>", "    <user>Barry</user>", "    <totalCount>fish</totalCount>", "</userQueryLimit>");
        TestRequestPoolService.assertFailureMessage(xmlString3, "Could not parse query totalCount");
        String xmlString4 = String.join((CharSequence)"\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<userQueryLimit>", "    <user>John</user>", "    <user>Barry</user>", "</userQueryLimit>");
        TestRequestPoolService.assertFailureMessage(xmlString4, "No totalCount for");
        String xmlString5 = String.join((CharSequence)"\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<userQueryLimit>", "    <user>John</user>", "    <user>John</user>", "    <totalCount>30</totalCount>", "</userQueryLimit>");
        TestRequestPoolService.assertFailureMessage(xmlString5, "Duplicate value given for name");
    }

    private void checkModifiedConfigResults() throws InternalException, IOException {
        Assert.assertEquals((Object)"root.queueA", (Object)this.poolService_.assignToPool("queueA", "userA"));
        Assert.assertNull((Object)this.poolService_.assignToPool("queueX", "userA"));
        Assert.assertEquals((Object)"root.queueC", (Object)this.poolService_.assignToPool("queueC", "userA"));
        this.checkPoolAcls("root.queueA", Arrays.asList("userA", "userB"), EMPTY_LIST);
        this.checkPoolAcls("root.queueB", Arrays.asList("userA", "userB"), EMPTY_LIST);
        this.checkPoolAcls("root.queueC", Arrays.asList("userC", "root"), Arrays.asList("userA", "userB"));
        this.checkPoolAcls("root.queueD", Arrays.asList("userA", "userB"), EMPTY_LIST);
        HashMap<String, Integer> rootQueryLimits = new HashMap<String, Integer>();
        HashMap<String, Integer> rootGroupLimits = new HashMap<String, Integer>();
        rootQueryLimits.put("userD", 2);
        this.checkPoolConfigResult("root", 15L, 100L, -1L, 30000L, "", rootQueryLimits, rootGroupLimits);
        this.checkPoolConfigResult("root.queueA", 1L, 30L, 104857600000L, 50L, "mem_limit=128m,query_timeout_s=5,not_a_valid_option=foo.bar");
        this.checkPoolConfigResult("root.queueB", 5L, 10L, -1L, 600000L, "");
        this.checkPoolConfigResult("root.queueC", 10L, 30L, 0x8000000L, 30000L, "mem_limit=2048m,query_timeout_s=60");
    }

    private void checkPoolConfigResult(String pool, long expectedMaxRequests, long expectedMaxQueued, long expectedMaxMem, Long expectedQueueTimeoutMs, String expectedQueryOptions, long max_query_mem_limit, long min_query_mem_limit, boolean clamp_mem_limit_query_option, long max_query_cpu_core_per_node_limit, long max_query_cpu_core_coordinator_limit, Map<String, Integer> userQueryLimits, Map<String, Integer> groupQueryLimits, boolean onlyCoordinators) {
        TPoolConfig expectedResult = new TPoolConfig();
        expectedResult.setMax_requests(expectedMaxRequests);
        expectedResult.setMax_queued(expectedMaxQueued);
        expectedResult.setMax_mem_resources(expectedMaxMem);
        expectedResult.setMax_query_mem_limit(max_query_mem_limit);
        expectedResult.setMin_query_mem_limit(min_query_mem_limit);
        expectedResult.setClamp_mem_limit_query_option(clamp_mem_limit_query_option);
        expectedResult.setMax_query_cpu_core_per_node_limit(max_query_cpu_core_per_node_limit);
        expectedResult.setMax_query_cpu_core_coordinator_limit(max_query_cpu_core_coordinator_limit);
        if (expectedQueueTimeoutMs != null) {
            expectedResult.setQueue_timeout_ms(expectedQueueTimeoutMs.longValue());
        }
        if (expectedQueryOptions != null) {
            expectedResult.setDefault_query_options(expectedQueryOptions);
        }
        expectedResult.setUser_query_limits(userQueryLimits != null ? userQueryLimits : Collections.emptyMap());
        expectedResult.setGroup_query_limits(groupQueryLimits != null ? groupQueryLimits : Collections.emptyMap());
        expectedResult.setOnly_coordinators(onlyCoordinators);
        TPoolConfig poolConfig = this.poolService_.getPoolConfig(pool);
        Assert.assertEquals((String)("Unexpected config values for pool " + pool), (Object)expectedResult, (Object)poolConfig);
    }

    private void checkPoolConfigResult(String pool, long expectedMaxRequests, long expectedMaxQueued, long expectedMaxMem, Long expectedQueueTimeoutMs, String expectedQueryOptions) {
        this.checkPoolConfigResult(pool, expectedMaxRequests, expectedMaxQueued, expectedMaxMem, expectedQueueTimeoutMs, expectedQueryOptions, Collections.emptyMap(), Collections.emptyMap());
    }

    private void checkPoolConfigResult(String pool, long expectedMaxRequests, long expectedMaxQueued, long expectedMaxMem, Long expectedQueueTimeoutMs, String expectedQueryOptions, Map<String, Integer> userQueryLimits, Map<String, Integer> groupQueryLimits) {
        this.checkPoolConfigResult(pool, expectedMaxRequests, expectedMaxQueued, expectedMaxMem, expectedQueueTimeoutMs, expectedQueryOptions, 0L, 0L, true, 0L, 0L, userQueryLimits, groupQueryLimits, false);
    }

    private void checkPoolConfigResult(String pool, long expectedMaxRequests, long expectedMaxQueued, long expectedMaxMemUsage) {
        this.checkPoolConfigResult(pool, expectedMaxRequests, expectedMaxQueued, expectedMaxMemUsage, null, "");
    }

    private static class ReadableAppender
    extends AppenderSkeleton {
        List<String> messages = new ArrayList<String>();

        private ReadableAppender() {
        }

        protected void append(LoggingEvent loggingEvent) {
            this.messages.add(loggingEvent.getMessage().toString());
        }

        public List<String> getMessages() {
            return this.messages;
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }
}

