/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.apache.impala.util.DisjointSet;
import org.junit.Assert;
import org.junit.Test;

public class TestDisjointSet {
    @Test
    public void testMakeSet() throws Exception {
        DisjointSet ds = new DisjointSet();
        ds.makeSet((Object)1);
        Assert.assertTrue((boolean)ds.get((Object)1).contains(1));
        ds.makeSet((Object)2);
        Assert.assertTrue((boolean)ds.get((Object)2).contains(2));
        ds.checkConsistency();
        Set existingSet = ds.get((Object)1);
        existingSet.add(6);
        existingSet.add(7);
        try {
            ds.makeSet((Object)1);
            Assert.fail((String)"makeSet() on an item with an existing item set did not fail");
        }
        catch (Exception e) {
            Assert.assertTrue((existingSet == ds.get((Object)1) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)existingSet.contains(1));
            Assert.assertTrue((boolean)existingSet.contains(6));
            Assert.assertTrue((boolean)existingSet.contains(7));
        }
        try {
            ds.checkConsistency();
            Assert.fail((String)"Failed to detect an inconsistency in the DisjointSet data structure.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testUnion() throws Exception {
        DisjointSet ds = new DisjointSet();
        ds.makeSet((Object)1);
        Assert.assertFalse((boolean)ds.union((Object)1, (Object)1));
        Assert.assertTrue((ds.get((Object)1).contains(1) && ds.get((Object)1).size() == 1 ? 1 : 0) != 0);
        ds.checkConsistency();
        Assert.assertTrue((boolean)ds.union((Object)2, (Object)2));
        Assert.assertTrue((ds.get((Object)2).contains(2) && ds.get((Object)2).size() == 1 ? 1 : 0) != 0);
        ds.checkConsistency();
        Assert.assertTrue((boolean)ds.union((Object)3, (Object)4));
        Assert.assertTrue((ds.get((Object)3) == ds.get((Object)4) && ds.get((Object)3).contains(4) && ds.get((Object)4).contains(3) ? 1 : 0) != 0);
        ds.checkConsistency();
        Assert.assertFalse((boolean)ds.union((Object)3, (Object)4));
        Assert.assertTrue((ds.get((Object)3) == ds.get((Object)4) && ds.get((Object)3).contains(4) && ds.get((Object)4).contains(3) ? 1 : 0) != 0);
        ds.checkConsistency();
        Assert.assertTrue((boolean)ds.union((Object)4, (Object)5));
        Assert.assertTrue((ds.get((Object)4) == ds.get((Object)5) && ds.get((Object)4).contains(5) && ds.get((Object)4).containsAll(Lists.newArrayList((Object[])new Integer[]{3, 4, 5})) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ds.union((Object)6, (Object)4));
        Assert.assertTrue((ds.get((Object)4) == ds.get((Object)6) && ds.get((Object)6).contains(4) && ds.get((Object)4).containsAll(Lists.newArrayList((Object[])new Integer[]{3, 4, 5, 6})) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)ds.union((Object)4, (Object)6));
        ds.checkConsistency();
        Assert.assertTrue((boolean)ds.union((Object)1, (Object)2));
        Assert.assertTrue((ds.get((Object)1) == ds.get((Object)2) && ds.get((Object)1).containsAll(Lists.newArrayList((Object[])new Integer[]{1, 2})) ? 1 : 0) != 0);
        ds.checkConsistency();
        Assert.assertTrue((boolean)ds.union((Object)1, (Object)3));
        Assert.assertTrue((ds.get((Object)1) == ds.get((Object)3) && ds.get((Object)1).containsAll(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6})) ? 1 : 0) != 0);
        for (int i = 1; i <= 6; ++i) {
            for (int j = 1; j <= 6; ++j) {
                Assert.assertFalse((boolean)ds.union((Object)i, (Object)j));
            }
        }
        ds.checkConsistency();
    }

    @Test
    public void testBulkUnion() throws Exception {
        DisjointSet ds = new DisjointSet();
        Assert.assertTrue((boolean)ds.bulkUnion((Collection)Sets.newHashSet((Object[])new Integer[]{1})));
        Assert.assertTrue((ds.get((Object)1).contains(1) && ds.get((Object)1).size() == 1 ? 1 : 0) != 0);
        ds.checkConsistency();
        Assert.assertTrue((boolean)ds.bulkUnion((Collection)Sets.newHashSet((Object[])new Integer[]{2, 3, 4})));
        Assert.assertTrue((ds.get((Object)2) == ds.get((Object)3) && ds.get((Object)2) == ds.get((Object)4) && ds.get((Object)2).containsAll(Lists.newArrayList((Object[])new Integer[]{2, 3, 4})) ? 1 : 0) != 0);
        for (int i = 2; i <= 4; ++i) {
            for (int j = 2; j <= 4; ++j) {
                Assert.assertFalse((boolean)ds.union((Object)i, (Object)j));
                Assert.assertFalse((boolean)ds.bulkUnion((Collection)Sets.newHashSet((Object[])new Integer[]{i, j})));
            }
        }
        ds.checkConsistency();
        Assert.assertTrue((boolean)ds.bulkUnion((Collection)Sets.newHashSet((Object[])new Integer[]{5, 6, 7, 8})));
        Assert.assertTrue((ds.get((Object)5) == ds.get((Object)6) && ds.get((Object)6) == ds.get((Object)7) && ds.get((Object)7) == ds.get((Object)8) && ds.get((Object)5).containsAll(Lists.newArrayList((Object[])new Integer[]{5, 6, 7, 8})) ? 1 : 0) != 0);
        ds.checkConsistency();
        Assert.assertTrue((boolean)ds.bulkUnion((Collection)Sets.newHashSet((Object[])new Integer[]{1, 3, 8})));
        Assert.assertTrue((ds.get((Object)1) == ds.get((Object)2) && ds.get((Object)2) == ds.get((Object)3) && ds.get((Object)3) == ds.get((Object)4) && ds.get((Object)4) == ds.get((Object)5) && ds.get((Object)5) == ds.get((Object)6) && ds.get((Object)6) == ds.get((Object)7) && ds.get((Object)7) == ds.get((Object)8) && ds.get((Object)1).containsAll(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8})) ? 1 : 0) != 0);
        ds.checkConsistency();
    }

    @Test
    public void testUniqueSets() throws Exception {
        int i;
        DisjointSet ds = new DisjointSet();
        int uniqueElements = 100;
        for (i = 0; i < uniqueElements; i += 2) {
            ds.union((Object)i, (Object)(i + 1));
        }
        for (i = uniqueElements / 2; i < uniqueElements; ++i) {
            ds.union((Object)i, (Object)(i + 1));
        }
        ds.checkConsistency();
    }
}

