/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.util.TUniqueIdUtil;
import org.junit.Assert;
import org.junit.Test;

public class TUniqueIdUtilTest {
    @Test
    public void testUniqueId() {
        TUniqueId unique_id = new TUniqueId();
        unique_id.hi = -77195680861554825L;
        unique_id.lo = 0x2020202020202020L;
        String str = "feedbeeff00d7777:2020202020202020";
        Assert.assertEquals((Object)str, (Object)TUniqueIdUtil.PrintId((TUniqueId)unique_id));
        unique_id.lo = 32L;
        Assert.assertEquals((Object)"feedbeeff00d7777:20", (Object)TUniqueIdUtil.PrintId((TUniqueId)unique_id));
    }

    @Test
    public void QueryIdParsing() {
        try {
            TUniqueIdUtil.ParseId((String)"abcd");
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            TUniqueIdUtil.ParseId((String)"abcdabcdabcdabcdabcdabcdabcdabcda");
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            TUniqueIdUtil.ParseId((String)"zbcdabcdabcdabcd:abcdabcdabcdabcd");
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            TUniqueIdUtil.ParseId((String)"~bcdabcdabcdabcd:abcdabcdabcdabcd");
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            TUniqueIdUtil.ParseId((String)"abcdabcdabcdabcd:!bcdabcdabcdabcd");
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        TUniqueId id = TUniqueIdUtil.ParseId((String)"abcdabcdabcdabcd:abcdabcdabcdabcd");
        Assert.assertEquals((long)id.hi, (long)-6067004223159161907L);
        Assert.assertEquals((long)id.lo, (long)-6067004223159161907L);
        id = TUniqueIdUtil.ParseId((String)"abcdabcdabcdabcd:1234abcdabcd5678");
        Assert.assertEquals((long)id.hi, (long)-6067004223159161907L);
        Assert.assertEquals((long)id.lo, (long)1311862291310663288L);
        id = TUniqueIdUtil.ParseId((String)"cdabcdabcdabcd:1234abcdabcd5678");
        Assert.assertEquals((long)id.hi, (long)57891270064712653L);
        Assert.assertEquals((long)id.lo, (long)1311862291310663288L);
        id = TUniqueIdUtil.ParseId((String)"cdabcdabcdabcd:abcdabcd5678");
        Assert.assertEquals((long)id.hi, (long)57891270064712653L);
        Assert.assertEquals((long)id.lo, (long)188899839006328L);
    }
}

