/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.math.LongMath;
import org.apache.impala.util.MathUtil;
import org.junit.Assert;
import org.junit.Test;

public class MathUtilTest {
    @Test
    public void testSaturatingMultiply() {
        Assert.assertEquals((long)10L, (long)MathUtil.saturatingMultiply((long)2L, (long)5L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)MathUtil.saturatingMultiply((long)2L, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)MathUtil.saturatingMultiply((long)3L, (long)0x3FFFFFFFFFFFFFFFL));
        Assert.assertEquals((long)-10L, (long)MathUtil.saturatingMultiply((long)2L, (long)-5L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)MathUtil.saturatingMultiply((long)2L, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)MathUtil.saturatingMultiply((long)-3L, (long)0x3FFFFFFFFFFFFFFFL));
        Assert.assertEquals((long)10L, (long)MathUtil.saturatingMultiply((long)-2L, (long)-5L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)MathUtil.saturatingMultiply((long)-1L, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)MathUtil.saturatingMultiply((long)-922337203685477580L, (long)-100L));
    }

    @Test
    public void testPlanNodeMultiplyCardinalities() {
        long[] validCard = new long[]{0L, 1L, 2L, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE};
        long unknown = -1L;
        long invalid = -2L;
        for (long c1 : validCard) {
            for (long c2 : validCard) {
                Assert.assertEquals((String)(c1 + " * " + c2), (long)LongMath.saturatedMultiply((long)c1, (long)c2), (long)MathUtil.multiplyCardinalities((long)c1, (long)c2));
            }
        }
        for (long c : validCard) {
            Assert.assertEquals((String)(c + " * " + unknown), (long)unknown, (long)MathUtil.multiplyCardinalities((long)c, (long)unknown));
            Assert.assertEquals((String)(unknown + " * " + c), (long)unknown, (long)MathUtil.multiplyCardinalities((long)unknown, (long)c));
        }
        Assert.assertEquals((String)(unknown + " * " + unknown), (long)unknown, (long)MathUtil.multiplyCardinalities((long)unknown, (long)unknown));
        try {
            MathUtil.multiplyCardinalities((long)invalid, (long)1L);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("cardinality1 is invalid: -2"));
        }
        try {
            MathUtil.multiplyCardinalities((long)unknown, (long)invalid);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("cardinality2 is invalid: -2"));
        }
    }

    @Test
    public void testSaturatingAdd() {
        Assert.assertEquals((long)1234L, (long)MathUtil.saturatingAdd((long)1200L, (long)34L));
        Assert.assertEquals((long)-1L, (long)MathUtil.saturatingAdd((long)Long.MAX_VALUE, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)MathUtil.saturatingAdd((long)Long.MIN_VALUE, (long)-1L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)MathUtil.saturatingAdd((long)Long.MIN_VALUE, (long)-4611686018427387904L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)MathUtil.saturatingAdd((long)0x7FFFFFFFFFFFFFF5L, (long)11L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)MathUtil.saturatingAdd((long)Long.MAX_VALUE, (long)0x3FFFFFFFFFFFFFFFL));
    }

    @Test
    public void testPlanNodeAddCardinalities() {
        long[] validCard = new long[]{0L, 1L, 2L, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE};
        long unknown = -1L;
        long invalid = -2L;
        for (long c1 : validCard) {
            for (long c2 : validCard) {
                Assert.assertEquals((String)(c1 + " * " + c2), (long)LongMath.saturatedAdd((long)c1, (long)c2), (long)MathUtil.addCardinalities((long)c1, (long)c2));
            }
        }
        for (long c : validCard) {
            Assert.assertEquals((String)(c + " * " + unknown), (long)unknown, (long)MathUtil.addCardinalities((long)c, (long)unknown));
            Assert.assertEquals((String)(unknown + " * " + c), (long)unknown, (long)MathUtil.addCardinalities((long)unknown, (long)c));
        }
        Assert.assertEquals((String)(unknown + " * " + unknown), (long)unknown, (long)MathUtil.addCardinalities((long)unknown, (long)unknown));
        try {
            MathUtil.addCardinalities((long)invalid, (long)1L);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("cardinality1 is invalid: -2"));
        }
        try {
            MathUtil.addCardinalities((long)unknown, (long)invalid);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("cardinality2 is invalid: -2"));
        }
    }

    @Test
    public void testSmallestValidCardinality() {
        long[] validCard = new long[]{0L, 1L, Long.MAX_VALUE};
        long unknown = -1L;
        long invalid = -2L;
        for (long c1 : validCard) {
            for (long c2 : validCard) {
                Assert.assertEquals((String)(c1 + " vs " + c2), (long)Math.min(c1, c2), (long)MathUtil.smallestValidCardinality((long)c1, (long)c2));
            }
        }
        for (long c : validCard) {
            Assert.assertEquals((String)(c + " vs " + unknown), (long)c, (long)MathUtil.smallestValidCardinality((long)c, (long)unknown));
            Assert.assertEquals((String)(unknown + " vs " + c), (long)c, (long)MathUtil.smallestValidCardinality((long)unknown, (long)c));
        }
        Assert.assertEquals((String)(unknown + " vs " + unknown), (long)unknown, (long)MathUtil.smallestValidCardinality((long)unknown, (long)unknown));
        try {
            MathUtil.smallestValidCardinality((long)invalid, (long)1L);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("cardinality1 is invalid: -2"));
        }
        try {
            MathUtil.smallestValidCardinality((long)unknown, (long)invalid);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("cardinality2 is invalid: -2"));
        }
    }
}

