/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.util.KuduUtil;
import org.apache.kudu.client.KuduClient;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class KuduUtilTest {
    private static TBackendGflags origFlags;

    @BeforeClass
    public static void setup() {
        if (BackendConfig.INSTANCE == null) {
            BackendConfig.create((TBackendGflags)new TBackendGflags());
        }
        origFlags = BackendConfig.INSTANCE.getBackendCfg();
    }

    @AfterClass
    public static void teardown() {
        BackendConfig.create((TBackendGflags)origFlags);
    }

    @Test
    public void testGetKuduClient() {
        int size = KuduUtil.getkuduClientsSize();
        int concurrent = 5;
        final CountDownLatch latch = new CountDownLatch(concurrent);
        final CopyOnWriteArrayList clients = new CopyOnWriteArrayList();
        for (int i = 0; i < concurrent; ++i) {
            new Thread(){

                @Override
                public void run() {
                    KuduClient client = KuduUtil.getKuduClient((String)"master0");
                    clients.add(client);
                    latch.countDown();
                }
            }.start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (int i = 1; i < concurrent; ++i) {
            Assert.assertSame(clients.get(0), clients.get(i));
        }
        KuduUtil.getKuduClient((String)"master1");
        Assert.assertEquals((long)(size + 2), (long)KuduUtil.getkuduClientsSize());
    }
}

