/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import java.util.List;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.thrift.TCacheJarParams;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.junit.Assert;
import org.junit.Test;

public class JniUtilTest {
    private static TBinaryProtocol.Factory protocolFactory_ = new TBinaryProtocol.Factory();

    @Test
    public void testSerializeToThrift() throws ImpalaException {
        TCacheJarParams testObject = new TCacheJarParams("test string");
        byte[] testObjBytes = JniUtil.serializeToThrift((TBase)testObject, (TProtocolFactory)protocolFactory_);
        TCacheJarParams deserializedTestObj = new TCacheJarParams();
        JniUtil.deserializeThrift((TProtocolFactory)protocolFactory_, (TBase)deserializedTestObj, (byte[])testObjBytes);
        Assert.assertEquals((Object)deserializedTestObj.hdfs_location, (Object)"test string");
    }

    private static void assertSingleGroup(String group, List<String> list) {
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)group, (Object)list.get(0));
    }

    private static void assertEmpty(List<String> list) {
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void testDecodeInjectedGroups() {
        JniUtilTest.assertEmpty(JniUtil.decodeInjectedGroups(null, (String)"andrew"));
        JniUtilTest.assertEmpty(JniUtil.decodeInjectedGroups((String)"a_group", null));
        String admissionTestFlags = "group0:userA;group1:user1,user3;dev:alice,deborah;it:bob,fiona;support:claire,geeta,howard;";
        JniUtilTest.assertEmpty(JniUtil.decodeInjectedGroups((String)admissionTestFlags, (String)"boris"));
        JniUtilTest.assertSingleGroup("group1", JniUtil.decodeInjectedGroups((String)admissionTestFlags, (String)"user1"));
        JniUtilTest.assertSingleGroup("group1", JniUtil.decodeInjectedGroups((String)admissionTestFlags, (String)"user3"));
        JniUtilTest.assertSingleGroup("dev", JniUtil.decodeInjectedGroups((String)admissionTestFlags, (String)"deborah"));
        JniUtilTest.assertSingleGroup("dev", JniUtil.decodeInjectedGroups((String)admissionTestFlags, (String)"alice"));
        JniUtilTest.assertSingleGroup("it", JniUtil.decodeInjectedGroups((String)admissionTestFlags, (String)"fiona"));
        JniUtilTest.assertSingleGroup("it", JniUtil.decodeInjectedGroups((String)admissionTestFlags, (String)"bob"));
        JniUtilTest.assertSingleGroup("support", JniUtil.decodeInjectedGroups((String)admissionTestFlags, (String)"claire"));
        JniUtilTest.assertSingleGroup("support", JniUtil.decodeInjectedGroups((String)admissionTestFlags, (String)"geeta"));
        JniUtilTest.assertSingleGroup("support", JniUtil.decodeInjectedGroups((String)admissionTestFlags, (String)"howard"));
        String multiGroupString = "group1:user1;group2:user1,user2,user3";
        List groups = JniUtil.decodeInjectedGroups((String)multiGroupString, (String)"user1");
        Assert.assertEquals((long)2L, (long)groups.size());
        Assert.assertTrue((boolean)groups.contains("group1"));
        Assert.assertTrue((boolean)groups.contains("group2"));
    }
}

