/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.util.JMXJsonUtil;
import org.junit.Assert;
import org.junit.Test;

public class JMXJsonUtilTest {
    @Test
    public void testJMXMetrics() throws ImpalaException {
        String jmxJson = JMXJsonUtil.getJMXJson();
        JsonNode rootNode = null;
        try {
            rootNode = new ObjectMapper().readTree(jmxJson);
        }
        catch (IOException e) {
            Assert.fail((String)("Invalid JSON returned by getMxJson(): " + jmxJson));
        }
        Preconditions.checkNotNull((Object)rootNode);
        Assert.assertTrue((String)("Invalid JSON: " + jmxJson), (boolean)rootNode.hasNonNull("beans"));
        List values = rootNode.get("beans").findValuesAsText("name");
        Assert.assertTrue((String)("Invalid JSON: " + jmxJson), (values.contains("java.lang:type=MemoryPool,name=Metaspace") || values.contains("java.lang:name=Metaspace,type=MemoryPool") ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid JSON: " + jmxJson), (boolean)values.contains("java.lang:type=Runtime"));
    }
}

