/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.impala.analysis.IcebergPartitionField;
import org.apache.impala.analysis.IcebergPartitionSpec;
import org.apache.impala.analysis.IcebergPartitionTransform;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.iceberg.IcebergCatalog;
import org.apache.impala.catalog.iceberg.IcebergCatalogs;
import org.apache.impala.catalog.iceberg.IcebergHadoopCatalog;
import org.apache.impala.catalog.iceberg.IcebergHadoopTables;
import org.apache.impala.catalog.iceberg.IcebergHiveCatalog;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.THdfsFileFormat;
import org.apache.impala.thrift.TIcebergCatalog;
import org.apache.impala.thrift.TIcebergFileFormat;
import org.apache.impala.thrift.TIcebergPartitionTransformType;
import org.apache.impala.util.IcebergUtil;
import org.junit.Assert;
import org.junit.Test;

public class IcebergUtilTest {
    public static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"i", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"l", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())});
    protected static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).bucket("data", 10).build();
    static final DataFile FILE_A = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=0").withRecordCount(1L).build();

    @Test
    public void testGetCatalog() throws ImpalaRuntimeException {
        CatalogMapping[] mappings;
        for (CatalogMapping testValue : mappings = new CatalogMapping[]{new CatalogMapping("hadoop.tables", TIcebergCatalog.HADOOP_TABLES, IcebergHadoopTables.class), new CatalogMapping("hadoop.catalog", TIcebergCatalog.HADOOP_CATALOG, IcebergHadoopCatalog.class), new CatalogMapping("hive.catalog", TIcebergCatalog.HIVE_CATALOG, IcebergHiveCatalog.class), new CatalogMapping(null, TIcebergCatalog.HIVE_CATALOG, IcebergHiveCatalog.class), new CatalogMapping("other string", TIcebergCatalog.CATALOGS, IcebergCatalogs.class)}) {
            TIcebergCatalog catalog = IcebergUtil.getTIcebergCatalog((String)testValue.propertyName);
            Assert.assertEquals((String)("err for " + testValue.propertyName), (Object)testValue.catalog, (Object)catalog);
            IcebergCatalog impl = IcebergUtil.getIcebergCatalog((TIcebergCatalog)catalog, (String)"location");
            Assert.assertEquals((String)("err for " + testValue.propertyName), testValue.clazz, impl.getClass());
        }
    }

    @Test
    public void testGetIcebergTableIdentifier() {
        Table table = new Table();
        table.setParameters(new HashMap());
        String tableName = "table_name";
        table.setTableName(tableName);
        String dbname = "database_name";
        table.setDbName(dbname);
        TableIdentifier icebergTableIdentifier = IcebergUtil.getIcebergTableIdentifier((Table)table);
        Assert.assertEquals((Object)TableIdentifier.parse((String)"database_name.table_name"), (Object)icebergTableIdentifier);
        String nameId = "db.table";
        table.putToParameters("name", nameId);
        icebergTableIdentifier = IcebergUtil.getIcebergTableIdentifier((Table)table);
        Assert.assertEquals((Object)TableIdentifier.parse((String)nameId), (Object)icebergTableIdentifier);
        String tableId = "foo.bar";
        table.putToParameters("iceberg.table_identifier", tableId);
        icebergTableIdentifier = IcebergUtil.getIcebergTableIdentifier((Table)table);
        Assert.assertEquals((Object)TableIdentifier.parse((String)tableId), (Object)icebergTableIdentifier);
        table.putToParameters("iceberg.table_identifier", "noDatabase");
        icebergTableIdentifier = IcebergUtil.getIcebergTableIdentifier((Table)table);
        Assert.assertEquals((Object)TableIdentifier.parse((String)"default.noDatabase"), (Object)icebergTableIdentifier);
    }

    @Test
    public void testIsHiveCatalog() {
        CatalogType[] catalogTypes;
        for (CatalogType testValue : catalogTypes = new CatalogType[]{new CatalogType("hadoop.tables", false), new CatalogType("hadoop.catalog", false), new CatalogType("hive.catalog", true), new CatalogType(null, true), new CatalogType("other string", true)}) {
            Table table = new Table();
            table.putToParameters("iceberg.catalog", testValue.propertyName);
            Assert.assertEquals((String)("err in " + testValue.propertyName), (Object)testValue.isHiveCatalog, (Object)IcebergUtil.isHiveCatalog((Table)table));
        }
    }

    @Test
    public void testToHdfsFileFormat() {
        Assert.assertEquals((Object)THdfsFileFormat.ORC, (Object)IcebergUtil.toTHdfsFileFormat((TIcebergFileFormat)TIcebergFileFormat.ORC));
        Assert.assertEquals((Object)THdfsFileFormat.PARQUET, (Object)IcebergUtil.toTHdfsFileFormat((TIcebergFileFormat)TIcebergFileFormat.PARQUET));
        Assert.assertEquals((Object)HdfsFileFormat.ORC, (Object)IcebergUtil.toHdfsFileFormat((TIcebergFileFormat)TIcebergFileFormat.ORC));
        Assert.assertEquals((Object)HdfsFileFormat.PARQUET, (Object)IcebergUtil.toHdfsFileFormat((TIcebergFileFormat)TIcebergFileFormat.PARQUET));
        Assert.assertEquals((Object)HdfsFileFormat.ORC, (Object)IcebergUtil.toHdfsFileFormat((String)"ORC"));
        Assert.assertEquals((Object)HdfsFileFormat.PARQUET, (Object)IcebergUtil.toHdfsFileFormat((String)"PARQUET"));
        Assert.assertEquals((Object)HdfsFileFormat.PARQUET, (Object)IcebergUtil.toHdfsFileFormat((String)null));
        try {
            IcebergUtil.toHdfsFileFormat((String)"unknown");
            Assert.fail((String)"did not get expected assertion");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)TIcebergFileFormat.ORC, (Object)IcebergUtil.getIcebergFileFormat((String)"ORC"));
        Assert.assertEquals((Object)TIcebergFileFormat.PARQUET, (Object)IcebergUtil.getIcebergFileFormat((String)"PARQUET"));
        Assert.assertNull((Object)IcebergUtil.getIcebergFileFormat((String)"unknown"));
    }

    @Test
    public void testGetPartitionTransform() {
        PartitionTransform[] failAnalysis;
        PartitionTransform[] tableExceptions;
        PartitionTransform[] goodTransforms;
        for (PartitionTransform partitionTransform : goodTransforms = new PartitionTransform[]{new PartitionTransform("BUCKET", 5), new PartitionTransform("TRUNCATE", 4), new PartitionTransform("HOUR", null), new PartitionTransform("HOURS", null), new PartitionTransform("DAY", null), new PartitionTransform("DAYS", null), new PartitionTransform("MONTH", null), new PartitionTransform("MONTHS", null), new PartitionTransform("YEAR", null), new PartitionTransform("YEARS", null), new PartitionTransform("VOID", null), new PartitionTransform("IDENTITY", null)}) {
            IcebergPartitionTransform transform = null;
            try {
                transform = IcebergUtil.getPartitionTransform((String)partitionTransform.transformName, (Integer)partitionTransform.parameter);
            }
            catch (ImpalaRuntimeException t) {
                Assert.fail((String)("Transform " + partitionTransform + " caught unexpected  " + (Object)((Object)t)));
            }
            Assert.assertNotNull((Object)transform);
            try {
                transform.analyze(null);
            }
            catch (AnalysisException t) {
                Assert.fail((String)("Transform " + partitionTransform + " caught unexpected  " + (Object)((Object)t)));
            }
        }
        for (PartitionTransform partitionTransform : tableExceptions = new PartitionTransform[]{new PartitionTransform("JUNK", -5)}) {
            try {
                IcebergUtil.getPartitionTransform((String)partitionTransform.transformName, (Integer)partitionTransform.parameter);
                Assert.fail((String)("Transform " + partitionTransform + " should have got exception"));
            }
            catch (ImpalaRuntimeException t) {
                // empty catch block
            }
        }
        for (PartitionTransform partitionTransform : failAnalysis = new PartitionTransform[]{new PartitionTransform("BUCKET", -5), new PartitionTransform("TRUNCATE", -4)}) {
            IcebergPartitionTransform transform = null;
            try {
                transform = IcebergUtil.getPartitionTransform((String)partitionTransform.transformName, (Integer)partitionTransform.parameter);
            }
            catch (ImpalaRuntimeException t) {
                Assert.fail((String)("Transform " + partitionTransform + " caught unexpected  " + (Object)((Object)t)));
            }
            Assert.assertNotNull((Object)transform);
            try {
                transform.analyze(null);
                Assert.fail((String)("Transform " + partitionTransform + " should have got exception"));
            }
            catch (AnalysisException analysisException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGetDataFilePathHash() {
        String hash = IcebergUtil.getFilePathHash((ContentFile)FILE_A);
        Assert.assertNotNull((Object)hash);
        String hash2 = IcebergUtil.getFilePathHash((ContentFile)FILE_A);
        Assert.assertEquals((Object)hash, (Object)hash2);
    }

    @Test
    public void testGetPartitionTransformParams() {
        int numBuckets = 128;
        PartitionSpec partitionSpec = PartitionSpec.builderFor((Schema)SCHEMA).bucket("i", numBuckets).build();
        Map partitionTransformParams = IcebergUtil.getPartitionTransformParams((PartitionSpec)partitionSpec);
        Assert.assertNotNull((Object)partitionTransformParams);
        String expectedKey = "1_BUCKET";
        Assert.assertTrue((boolean)partitionTransformParams.containsKey(expectedKey));
        Assert.assertEquals((long)numBuckets, (long)((Integer)partitionTransformParams.get(expectedKey)).intValue());
    }

    @Test
    public void testIsPartitionColumn() {
        int fieldId = 3;
        IcebergColumn column = new IcebergColumn("name", (org.apache.impala.catalog.Type)org.apache.impala.catalog.Type.BOOLEAN, "comment", 0, fieldId, 5, 0, true);
        ArrayList fieldList = new ArrayList();
        IcebergPartitionSpec icebergPartitionSpec = new IcebergPartitionSpec(4, fieldList);
        Assert.assertFalse((boolean)IcebergUtil.isPartitionColumn((IcebergColumn)column, (IcebergPartitionSpec)icebergPartitionSpec));
        int id = 3;
        column = new IcebergColumn("name", (org.apache.impala.catalog.Type)org.apache.impala.catalog.Type.BOOLEAN, "comment", 0, id, 105, 0, true);
        IcebergPartitionTransform icebergPartitionTransform = new IcebergPartitionTransform(TIcebergPartitionTransformType.IDENTITY);
        IcebergPartitionField field = new IcebergPartitionField(id, 106, "name", "name", icebergPartitionTransform, column.getType());
        ImmutableList fieldList2 = ImmutableList.of((Object)field);
        IcebergPartitionSpec icebergPartitionSpec2 = new IcebergPartitionSpec(4, (List)fieldList2);
        Assert.assertTrue((boolean)IcebergUtil.isPartitionColumn((IcebergColumn)column, (IcebergPartitionSpec)icebergPartitionSpec2));
        IcebergColumn column2 = new IcebergColumn("name", (org.apache.impala.catalog.Type)org.apache.impala.catalog.Type.BOOLEAN, "comment", 0, 108, 105, 0, true);
        IcebergPartitionTransform icebergPartitionTransform2 = new IcebergPartitionTransform(TIcebergPartitionTransformType.IDENTITY);
        IcebergPartitionField field2 = new IcebergPartitionField(107, 106, "name", "name", icebergPartitionTransform2, column2.getType());
        ImmutableList fieldList3 = ImmutableList.of((Object)field2);
        IcebergPartitionSpec icebergPartitionSpec3 = new IcebergPartitionSpec(4, (List)fieldList3);
        Assert.assertFalse((boolean)IcebergUtil.isPartitionColumn((IcebergColumn)column2, (IcebergPartitionSpec)icebergPartitionSpec3));
    }

    @Test
    public void testGetDateTransformValue() {
        this.assertThrows(() -> IcebergUtil.getDateTimeTransformValue((TIcebergPartitionTransformType)TIcebergPartitionTransformType.IDENTITY, (String)"string"));
        this.assertThrows(() -> IcebergUtil.getDateTimeTransformValue((TIcebergPartitionTransformType)TIcebergPartitionTransformType.BUCKET, (String)"string"));
        this.assertThrows(() -> IcebergUtil.getDateTimeTransformValue((TIcebergPartitionTransformType)TIcebergPartitionTransformType.TRUNCATE, (String)"string"));
        this.assertThrows(() -> IcebergUtil.getDateTimeTransformValue((TIcebergPartitionTransformType)TIcebergPartitionTransformType.VOID, (String)"string"));
        this.assertThrows(() -> IcebergUtil.getDateTimeTransformValue((TIcebergPartitionTransformType)TIcebergPartitionTransformType.YEAR, (String)"2023-12"));
        this.assertThrows(() -> IcebergUtil.getDateTimeTransformValue((TIcebergPartitionTransformType)TIcebergPartitionTransformType.MONTH, (String)"2023"));
        this.assertThrows(() -> IcebergUtil.getDateTimeTransformValue((TIcebergPartitionTransformType)TIcebergPartitionTransformType.DAY, (String)"2023-12-12-1"));
        this.assertThrows(() -> IcebergUtil.getDateTimeTransformValue((TIcebergPartitionTransformType)TIcebergPartitionTransformType.HOUR, (String)"2023-12"));
        try {
            int yearTransformValidString = IcebergUtil.getDateTimeTransformValue((TIcebergPartitionTransformType)TIcebergPartitionTransformType.YEAR, (String)"2023");
            int monthTransformValidString = IcebergUtil.getDateTimeTransformValue((TIcebergPartitionTransformType)TIcebergPartitionTransformType.MONTH, (String)"2023-12");
            int dayTransformValidString = IcebergUtil.getDateTimeTransformValue((TIcebergPartitionTransformType)TIcebergPartitionTransformType.DAY, (String)"2023-12-12");
            int hourTransformValidString = IcebergUtil.getDateTimeTransformValue((TIcebergPartitionTransformType)TIcebergPartitionTransformType.HOUR, (String)"2023-12-12-1");
            Assert.assertEquals((long)53L, (long)yearTransformValidString);
            Assert.assertEquals((long)647L, (long)monthTransformValidString);
            Assert.assertEquals((long)19703L, (long)dayTransformValidString);
            Assert.assertEquals((long)472873L, (long)hourTransformValidString);
        }
        catch (ImpalaRuntimeException e) {
            Assert.fail((String)String.format("Unexpected parse error: %s", new Object[]{e}));
        }
    }

    private void assertThrows(DateTimeTransformCallable function) {
        try {
            function.call();
        }
        catch (ImpalaRuntimeException e) {
            Assert.assertEquals(ImpalaRuntimeException.class, ((Object)((Object)e)).getClass());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testComputeStatsProperty() {
        String empty = "";
        Assert.assertEquals((Object)empty, (Object)this.computeStatsPropertyRoundTrip(empty));
        String singleCols = "1:1234,2:1235,4:2345,5:2346";
        Assert.assertEquals((Object)singleCols, (Object)this.computeStatsPropertyRoundTrip(singleCols));
        String simpleRanges = "1-4:1234,6-10:2345";
        Assert.assertEquals((Object)simpleRanges, (Object)this.computeStatsPropertyRoundTrip(simpleRanges));
        String rangesToMerge = "1-4:1234,5-8:1234,10:2345";
        String mergedRanges = "1-8:1234,10:2345";
        Assert.assertEquals((Object)mergedRanges, (Object)this.computeStatsPropertyRoundTrip(rangesToMerge));
        String disjunctRanges = "1-4:1234,6-8:1234,10:2345";
        TreeMap disjunctRangesMap = IcebergUtil.ComputeStatsSnapshotPropertyConverter.stringToMap((String)disjunctRanges);
        disjunctRangesMap.put(5, 1234L);
        String completedRange = "1-8:1234,10:2345";
        Assert.assertEquals((Object)completedRange, (Object)IcebergUtil.ComputeStatsSnapshotPropertyConverter.mapToString((TreeMap)disjunctRangesMap));
        String rangeToSplit = "1-8:1234,10:2345";
        TreeMap rangeToSplitMap = IcebergUtil.ComputeStatsSnapshotPropertyConverter.stringToMap((String)rangeToSplit);
        rangeToSplitMap.put(4, 2345L);
        String splitRanges = "1-3:1234,4:2345,5-8:1234,10:2345";
        Assert.assertEquals((Object)splitRanges, (Object)IcebergUtil.ComputeStatsSnapshotPropertyConverter.mapToString((TreeMap)rangeToSplitMap));
        TreeMap emptyMap = new TreeMap();
        String invalid1 = "1:";
        Assert.assertEquals(emptyMap, (Object)IcebergUtil.ComputeStatsSnapshotPropertyConverter.stringToMap((String)invalid1));
        String invalid2 = "1:1234, 2:2345";
        Assert.assertEquals(emptyMap, (Object)IcebergUtil.ComputeStatsSnapshotPropertyConverter.stringToMap((String)invalid2));
        String invalid3 = ":1234";
        Assert.assertEquals(emptyMap, (Object)IcebergUtil.ComputeStatsSnapshotPropertyConverter.stringToMap((String)invalid3));
        String invalid4 = "1-3-5:1234";
        Assert.assertEquals(emptyMap, (Object)IcebergUtil.ComputeStatsSnapshotPropertyConverter.stringToMap((String)invalid4));
    }

    private String computeStatsPropertyRoundTrip(String property) {
        TreeMap map = IcebergUtil.ComputeStatsSnapshotPropertyConverter.stringToMap((String)property);
        return IcebergUtil.ComputeStatsSnapshotPropertyConverter.mapToString((TreeMap)map);
    }

    static class CatalogMapping {
        String propertyName;
        TIcebergCatalog catalog;
        Class<?> clazz;

        CatalogMapping(String propertyName, TIcebergCatalog catalog, Class<?> clazz) {
            this.propertyName = propertyName;
            this.catalog = catalog;
            this.clazz = clazz;
        }
    }

    static class CatalogType {
        String propertyName;
        boolean isHiveCatalog;

        CatalogType(String propertyName, boolean isHiveCatalog) {
            this.propertyName = propertyName;
            this.isHiveCatalog = isHiveCatalog;
        }
    }

    static class PartitionTransform {
        String transformName;
        Integer parameter;

        PartitionTransform(String transformName, Integer parameter) {
            this.transformName = transformName;
            this.parameter = parameter;
        }

        public String toString() {
            return "PartitionTransform{transformName='" + this.transformName + '\'' + ", parameter=" + this.parameter + '}';
        }
    }

    static interface DateTimeTransformCallable {
        public Integer call() throws ImpalaRuntimeException;
    }
}

